/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.operation.undo;

import java.util.ArrayList;
import java.util.List;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.operation.undo.XBUndoUpdateListener;
import org.exbin.xbup.parser_tree.XBTTreeDocument;

public class XBTLinearUndo
implements XBUndoHandler {
    private long undoMaximumCount;
    private long undoMaximumSize;
    private long usedSize;
    private long commandPosition;
    private long syncPointPosition = -1L;
    private final List<Command> commandList;
    private final XBTTreeDocument document;
    private final List<XBUndoUpdateListener> listeners = new ArrayList<XBUndoUpdateListener>();

    public XBTLinearUndo(XBTTreeDocument document) {
        this.document = document;
        this.undoMaximumCount = 1024L;
        this.undoMaximumSize = 65535L;
        this.commandList = new ArrayList<Command>();
        this.init();
    }

    @Override
    public void execute(Command command) throws Exception {
        command.execute();
        if (this.document != null) {
            this.document.processSpec();
        }
        this.addCommand(command);
    }

    @Override
    public void addCommand(Command command) {
        while ((long)this.commandList.size() > this.commandPosition) {
            this.commandList.remove((int)this.commandPosition);
        }
        this.commandList.add(command);
        ++this.commandPosition;
        this.undoUpdated();
        for (XBUndoUpdateListener listener : this.listeners) {
            listener.undoCommandAdded(command);
        }
    }

    @Override
    public void performUndo() throws Exception {
        this.performUndoInt();
        this.undoUpdated();
    }

    private void performUndoInt() throws Exception {
        --this.commandPosition;
        Command command = this.commandList.get((int)this.commandPosition);
        command.undo();
        if (this.document != null) {
            this.document.processSpec();
        }
    }

    @Override
    public void performRedo() throws Exception {
        this.performRedoInt();
        this.undoUpdated();
    }

    private void performRedoInt() throws Exception {
        Command command = this.commandList.get((int)this.commandPosition);
        command.redo();
        ++this.commandPosition;
        if (this.document != null) {
            this.document.processSpec();
        }
    }

    @Override
    public void performUndo(int count) throws Exception {
        if (this.commandPosition < (long)count) {
            throw new IllegalArgumentException("Unable to perform " + count + " undo steps");
        }
        while (count > 0) {
            this.performUndoInt();
            --count;
        }
        this.document.processSpec();
        this.undoUpdated();
    }

    @Override
    public void performRedo(int count) throws Exception {
        if ((long)this.commandList.size() - this.commandPosition < (long)count) {
            throw new IllegalArgumentException("Unable to perform " + count + " redo steps");
        }
        while (count > 0) {
            this.performRedoInt();
            --count;
        }
        this.document.processSpec();
        this.undoUpdated();
    }

    @Override
    public void clear() {
        this.init();
    }

    @Override
    public boolean canUndo() {
        return this.commandPosition > 0L;
    }

    @Override
    public boolean canRedo() {
        return (long)this.commandList.size() > this.commandPosition;
    }

    @Override
    public long getMaximumUndo() {
        return this.undoMaximumCount;
    }

    @Override
    public long getCommandPosition() {
        return this.commandPosition;
    }

    @Override
    public void doSync() throws Exception {
        this.setCommandPosition(this.syncPointPosition);
    }

    public void setUndoMaxCount(long maxUndo) {
        this.undoMaximumCount = maxUndo;
    }

    @Override
    public long getUndoMaximumSize() {
        return this.undoMaximumSize;
    }

    public void setUndoMaximumSize(long maxSize) {
        this.undoMaximumSize = maxSize;
    }

    @Override
    public long getUsedSize() {
        return this.usedSize;
    }

    @Override
    public long getSyncPoint() {
        return this.syncPointPosition;
    }

    @Override
    public void setSyncPoint(long syncPoint) {
        this.syncPointPosition = syncPoint;
    }

    @Override
    public void setSyncPoint() {
        this.syncPointPosition = this.commandPosition;
    }

    @Override
    public List<Command> getCommandList() {
        return this.commandList;
    }

    private void init() {
        this.usedSize = 0L;
        this.commandPosition = 0L;
        this.setSyncPoint(0L);
        this.commandList.clear();
    }

    @Override
    public void setCommandPosition(long targetPosition) throws Exception {
        if (targetPosition < this.commandPosition) {
            this.performUndo((int)(this.commandPosition - targetPosition));
        } else if (targetPosition > this.commandPosition) {
            this.performRedo((int)(targetPosition - this.commandPosition));
        }
    }

    private void undoUpdated() {
        for (XBUndoUpdateListener listener : this.listeners) {
            listener.undoCommandPositionChanged();
        }
    }

    @Override
    public void addUndoUpdateListener(XBUndoUpdateListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeUndoUpdateListener(XBUndoUpdateListener listener) {
        this.listeners.remove(listener);
    }
}

