/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.operation.undo;

import java.util.ArrayList;
import java.util.List;
import org.exbin.xbup.operation.XBDocOperation;
import org.exbin.xbup.parser_tree.XBTree;

public class XBLinearUndo {
    private long maxUndo;
    private long maxSize;
    private long usedSize;
    private long position;
    private long syncPoint;
    private final List<XBDocOperation> operationList;
    private final XBTree tree;

    public XBLinearUndo(XBTree tree) {
        this.tree = tree;
        this.maxUndo = 1024L;
        this.maxSize = 65535L;
        this.operationList = new ArrayList<XBDocOperation>();
        this.init();
    }

    public void performUndo() throws Exception {
        if (this.position == 0L) {
            throw new Exception("");
        }
        XBDocOperation op = this.operationList.get((int)this.position);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performRedo() throws Exception {
    }

    public void performUndo(int count) throws Exception {
        if (this.position < (long)count) {
            throw new IllegalArgumentException("Unable to perform " + count + " undo steps");
        }
        while (count > 0) {
            this.performUndo();
            --count;
        }
    }

    public void performRedo(int count) throws Exception {
        if ((long)this.operationList.size() - this.position < (long)count) {
            throw new IllegalArgumentException("Unable to perform " + count + " redo steps");
        }
        while (count > 0) {
            this.performUndo();
            --count;
        }
    }

    public void clear() {
        this.init();
    }

    private void init() {
        this.usedSize = 0L;
        this.position = 0L;
        this.setSyncPoint(0L);
        this.operationList.clear();
    }

    public boolean canUndo() {
        return this.position > 0L;
    }

    public boolean canRedo() {
        return (long)this.operationList.size() > this.position;
    }

    public long getMaxUndo() {
        return this.maxUndo;
    }

    public void doSync() {
    }

    public void setMaxUndo(long maxUndo) {
        this.maxUndo = maxUndo;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public String getDesc(XBDocOperation undoStep) {
        return undoStep.getCaption();
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public long getUsedSize() {
        return this.usedSize;
    }

    public long getSyncPoint() {
        return this.syncPoint;
    }

    public void setSyncPoint(long syncPoint) {
        this.syncPoint = syncPoint;
    }
}

