/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.ByteArrayDataInputStream;
import org.exbin.auxiliary.binary_data.OutOfBoundsException;

@ParametersAreNonnullByDefault
public class ByteArrayData
implements BinaryData {
    @Nonnull
    protected byte[] data;

    public ByteArrayData() {
        this(null);
    }

    public ByteArrayData(@Nullable byte[] data) {
        this.data = data != null ? data : new byte[]{};
    }

    @Nonnull
    byte[] getData() {
        return this.data;
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public long getDataSize() {
        return this.data.length;
    }

    @Override
    public byte getByte(long position) {
        try {
            return this.data[(int)position];
        }
        catch (IndexOutOfBoundsException ex) {
            throw new OutOfBoundsException(ex);
        }
    }

    @Override
    @Nonnull
    public BinaryData copy() {
        byte[] copy = Arrays.copyOf(this.data, this.data.length);
        return new ByteArrayData(copy);
    }

    @Override
    @Nonnull
    public BinaryData copy(long startFrom, long length) {
        if (startFrom + length > (long)this.data.length) {
            throw new OutOfBoundsException("Attemt to copy outside of data");
        }
        byte[] copy = Arrays.copyOfRange(this.data, (int)startFrom, (int)(startFrom + length));
        return new ByteArrayData(copy);
    }

    @Override
    public void copyToArray(long startFrom, byte[] target, int offset, int length) {
        try {
            System.arraycopy(this.data, (int)startFrom, target, offset, length);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new OutOfBoundsException(ex);
        }
    }

    @Override
    public void saveToStream(OutputStream outputStream) throws IOException {
        outputStream.write(this.data);
    }

    @Override
    @Nonnull
    public InputStream getDataInputStream() {
        return new ByteArrayDataInputStream(this);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            if (obj instanceof BinaryData) {
                BinaryData other = (BinaryData)obj;
                return this.compareTo(other);
            }
            return false;
        }
        ByteArrayData other = (ByteArrayData)obj;
        return Arrays.equals(this.data, other.data);
    }

    public boolean compareTo(BinaryData other) {
        int length;
        long dataSize = this.getDataSize();
        if (other.getDataSize() != dataSize) {
            return false;
        }
        int bufferSize = dataSize > 1024L ? 1024 : (int)dataSize;
        byte[] buffer = new byte[bufferSize];
        int offset = 0;
        for (int remain = (int)dataSize; remain > 0; remain -= length) {
            length = remain > bufferSize ? bufferSize : remain;
            other.copyToArray(offset, buffer, 0, length);
            for (int i = 0; i < length; ++i) {
                if (this.data[offset + i] == buffer[i]) continue;
                return false;
            }
            offset += length;
        }
        return true;
    }

    @Override
    public void dispose() {
    }
}

