/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.service;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Scanner;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEXFile;
import org.exbin.xbup.catalog.entity.XBEXHDoc;
import org.exbin.xbup.catalog.entity.manager.XBEXHDocManager;
import org.exbin.xbup.catalog.entity.service.XBEDefaultService;
import org.exbin.xbup.core.catalog.base.XBCExtension;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.XBCXHDoc;
import org.exbin.xbup.core.catalog.base.manager.XBCXHDocManager;
import org.exbin.xbup.core.catalog.base.service.XBCXFileService;
import org.exbin.xbup.core.catalog.base.service.XBCXHDocService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class XBEXHDocService
extends XBEDefaultService<XBCXHDoc>
implements XBCXHDocService,
Serializable {
    @Autowired
    private XBEXHDocManager manager;

    public XBEXHDocService() {
    }

    public XBEXHDocService(XBECatalog catalog) {
        super(catalog);
        this.itemManager = new XBEXHDocManager(catalog);
        catalog.addCatalogManager(XBCXHDocManager.class, (XBCXHDocManager)this.itemManager);
    }

    @PostConstruct
    public void init() {
        this.itemManager = this.manager;
    }

    public XBEXHDoc findById(Long id) {
        return ((XBEXHDocManager)this.itemManager).findById(id);
    }

    public Long getAllHDocsCount() {
        return ((XBEXHDocManager)this.itemManager).getAllHDocsCount();
    }

    public XBEXHDoc getDocumentation(XBCItem item) {
        return ((XBEXHDocManager)this.itemManager).getDocumentation(item);
    }

    public String getExtensionName() {
        return ((XBCExtension)this.itemManager).getExtensionName();
    }

    public void initializeExtension() {
        ((XBCExtension)this.itemManager).initializeExtension();
    }

    public String getDocumentationText(XBCItem item) {
        XBEXHDoc hdoc = this.getDocumentation(item);
        if (hdoc == null) {
            return null;
        }
        XBEXFile file = hdoc.getDocFile();
        if (file == null) {
            return null;
        }
        XBCXFileService fileService = this.catalog.getCatalogService(XBCXFileService.class);
        try {
            return new Scanner(fileService.getFile((XBCXFile)file)).useDelimiter("\\A").next();
        }
        catch (NoSuchElementException ex) {
            return "";
        }
    }

    public String getDocumentationBodyText(XBCItem item) {
        String text = this.getDocumentationText(item);
        if (text == null || text.isEmpty()) {
            return text;
        }
        int bodyPos = text.indexOf("<body");
        int startPos = text.indexOf(">", bodyPos + 5);
        int endPos = text.lastIndexOf("</body>");
        return text.substring(startPos + 1, endPos);
    }
}

