/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEBlockSpec;
import org.exbin.xbup.catalog.entity.XBEFormatSpec;
import org.exbin.xbup.catalog.entity.XBEGroupSpec;
import org.exbin.xbup.catalog.entity.XBESpec;
import org.exbin.xbup.catalog.entity.XBESpecDef;
import org.exbin.xbup.catalog.entity.manager.XBESpecManager;
import org.exbin.xbup.catalog.entity.service.XBEDefaultService;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.XBFormatDecl;
import org.exbin.xbup.core.block.declaration.XBGroupDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCFormatDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCGroupDecl;
import org.exbin.xbup.core.block.declaration.local.XBLBlockDecl;
import org.exbin.xbup.core.block.declaration.local.XBLFormatDecl;
import org.exbin.xbup.core.block.declaration.local.XBLGroupDecl;
import org.exbin.xbup.core.block.definition.XBBlockDef;
import org.exbin.xbup.core.block.definition.XBFormatDef;
import org.exbin.xbup.core.block.definition.XBFormatParam;
import org.exbin.xbup.core.block.definition.XBFormatParamConsist;
import org.exbin.xbup.core.block.definition.XBFormatParamJoin;
import org.exbin.xbup.core.block.definition.XBGroupDef;
import org.exbin.xbup.core.block.definition.XBGroupParam;
import org.exbin.xbup.core.block.definition.XBGroupParamConsist;
import org.exbin.xbup.core.block.definition.XBGroupParamJoin;
import org.exbin.xbup.core.block.definition.XBParamType;
import org.exbin.xbup.core.block.definition.catalog.XBCBlockDef;
import org.exbin.xbup.core.block.definition.catalog.XBCFormatDef;
import org.exbin.xbup.core.block.definition.catalog.XBCGroupDef;
import org.exbin.xbup.core.block.definition.local.XBLFormatDef;
import org.exbin.xbup.core.block.definition.local.XBLGroupDef;
import org.exbin.xbup.core.block.definition.local.XBLRevisionDef;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.catalog.base.XBCXDesc;
import org.exbin.xbup.core.catalog.base.XBCXHDoc;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.XBCXStri;
import org.exbin.xbup.core.catalog.base.manager.XBCSpecManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXDescManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXHDocManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXNameManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXStriManager;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class XBESpecService
extends XBEDefaultService<XBCSpec>
implements XBCSpecService,
Serializable {
    @Autowired
    private XBESpecManager manager;

    public XBESpecService() {
    }

    public XBESpecService(XBECatalog catalog) {
        super(catalog);
        this.itemManager = new XBESpecManager(catalog);
        catalog.addCatalogManager(XBCSpecManager.class, (XBCSpecManager)this.itemManager);
    }

    @PostConstruct
    public void init() {
        this.itemManager = this.manager;
    }

    public XBEBlockSpec findBlockSpecByXB(XBCNode node, long xbIndex) {
        return ((XBESpecManager)this.itemManager).findBlockSpecByXB(node, xbIndex);
    }

    public XBEFormatSpec findFormatSpecByXB(XBCNode node, long xbIndex) {
        return ((XBESpecManager)this.itemManager).findFormatSpecByXB(node, xbIndex);
    }

    public XBEGroupSpec findGroupSpecByXB(XBCNode node, long xbIndex) {
        return ((XBESpecManager)this.itemManager).findGroupSpecByXB(node, xbIndex);
    }

    public Long findMaxBlockSpecXB(XBCNode node) {
        return ((XBESpecManager)this.itemManager).findMaxBlockSpecXB(node);
    }

    public Long findMaxFormatSpecXB(XBCNode node) {
        return ((XBESpecManager)this.itemManager).findMaxFormatSpecXB(node);
    }

    public Long findMaxGroupSpecXB(XBCNode node) {
        return ((XBESpecManager)this.itemManager).findMaxGroupSpecXB(node);
    }

    public Long getAllBlockSpecsCount() {
        return ((XBESpecManager)this.itemManager).getAllBlockSpecsCount();
    }

    public Long getAllFormatSpecsCount() {
        return ((XBESpecManager)this.itemManager).getAllFormatSpecsCount();
    }

    public Long getAllGroupSpecsCount() {
        return ((XBESpecManager)this.itemManager).getAllGroupSpecsCount();
    }

    public Long getAllSpecsCount() {
        return ((XBESpecManager)this.itemManager).getAllSpecsCount();
    }

    public XBEBlockSpec getBlockSpec(XBCNode node, long index) {
        return ((XBESpecManager)this.itemManager).getBlockSpec(node, index);
    }

    public List<XBCBlockSpec> getBlockSpecs(XBCNode node) {
        return ((XBESpecManager)this.itemManager).getBlockSpecs(node);
    }

    public long getBlockSpecsCount(XBCNode node) {
        return ((XBESpecManager)this.itemManager).getBlockSpecsCount(node);
    }

    public XBEFormatSpec getFormatSpec(XBCNode node, long index) {
        return ((XBESpecManager)this.itemManager).getFormatSpec(node, index);
    }

    public List<XBCFormatSpec> getFormatSpecs(XBCNode node) {
        return ((XBESpecManager)this.itemManager).getFormatSpecs(node);
    }

    public long getFormatSpecsCount(XBCNode node) {
        return ((XBESpecManager)this.itemManager).getFormatSpecsCount(node);
    }

    public XBEGroupSpec getGroupSpec(XBCNode node, long index) {
        return ((XBESpecManager)this.itemManager).getGroupSpec(node, index);
    }

    public List<XBCGroupSpec> getGroupSpecs(XBCNode node) {
        return ((XBESpecManager)this.itemManager).getGroupSpecs(node);
    }

    public long getGroupSpecsCount(XBCNode node) {
        return ((XBESpecManager)this.itemManager).getGroupSpecsCount(node);
    }

    public XBESpec getSpecByOrder(XBCNode node, long index) {
        return ((XBESpecManager)this.itemManager).getSpec(node, index);
    }

    public Long[] getSpecXBPath(XBCSpec spec) {
        return ((XBESpecManager)this.itemManager).getSpecXBPath(spec);
    }

    public List<XBCSpec> getSpecs(XBCNode node) {
        return ((XBESpecManager)this.itemManager).getSpecs(node);
    }

    public long getSpecsCount(XBCNode node) {
        return ((XBESpecManager)this.itemManager).getSpecsCount(node);
    }

    public XBESpecDef findSpecDefByXB(XBCSpec spec, long xbIndex) {
        return ((XBESpecManager)this.itemManager).findSpecDefByXB(spec, xbIndex);
    }

    public Long findMaxSpecDefXB(XBCSpec spec) {
        return ((XBESpecManager)this.itemManager).findMaxSpecDefXB(spec);
    }

    public XBESpecDef getSpecDefByOrder(XBCSpec spec, long index) {
        return ((XBESpecManager)this.itemManager).getSpecDefByOrder(spec, index);
    }

    public List<XBCSpecDef> getSpecDefs(XBCSpec spec) {
        return ((XBESpecManager)this.itemManager).getSpecDefs(spec);
    }

    public long getSpecDefsCount(XBCSpec spec) {
        return ((XBESpecManager)this.itemManager).getSpecDefsCount(spec);
    }

    public long getDefsCount() {
        return ((XBESpecManager)this.itemManager).getDefsCount();
    }

    public XBESpecDef getSpecDef(long itemId) {
        return (XBESpecDef)((XBESpecManager)this.itemManager).getSpecDef(itemId);
    }

    public XBCSpecDef createSpecDef(XBCSpec spec, XBParamType type) {
        return ((XBESpecManager)this.itemManager).createSpecDef(spec, type);
    }

    public XBEBlockSpec createBlockSpec() {
        return ((XBESpecManager)this.itemManager).createBlockSpec();
    }

    public XBCGroupSpec createGroupSpec() {
        return ((XBESpecManager)this.itemManager).createGroupSpec();
    }

    public XBCFormatSpec createFormatSpec() {
        return ((XBESpecManager)this.itemManager).createFormatSpec();
    }

    public void persistSpecDef(XBCSpecDef specDef) {
        ((XBESpecManager)this.itemManager).persistSpecDef(specDef);
    }

    public void removeSpecDef(XBCSpecDef specDef) {
        ((XBESpecManager)this.itemManager).removeSpecDef(specDef);
    }

    public void removeItemDepth(XBCSpecDef specDef) {
        XBCXHDocManager hdocManager;
        XBCXHDoc itemHDoc;
        XBCXNameManager nameManager = this.catalog.getCatalogManager(XBCXNameManager.class);
        List itemNames = nameManager.getItemNames((XBCItem)specDef);
        for (XBCXName itemName : itemNames) {
            nameManager.removeItem((XBCBase)itemName);
        }
        XBCXDescManager descManager = this.catalog.getCatalogManager(XBCXDescManager.class);
        List itemDescs = descManager.getItemDescs((XBCItem)specDef);
        for (XBCXDesc itemDesc : itemDescs) {
            descManager.removeItem((XBCBase)itemDesc);
        }
        XBCXStriManager striManager = this.catalog.getCatalogManager(XBCXStriManager.class);
        XBCXStri itemStri = striManager.getItemStringId((XBCItem)specDef);
        if (itemStri != null) {
            striManager.removeItem((XBCBase)itemStri);
        }
        if ((itemHDoc = (hdocManager = this.catalog.getCatalogManager(XBCXHDocManager.class)).getDocumentation((XBCItem)specDef)) != null) {
            hdocManager.removeItem((XBCBase)itemHDoc);
        }
        this.removeSpecDef(specDef);
    }

    public XBLFormatDecl getFormatDeclAsLocal(XBCFormatDecl formatDecl) {
        XBLFormatDecl result = new XBLFormatDecl(this.getSpecXBPath((XBCSpec)formatDecl.getFormatSpecRev().getParent()), (int)formatDecl.getRevision());
        XBLFormatDef formatDef = new XBLFormatDef();
        XBCFormatDef srcFormatDef = new XBCFormatDef((XBCatalog)this.catalog, formatDecl.getFormatSpecRev().getParent());
        ArrayList<Object> formatParams = new ArrayList<Object>();
        for (XBFormatParam formatParam : srcFormatDef.getFormatParams()) {
            if (formatParam instanceof XBFormatParamConsist) {
                formatParams.add(new XBFormatParamConsist((XBGroupDecl)this.getGroupDeclAsLocal((XBCGroupDecl)((XBFormatParamConsist)formatParam).getGroupDecl())));
                continue;
            }
            if (!(formatParam instanceof XBFormatParamJoin)) continue;
            formatParams.add(new XBFormatParamJoin((XBFormatDecl)this.getFormatDeclAsLocal((XBCFormatDecl)((XBFormatParamJoin)formatParam).getFormatDecl())));
        }
        formatDef.setFormatParams(formatParams);
        formatDef.setRevisionDef(new XBLRevisionDef(srcFormatDef.getRevisionDef().getRevParams()));
        result.setFormatDef((XBFormatDef)formatDef);
        return result;
    }

    public XBLGroupDecl getGroupDeclAsLocal(XBCGroupDecl groupDecl) {
        XBLGroupDecl result = new XBLGroupDecl(this.getSpecXBPath((XBCSpec)groupDecl.getGroupSpecRev().getParent()), (int)groupDecl.getRevision());
        XBLGroupDef groupDef = new XBLGroupDef();
        XBCGroupDef srcGroupDef = new XBCGroupDef((XBCatalog)this.catalog, groupDecl.getGroupSpecRev().getParent());
        ArrayList<Object> groupParams = new ArrayList<Object>();
        for (XBGroupParam groupParam : srcGroupDef.getGroupParams()) {
            if (groupParam instanceof XBGroupParamConsist) {
                groupParams.add(new XBGroupParamConsist((XBBlockDecl)this.getBlockDeclAsLocal((XBCBlockDecl)((XBGroupParamConsist)groupParam).getBlockDecl())));
                continue;
            }
            if (!(groupParam instanceof XBFormatParamJoin)) continue;
            groupParams.add(new XBGroupParamJoin((XBGroupDecl)this.getGroupDeclAsLocal((XBCGroupDecl)((XBGroupParamJoin)groupParam).getGroupDecl())));
        }
        groupDef.setGroupParams(groupParams);
        groupDef.setRevisionDef(new XBLRevisionDef(srcGroupDef.getRevisionDef().getRevParams()));
        result.setGroupDef((XBGroupDef)groupDef);
        return result;
    }

    public XBLBlockDecl getBlockDeclAsLocal(XBCBlockDecl blockDecl) {
        XBLBlockDecl result = new XBLBlockDecl(this.getSpecXBPath((XBCSpec)blockDecl.getBlockSpecRev().getParent()), (int)blockDecl.getRevision());
        result.setBlockDef((XBBlockDef)new XBCBlockDef((XBCatalog)this.catalog, blockDecl.getBlockSpecRev().getParent()));
        return result;
    }
}

