/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.convert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.convert.CatalogItemType;
import org.exbin.xbup.catalog.entity.XBEBlockCons;
import org.exbin.xbup.catalog.entity.XBEBlockJoin;
import org.exbin.xbup.catalog.entity.XBEBlockListCons;
import org.exbin.xbup.catalog.entity.XBEBlockListJoin;
import org.exbin.xbup.catalog.entity.XBEBlockRev;
import org.exbin.xbup.catalog.entity.XBEBlockSpec;
import org.exbin.xbup.catalog.entity.XBEFormatCons;
import org.exbin.xbup.catalog.entity.XBEFormatJoin;
import org.exbin.xbup.catalog.entity.XBEFormatRev;
import org.exbin.xbup.catalog.entity.XBEFormatSpec;
import org.exbin.xbup.catalog.entity.XBEGroupCons;
import org.exbin.xbup.catalog.entity.XBEGroupJoin;
import org.exbin.xbup.catalog.entity.XBEGroupRev;
import org.exbin.xbup.catalog.entity.XBEGroupSpec;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.catalog.entity.XBERev;
import org.exbin.xbup.catalog.entity.XBESpecDef;
import org.exbin.xbup.catalog.entity.XBEXBlockUi;
import org.exbin.xbup.catalog.entity.XBEXDesc;
import org.exbin.xbup.catalog.entity.XBEXFile;
import org.exbin.xbup.catalog.entity.XBEXHDoc;
import org.exbin.xbup.catalog.entity.XBEXIcon;
import org.exbin.xbup.catalog.entity.XBEXName;
import org.exbin.xbup.catalog.entity.XBEXPlugUi;
import org.exbin.xbup.catalog.entity.XBEXPlugin;
import org.exbin.xbup.catalog.entity.XBEXStri;
import org.exbin.xbup.catalog.modifiable.XBMBlockRev;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.definition.XBParamType;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCFormatRev;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupRev;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.catalog.base.XBCXBlockUi;
import org.exbin.xbup.core.catalog.base.XBCXDesc;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.XBCXHDoc;
import org.exbin.xbup.core.catalog.base.XBCXIcon;
import org.exbin.xbup.core.catalog.base.XBCXIconMode;
import org.exbin.xbup.core.catalog.base.XBCXLanguage;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.XBCXPlugUi;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;
import org.exbin.xbup.core.catalog.base.XBCXStri;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXFileService;
import org.exbin.xbup.core.catalog.base.service.XBCXHDocService;
import org.exbin.xbup.core.catalog.base.service.XBCXIconService;
import org.exbin.xbup.core.catalog.base.service.XBCXLangService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXPlugService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;
import org.exbin.xbup.core.parser.XBParserMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBEventWriter;
import org.exbin.xbup.core.parser.token.event.XBTEventFilter;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTToXBEventConvertor;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.parser.token.pull.XBPullReader;
import org.exbin.xbup.core.parser.token.pull.convert.XBToXBTPullConvertor;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.core.type.XBString;
import org.exbin.xbup.core.util.StreamUtils;

@ParametersAreNonnullByDefault
public class XBCatalogXb {
    private XBACatalog catalog;

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void exportToXbFile(OutputStream stream) {
        try {
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler((XBInput)new TypeDroppingFilter((XBTEventListener)new XBTToXBEventConvertor((XBEventListener)new XBEventWriter(stream, XBParserMode.FULL))));
            this.exportAll(serialInput);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBCatalogXb.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void exportToXbStream(OutputStream stream) {
        try {
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler((XBInput)new TypeDroppingFilter((XBTEventListener)new XBTToXBEventConvertor((XBEventListener)new XBEventWriter(stream, XBParserMode.SKIP_HEAD))));
            this.exportAll(serialInput);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBCatalogXb.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void exportAll(XBPListenerSerialHandler serialInput) throws XBProcessingException, IOException {
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        this.exportAllNodes(serialInput);
        this.exportAllFiles(serialInput);
        this.exportAllProperties(serialInput, CatalogItemType.NODE);
        this.exportAllSpecs(serialInput, CatalogItemType.BLOCK);
        this.exportAllSpecRevs(serialInput, CatalogItemType.BLOCK);
        this.exportAllSpecDefs(serialInput, CatalogItemType.BLOCK);
        this.exportAllProperties(serialInput, CatalogItemType.BLOCK);
        this.exportAllSpecs(serialInput, CatalogItemType.GROUP);
        this.exportAllSpecRevs(serialInput, CatalogItemType.GROUP);
        this.exportAllSpecDefs(serialInput, CatalogItemType.GROUP);
        this.exportAllProperties(serialInput, CatalogItemType.GROUP);
        this.exportAllSpecs(serialInput, CatalogItemType.FORMAT);
        this.exportAllSpecRevs(serialInput, CatalogItemType.FORMAT);
        this.exportAllSpecDefs(serialInput, CatalogItemType.FORMAT);
        this.exportAllProperties(serialInput, CatalogItemType.FORMAT);
        this.exportAllPlugins(serialInput);
        this.exportAllUis(serialInput);
        serialInput.end();
    }

    private void exportAllNodes(XBPListenerSerialHandler serialInput) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCNode mainRootNode = (XBCNode)nodeService.getMainRootNode().get();
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        this.exportNodes(serialInput, mainRootNode);
        serialInput.end();
    }

    private void exportNodes(XBPListenerSerialHandler serialInput, XBCNode node) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        serialInput.putAttribute(node.getXBIndex());
        this.putPath(serialInput, nodeService.getNodeXBPath(node));
        serialInput.end();
        List subNodes = nodeService.getSubNodes(node);
        for (XBCNode subNode : subNodes) {
            this.exportNodes(serialInput, subNode);
        }
    }

    private void exportAllFiles(XBPListenerSerialHandler serialInput) throws XBProcessingException, IOException {
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCNode mainRootNode = (XBCNode)nodeService.getMainRootNode().get();
        this.exportFiles(serialInput, mainRootNode);
        serialInput.end();
    }

    private void exportFiles(XBPListenerSerialHandler serialInput, XBCNode node) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCXFileService fileService = (XBCXFileService)this.catalog.getCatalogService(XBCXFileService.class);
        Long[] nodePath = nodeService.getNodeXBPath(node);
        List files = fileService.findFilesForNode(node);
        for (XBCXFile file : files) {
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBFixedBlockType());
            this.putPath(serialInput, nodePath);
            serialInput.consist((XBSerializable)new XBString(file.getFilename()));
            try (ByteArrayInputStream stream = new ByteArrayInputStream(file.getContent());){
                serialInput.begin();
                serialInput.putData((InputStream)stream);
                serialInput.end();
            }
            serialInput.end();
        }
        List subNodes = nodeService.getSubNodes(node);
        for (XBCNode subNode : subNodes) {
            this.exportFiles(serialInput, subNode);
        }
    }

    private void exportAllSpecs(XBPListenerSerialHandler serialInput, CatalogItemType itemType) throws XBProcessingException, IOException {
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCNode mainRootNode = (XBCNode)nodeService.getMainRootNode().get();
        this.exportSpecs(serialInput, mainRootNode, itemType);
        serialInput.end();
    }

    private void exportSpecs(XBPListenerSerialHandler serialInput, XBCNode node, CatalogItemType itemType) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        Long[] nodePath = nodeService.getNodeXBPath(node);
        List<XBCItem> items = this.getItems(itemType, node);
        for (XBCItem item : items) {
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBFixedBlockType());
            serialInput.putAttribute(item.getXBIndex());
            this.putPath(serialInput, nodePath);
            serialInput.end();
        }
        List subNodes = nodeService.getSubNodes(node);
        for (XBCNode subNode : subNodes) {
            this.exportSpecs(serialInput, subNode, itemType);
        }
    }

    private void exportAllSpecRevs(XBPListenerSerialHandler serialInput, CatalogItemType itemType) throws XBProcessingException, IOException {
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCNode mainRootNode = (XBCNode)nodeService.getMainRootNode().get();
        this.exportSpecRevs(serialInput, mainRootNode, itemType);
        serialInput.end();
    }

    private void exportSpecRevs(XBPListenerSerialHandler serialInput, XBCNode node, CatalogItemType itemType) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCRevService revService = (XBCRevService)this.catalog.getCatalogService(XBCRevService.class);
        Long[] nodePath = nodeService.getNodeXBPath(node);
        List<XBCItem> items = this.getItems(itemType, node);
        for (XBCItem item : items) {
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBFixedBlockType());
            serialInput.putAttribute(item.getXBIndex());
            this.putPath(serialInput, nodePath);
            List revs = revService.getRevs((XBCSpec)item);
            for (XBCRev specRev : revs) {
                serialInput.begin();
                serialInput.putType((XBBlockType)new XBFixedBlockType());
                serialInput.putAttribute(specRev.getXBIndex());
                serialInput.putAttribute(specRev.getXBLimit());
                serialInput.end();
            }
            serialInput.end();
        }
        List subNodes = nodeService.getSubNodes(node);
        for (XBCNode subNode : subNodes) {
            this.exportSpecRevs(serialInput, subNode, itemType);
        }
    }

    private void exportAllSpecDefs(XBPListenerSerialHandler serialInput, CatalogItemType itemType) throws XBProcessingException, IOException {
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCNode mainRootNode = (XBCNode)nodeService.getMainRootNode().get();
        this.exportSpecDefs(serialInput, mainRootNode, itemType);
        serialInput.end();
    }

    private void exportSpecDefs(XBPListenerSerialHandler serialInput, XBCNode node, CatalogItemType itemType) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        Long[] nodePath = nodeService.getNodeXBPath(node);
        List<XBCItem> items = this.getItems(itemType, node);
        for (XBCItem item : items) {
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBFixedBlockType());
            serialInput.putAttribute(item.getXBIndex());
            this.putPath(serialInput, nodePath);
            List specDefs = specService.getSpecDefs((XBCSpec)item);
            for (XBCSpecDef specDef : specDefs) {
                serialInput.begin();
                serialInput.putType((XBBlockType)new XBFixedBlockType());
                serialInput.putAttribute(specDef.getType().ordinal());
                serialInput.putAttribute(specDef.getXBIndex());
                XBCRev targetRev = specDef.getTargetRev().orElse(null);
                serialInput.putAttribute(targetRev != null ? 1 : 0);
                if (targetRev != null) {
                    XBCSpec targetSpec = targetRev.getParent();
                    XBCNode targetSpecNode = targetSpec.getParent();
                    Long[] targetNodePath = nodeService.getNodeXBPath(targetSpecNode);
                    this.putPath(serialInput, targetNodePath);
                    serialInput.putAttribute(targetSpec.getXBIndex());
                    serialInput.putAttribute(targetRev.getXBIndex());
                }
                serialInput.begin();
                serialInput.putType((XBBlockType)new XBFixedBlockType());
                this.exportSpecDefProperties(serialInput, specDef);
                serialInput.end();
                serialInput.end();
            }
            serialInput.end();
        }
        List subNodes = nodeService.getSubNodes(node);
        for (XBCNode subNode : subNodes) {
            this.exportSpecDefs(serialInput, subNode, itemType);
        }
    }

    private void exportSpecDefProperties(XBPListenerSerialHandler serialInput, XBCSpecDef specDef) throws XBProcessingException, IOException {
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
        List itemNames = nameService.getItemNames((XBCItem)specDef);
        for (XBCXName itemName : itemNames) {
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBFixedBlockType());
            serialInput.consist((XBSerializable)new XBString(itemName.getLang().getLangCode()));
            serialInput.consist((XBSerializable)new XBString(itemName.getText()));
            serialInput.end();
        }
        serialInput.end();
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        XBCXDescService descService = (XBCXDescService)this.catalog.getCatalogService(XBCXDescService.class);
        List itemDescs = descService.getItemDescs((XBCItem)specDef);
        for (XBCXDesc itemDesc : itemDescs) {
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBFixedBlockType());
            serialInput.consist((XBSerializable)new XBString(itemDesc.getLang().getLangCode()));
            serialInput.consist((XBSerializable)new XBString(itemDesc.getText()));
            serialInput.end();
        }
        serialInput.end();
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
        XBCXStri stri = striService.getItemStringId((XBCItem)specDef);
        if (stri != null) {
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBFixedBlockType());
            serialInput.consist((XBSerializable)new XBString(stri.getText()));
            serialInput.end();
        }
        serialInput.end();
    }

    private void exportAllProperties(XBPListenerSerialHandler serialInput, CatalogItemType itemType) throws XBProcessingException, IOException {
        this.exportAllNames(serialInput, itemType);
        this.exportAllDescs(serialInput, itemType);
        this.exportAllStri(serialInput, itemType);
        this.exportAllHDocs(serialInput, itemType);
        this.exportAllIcons(serialInput, itemType);
    }

    private void exportAllNames(XBPListenerSerialHandler serialInput, CatalogItemType itemType) throws XBProcessingException, IOException {
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCNode mainRootNode = (XBCNode)nodeService.getMainRootNode().get();
        this.exportNames(serialInput, itemType, mainRootNode);
        serialInput.end();
    }

    private void exportNames(XBPListenerSerialHandler serialInput, CatalogItemType itemType, XBCNode node) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        Long[] nodePath = nodeService.getNodeXBPath(node);
        List<XBCItem> items = this.getItems(itemType, node);
        XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
        for (XBCItem item : items) {
            List itemNames = nameService.getItemNames(item);
            for (XBCXName itemName : itemNames) {
                serialInput.begin();
                serialInput.putType((XBBlockType)new XBFixedBlockType());
                serialInput.putAttribute(item.getXBIndex());
                this.putPath(serialInput, nodePath);
                serialInput.consist((XBSerializable)new XBString(itemName.getLang().getLangCode()));
                serialInput.consist((XBSerializable)new XBString(itemName.getText()));
                serialInput.end();
            }
        }
        List subNodes = nodeService.getSubNodes(node);
        for (XBCNode subNode : subNodes) {
            this.exportNames(serialInput, itemType, subNode);
        }
    }

    private void exportAllDescs(XBPListenerSerialHandler serialInput, CatalogItemType itemType) throws XBProcessingException, IOException {
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCNode mainRootNode = (XBCNode)nodeService.getMainRootNode().get();
        this.exportDescs(serialInput, itemType, mainRootNode);
        serialInput.end();
    }

    private void exportDescs(XBPListenerSerialHandler serialInput, CatalogItemType itemType, XBCNode node) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        Long[] nodePath = nodeService.getNodeXBPath(node);
        List<XBCItem> items = this.getItems(itemType, node);
        XBCXDescService nameService = (XBCXDescService)this.catalog.getCatalogService(XBCXDescService.class);
        for (XBCItem item : items) {
            List itemDescs = nameService.getItemDescs(item);
            for (XBCXDesc itemDesc : itemDescs) {
                serialInput.begin();
                serialInput.putType((XBBlockType)new XBFixedBlockType());
                serialInput.putAttribute(item.getXBIndex());
                this.putPath(serialInput, nodePath);
                serialInput.consist((XBSerializable)new XBString(itemDesc.getLang().getLangCode()));
                serialInput.consist((XBSerializable)new XBString(itemDesc.getText()));
                serialInput.end();
            }
        }
        List subNodes = nodeService.getSubNodes(node);
        for (XBCNode subNode : subNodes) {
            this.exportDescs(serialInput, itemType, subNode);
        }
    }

    private void exportAllStri(XBPListenerSerialHandler serialInput, CatalogItemType itemType) throws XBProcessingException, IOException {
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCNode mainRootNode = (XBCNode)nodeService.getMainRootNode().get();
        this.exportStri(serialInput, itemType, mainRootNode);
        serialInput.end();
    }

    private void exportStri(XBPListenerSerialHandler serialInput, CatalogItemType itemType, XBCNode node) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        Long[] nodePath = nodeService.getNodeXBPath(node);
        List<XBCItem> items = this.getItems(itemType, node);
        XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
        for (XBCItem item : items) {
            XBCXStri stri = striService.getItemStringId(item);
            if (stri == null) continue;
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBFixedBlockType());
            serialInput.putAttribute(item.getXBIndex());
            this.putPath(serialInput, nodePath);
            serialInput.consist((XBSerializable)new XBString(stri.getText()));
            serialInput.end();
        }
        List subNodes = nodeService.getSubNodes(node);
        for (XBCNode subNode : subNodes) {
            this.exportStri(serialInput, itemType, subNode);
        }
    }

    private void exportAllHDocs(XBPListenerSerialHandler serialInput, CatalogItemType itemType) throws XBProcessingException, IOException {
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCNode mainRootNode = (XBCNode)nodeService.getMainRootNode().get();
        this.exportHDocs(serialInput, itemType, mainRootNode);
        serialInput.end();
    }

    private void exportHDocs(XBPListenerSerialHandler serialInput, CatalogItemType itemType, XBCNode node) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        Long[] nodePath = nodeService.getNodeXBPath(node);
        List<XBCItem> items = this.getItems(itemType, node);
        XBCXHDocService docService = (XBCXHDocService)this.catalog.getCatalogService(XBCXHDocService.class);
        for (XBCItem item : items) {
            XBCXHDoc itemHDoc = docService.getDocumentation(item);
            if (itemHDoc == null) continue;
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBFixedBlockType());
            serialInput.putAttribute(item.getXBIndex());
            this.putPath(serialInput, nodePath);
            serialInput.consist((XBSerializable)new XBString(itemHDoc.getLang().getLangCode()));
            this.putPath(serialInput, nodeService.getNodeXBPath(itemHDoc.getDocFile().getNode()));
            serialInput.consist((XBSerializable)new XBString(itemHDoc.getDocFile().getFilename()));
            serialInput.end();
        }
        List subNodes = nodeService.getSubNodes(node);
        for (XBCNode subNode : subNodes) {
            this.exportHDocs(serialInput, itemType, subNode);
        }
    }

    private void exportAllIcons(XBPListenerSerialHandler serialInput, CatalogItemType itemType) throws XBProcessingException, IOException {
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCNode mainRootNode = (XBCNode)nodeService.getMainRootNode().get();
        this.exportIcons(serialInput, itemType, mainRootNode);
        serialInput.end();
    }

    private void exportIcons(XBPListenerSerialHandler serialInput, CatalogItemType itemType, XBCNode node) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        Long[] nodePath = nodeService.getNodeXBPath(node);
        List<XBCItem> items = this.getItems(itemType, node);
        XBCXIconService iconService = (XBCXIconService)this.catalog.getCatalogService(XBCXIconService.class);
        for (XBCItem item : items) {
            List icons = iconService.getItemIcons(item);
            for (XBCXIcon icon : icons) {
                serialInput.begin();
                serialInput.putType((XBBlockType)new XBFixedBlockType());
                serialInput.putAttribute(item.getXBIndex());
                this.putPath(serialInput, nodePath);
                serialInput.putAttribute(icon.getMode().getId());
                this.putPath(serialInput, nodeService.getNodeXBPath(icon.getIconFile().getNode()));
                serialInput.consist((XBSerializable)new XBString(icon.getIconFile().getFilename()));
                serialInput.end();
            }
        }
        List subNodes = nodeService.getSubNodes(node);
        for (XBCNode subNode : subNodes) {
            this.exportIcons(serialInput, itemType, subNode);
        }
    }

    private void exportAllPlugins(XBPListenerSerialHandler serialInput) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCXPlugService plugService = (XBCXPlugService)this.catalog.getCatalogService(XBCXPlugService.class);
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        List plugins = plugService.getAllItems();
        for (XBCXPlugin plugin : plugins) {
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBFixedBlockType());
            XBCNode node = plugin.getOwner();
            Long[] nodePath = nodeService.getNodeXBPath(node);
            this.putPath(serialInput, nodePath);
            serialInput.putAttribute(plugin.getPluginIndex());
            XBCXFile pluginFile = plugin.getPluginFile();
            XBCNode fileNode = pluginFile.getNode();
            Long[] fileNodePath = nodeService.getNodeXBPath(fileNode);
            this.putPath(serialInput, fileNodePath);
            XBString fileName = new XBString(pluginFile.getFilename());
            serialInput.putConsist((XBSerializable)fileName);
            serialInput.end();
        }
        serialInput.end();
    }

    private void exportAllUis(XBPListenerSerialHandler serialInput) throws XBProcessingException, IOException {
        Long[] nodePath;
        XBCNode node;
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCXUiService uiService = (XBCXUiService)this.catalog.getCatalogService(XBCXUiService.class);
        XBCXPlugService plugService = (XBCXPlugService)this.catalog.getCatalogService(XBCXPlugService.class);
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        List plugins = plugService.getAllItems();
        for (XBCXPlugin plugin : plugins) {
            List plugUis = uiService.getPlugUis(plugin);
            for (XBCXPlugUi plugUi : plugUis) {
                serialInput.begin();
                serialInput.putType((XBBlockType)new XBFixedBlockType());
                node = plugin.getOwner();
                nodePath = nodeService.getNodeXBPath(node);
                this.putPath(serialInput, nodePath);
                serialInput.putAttribute(plugin.getPluginIndex());
                serialInput.putAttribute(plugUi.getUiType().getId());
                serialInput.putAttribute(plugUi.getMethodIndex());
                XBString name = new XBString(plugUi.getName());
                serialInput.putConsist((XBSerializable)name);
                serialInput.end();
            }
        }
        serialInput.end();
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        List blockUis = uiService.getAllItems();
        for (XBCXBlockUi blockUi : blockUis) {
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBFixedBlockType());
            XBCXPlugUi plugUi = blockUi.getUi();
            XBCXPlugin plugin = plugUi.getPlugin();
            node = plugin.getOwner();
            nodePath = nodeService.getNodeXBPath(node);
            this.putPath(serialInput, nodePath);
            serialInput.putAttribute(plugin.getPluginIndex());
            serialInput.putAttribute(plugUi.getUiType().getId());
            serialInput.putAttribute(plugUi.getMethodIndex());
            XBCBlockRev blockRev = blockUi.getBlockRev();
            XBCBlockSpec blockSpec = blockRev.getParent();
            XBCNode specNode = blockSpec.getParent();
            Long[] specNodePath = nodeService.getNodeXBPath(specNode);
            this.putPath(serialInput, specNodePath);
            serialInput.putAttribute(blockSpec.getXBIndex());
            serialInput.putAttribute(blockRev.getXBIndex());
            serialInput.putAttribute(blockUi.getPriority());
            XBString name = new XBString(blockUi.getName());
            serialInput.putConsist((XBSerializable)name);
            serialInput.end();
        }
        serialInput.end();
        serialInput.end();
    }

    @Nonnull
    private List<XBCItem> getItems(CatalogItemType itemType, XBCNode node) {
        ArrayList<XBCItem> result = new ArrayList<XBCItem>();
        switch (itemType) {
            case NODE: {
                XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
                List subNodes = nodeService.getSubNodes(node);
                result.addAll(subNodes);
                break;
            }
            case BLOCK: {
                XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
                List blockSpecs = specService.getBlockSpecs(node);
                result.addAll(blockSpecs);
                break;
            }
            case GROUP: {
                XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
                List groupSpecs = specService.getGroupSpecs(node);
                result.addAll(groupSpecs);
                break;
            }
            case FORMAT: {
                XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
                List formatSpecs = specService.getFormatSpecs(node);
                result.addAll(formatSpecs);
                break;
            }
        }
        return result;
    }

    private void putPath(XBPListenerSerialHandler serialInput, Long[] nodeXBPath) throws XBProcessingException, IOException {
        serialInput.begin();
        serialInput.putType((XBBlockType)new XBFixedBlockType());
        serialInput.putAttribute(nodeXBPath.length);
        for (Long value : nodeXBPath) {
            serialInput.putAttribute(value.longValue());
        }
        serialInput.end();
    }

    public void importFromXbFile(InputStream stream) {
        try {
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler((XBOutput)new XBToXBTPullConvertor((XBPullProvider)new XBPullReader(stream, XBParserMode.FULL)));
            this.importAll(serialOutput);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBCatalogXb.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void importFromXbStream(InputStream stream) {
        try {
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler((XBOutput)new XBToXBTPullConvertor((XBPullProvider)new XBPullReader(stream, XBParserMode.SKIP_HEAD)));
            this.importAll(serialOutput);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBCatalogXb.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void importAll(XBPProviderSerialHandler serialOutput) throws XBProcessingException, IOException {
        EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        serialOutput.begin();
        serialOutput.pullType();
        this.importNodes(serialOutput);
        this.importFiles(serialOutput);
        this.importProperties(serialOutput, CatalogItemType.NODE);
        this.importSpecs(serialOutput, CatalogItemType.BLOCK);
        this.importSpecRevs(serialOutput, CatalogItemType.BLOCK);
        this.importSpecDefs(serialOutput, CatalogItemType.BLOCK);
        this.importProperties(serialOutput, CatalogItemType.BLOCK);
        this.importSpecs(serialOutput, CatalogItemType.GROUP);
        this.importSpecRevs(serialOutput, CatalogItemType.GROUP);
        this.importSpecDefs(serialOutput, CatalogItemType.GROUP);
        this.importProperties(serialOutput, CatalogItemType.GROUP);
        this.importSpecs(serialOutput, CatalogItemType.FORMAT);
        this.importSpecRevs(serialOutput, CatalogItemType.FORMAT);
        this.importSpecDefs(serialOutput, CatalogItemType.FORMAT);
        this.importProperties(serialOutput, CatalogItemType.FORMAT);
        this.importPlugins(serialOutput);
        this.importUis(serialOutput);
        serialOutput.pullEnd();
        tx.commit();
    }

    private void importNodes(XBPProviderSerialHandler serialOutput) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        serialOutput.pullBegin();
        serialOutput.pullType();
        while (!serialOutput.isEndNext()) {
            serialOutput.pullBegin();
            serialOutput.pullType();
            long xbIndex = serialOutput.pullAttribute().getNaturalLong();
            Long[] nodePath = this.pullPath(serialOutput);
            XBENode parentNode = (XBENode)nodeService.findOwnerByXBPath(nodePath);
            serialOutput.pullEnd();
            XBENode node = (XBENode)nodeService.createItem();
            node.setParent(parentNode);
            node.setXBIndex(xbIndex);
            nodeService.persistItem((XBCBase)node);
        }
        serialOutput.pullEnd();
    }

    private void importFiles(XBPProviderSerialHandler serialOutput) throws XBProcessingException, IOException {
        XBCXFileService fileService = (XBCXFileService)this.catalog.getCatalogService(XBCXFileService.class);
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        serialOutput.pullBegin();
        serialOutput.pullType();
        while (!serialOutput.isEndNext()) {
            byte[] fileData;
            serialOutput.pullBegin();
            serialOutput.pullType();
            Long[] nodePath = this.pullPath(serialOutput);
            XBENode node = (XBENode)nodeService.findNodeByXBPath(nodePath);
            XBString fileName = new XBString();
            serialOutput.pullConsist((XBSerializable)fileName);
            serialOutput.pullBegin();
            InputStream fileDataStream = serialOutput.pullData();
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                StreamUtils.copyInputStreamToOutputStream((InputStream)fileDataStream, (OutputStream)stream);
                fileData = stream.toByteArray();
            }
            serialOutput.pullEnd();
            serialOutput.pullEnd();
            XBEXFile file = (XBEXFile)fileService.createItem();
            file.setNode(node);
            file.setContent(fileData);
            file.setFilename(fileName.getValue());
            fileService.persistItem((XBCBase)file);
        }
        serialOutput.pullEnd();
    }

    private void importSpecs(XBPProviderSerialHandler serialOutput, CatalogItemType itemType) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        serialOutput.pullBegin();
        serialOutput.pullType();
        while (!serialOutput.isEndNext()) {
            serialOutput.pullBegin();
            serialOutput.pullType();
            long xbIndex = serialOutput.pullAttribute().getNaturalLong();
            Long[] nodePath = this.pullPath(serialOutput);
            XBENode node = (XBENode)nodeService.findNodeByXBPath(nodePath);
            serialOutput.pullEnd();
            switch (itemType) {
                case BLOCK: {
                    XBEBlockSpec blockSpec = (XBEBlockSpec)specService.createBlockSpec();
                    blockSpec.setParent(node);
                    blockSpec.setXBIndex(xbIndex);
                    specService.persistItem((XBCBase)blockSpec);
                    break;
                }
                case GROUP: {
                    XBEGroupSpec groupSpec = (XBEGroupSpec)specService.createGroupSpec();
                    groupSpec.setParent(node);
                    groupSpec.setXBIndex(xbIndex);
                    specService.persistItem((XBCBase)groupSpec);
                    break;
                }
                case FORMAT: {
                    XBEFormatSpec formatSpec = (XBEFormatSpec)specService.createFormatSpec();
                    formatSpec.setParent(node);
                    formatSpec.setXBIndex(xbIndex);
                    specService.persistItem((XBCBase)formatSpec);
                    break;
                }
            }
        }
        serialOutput.pullEnd();
    }

    private void importSpecRevs(XBPProviderSerialHandler serialOutput, CatalogItemType itemType) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        XBCRevService revService = (XBCRevService)this.catalog.getCatalogService(XBCRevService.class);
        serialOutput.pullBegin();
        serialOutput.pullType();
        while (!serialOutput.isEndNext()) {
            serialOutput.pullBegin();
            serialOutput.pullType();
            long xbIndex = serialOutput.pullAttribute().getNaturalLong();
            Long[] nodePath = this.pullPath(serialOutput);
            XBENode node = (XBENode)nodeService.findNodeByXBPath(nodePath);
            ArrayList<RevRecord> revRecords = new ArrayList<RevRecord>();
            while (!serialOutput.isEndNext()) {
                RevRecord revRecord2 = new RevRecord();
                serialOutput.pullBegin();
                serialOutput.pullType();
                revRecord2.xbIndex = serialOutput.pullLongAttribute();
                revRecord2.xbLimit = serialOutput.pullLongAttribute();
                serialOutput.pullEnd();
                revRecords.add(revRecord2);
            }
            serialOutput.pullEnd();
            switch (itemType) {
                case BLOCK: {
                    XBCBlockSpec blockSpec = specService.findBlockSpecByXB((XBCNode)node, xbIndex);
                    revRecords.stream().map(revRecord -> {
                        XBEBlockRev blockRev = (XBEBlockRev)revService.createRev((XBCSpec)blockSpec);
                        blockRev.setXBIndex(revRecord.xbIndex);
                        blockRev.setXBLimit(revRecord.xbLimit);
                        return blockRev;
                    }).forEachOrdered(blockRev -> revService.persistItem((XBCBase)blockRev));
                    break;
                }
                case GROUP: {
                    XBCGroupSpec groupSpec = specService.findGroupSpecByXB((XBCNode)node, xbIndex);
                    revRecords.stream().map(revRecord -> {
                        XBEGroupRev groupRev = (XBEGroupRev)revService.createRev((XBCSpec)groupSpec);
                        groupRev.setXBIndex(revRecord.xbIndex);
                        groupRev.setXBLimit(revRecord.xbLimit);
                        return groupRev;
                    }).forEachOrdered(groupRev -> revService.persistItem((XBCBase)groupRev));
                    break;
                }
                case FORMAT: {
                    XBCFormatSpec formatSpec = specService.findFormatSpecByXB((XBCNode)node, xbIndex);
                    revRecords.stream().map(revRecord -> {
                        XBEFormatRev formatRev = (XBEFormatRev)revService.createRev((XBCSpec)formatSpec);
                        formatRev.setXBIndex(revRecord.xbIndex);
                        formatRev.setXBLimit(revRecord.xbLimit);
                        return formatRev;
                    }).forEachOrdered(formatRev -> revService.persistItem((XBCBase)formatRev));
                    break;
                }
            }
        }
        serialOutput.pullEnd();
    }

    private void importSpecDefs(XBPProviderSerialHandler serialOutput, CatalogItemType itemType) throws XBProcessingException, IOException {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        XBCRevService revService = (XBCRevService)this.catalog.getCatalogService(XBCRevService.class);
        XBCXLangService langService = (XBCXLangService)this.catalog.getCatalogService(XBCXLangService.class);
        XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
        XBCXDescService descService = (XBCXDescService)this.catalog.getCatalogService(XBCXDescService.class);
        XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
        serialOutput.pullBegin();
        serialOutput.pullType();
        block19: while (!serialOutput.isEndNext()) {
            serialOutput.pullBegin();
            serialOutput.pullType();
            long xbIndex = serialOutput.pullAttribute().getNaturalLong();
            Long[] nodePath = this.pullPath(serialOutput);
            XBENode node = (XBENode)nodeService.findNodeByXBPath(nodePath);
            ArrayList<SpecDefRecord> specDefRecords = new ArrayList<SpecDefRecord>();
            while (!serialOutput.isEndNext()) {
                XBCXLanguage language;
                Optional optionalLanguage;
                XBString text;
                XBString langCode;
                SpecDefRecord specDefRecord = new SpecDefRecord();
                serialOutput.pullBegin();
                serialOutput.pullType();
                specDefRecord.type = serialOutput.pullIntAttribute();
                specDefRecord.xbIndex = serialOutput.pullLongAttribute();
                byte isPresent = serialOutput.pullByteAttribute();
                if (isPresent == 1) {
                    specDefRecord.targetNodePath = this.pullPath(serialOutput);
                    specDefRecord.targetSpecIndex = serialOutput.pullLongAttribute();
                    specDefRecord.targetRevIndex = serialOutput.pullLongAttribute();
                } else {
                    specDefRecord.targetNodePath = null;
                }
                serialOutput.pullBegin();
                serialOutput.pullType();
                serialOutput.pullBegin();
                serialOutput.pullType();
                while (!serialOutput.isEndNext()) {
                    serialOutput.pullBegin();
                    serialOutput.pullType();
                    langCode = new XBString();
                    serialOutput.pullConsist((XBSerializable)langCode);
                    text = new XBString();
                    serialOutput.pullConsist((XBSerializable)text);
                    serialOutput.pullEnd();
                    optionalLanguage = langService.findByCode(langCode.getValue());
                    if (!optionalLanguage.isPresent()) continue;
                    language = (XBCXLanguage)optionalLanguage.get();
                    XBEXName name = (XBEXName)nameService.createItem();
                    name.setText(text.getValue());
                    name.setLang(language);
                    specDefRecord.names.add(name);
                }
                serialOutput.pullEnd();
                serialOutput.pullBegin();
                serialOutput.pullType();
                while (!serialOutput.isEndNext()) {
                    serialOutput.pullBegin();
                    serialOutput.pullType();
                    langCode = new XBString();
                    serialOutput.pullConsist((XBSerializable)langCode);
                    text = new XBString();
                    serialOutput.pullConsist((XBSerializable)text);
                    serialOutput.pullEnd();
                    optionalLanguage = langService.findByCode(langCode.getValue());
                    if (!optionalLanguage.isPresent()) continue;
                    language = (XBCXLanguage)optionalLanguage.get();
                    XBEXDesc desc = (XBEXDesc)descService.createItem();
                    desc.setText(text.getValue());
                    desc.setLang(language);
                    specDefRecord.descs.add(desc);
                }
                serialOutput.pullEnd();
                serialOutput.pullBegin();
                serialOutput.pullType();
                if (!serialOutput.isEndNext()) {
                    serialOutput.pullBegin();
                    serialOutput.pullType();
                    XBString text2 = new XBString();
                    serialOutput.pullConsist((XBSerializable)text2);
                    serialOutput.pullEnd();
                    XBEXStri stri = (XBEXStri)striService.createItem();
                    stri.setText(text2.getValue());
                    specDefRecord.stri = stri;
                }
                serialOutput.pullEnd();
                serialOutput.pullEnd();
                serialOutput.pullEnd();
                specDefRecords.add(specDefRecord);
            }
            serialOutput.pullEnd();
            switch (itemType) {
                case BLOCK: {
                    XBERev targetRev;
                    XBCBlockSpec targetBlockSpec;
                    XBESpecDef def;
                    XBENode targetNode;
                    XBCBlockSpec blockSpec = specService.findBlockSpecByXB((XBCNode)node, xbIndex);
                    for (SpecDefRecord specDefRecord : specDefRecords) {
                        targetNode = specDefRecord.targetNodePath == null ? null : (XBENode)nodeService.findNodeByXBPath(specDefRecord.targetNodePath);
                        switch (XBParamType.values()[specDefRecord.type]) {
                            case CONSIST: {
                                def = (XBEBlockCons)specService.createSpecDef((XBCSpec)blockSpec, XBParamType.CONSIST);
                                def.setXBIndex(specDefRecord.xbIndex);
                                if (targetNode != null) {
                                    targetBlockSpec = specService.findBlockSpecByXB((XBCNode)targetNode, specDefRecord.targetSpecIndex);
                                    targetRev = (XBEBlockRev)revService.findRevByXB((XBCSpec)targetBlockSpec, specDefRecord.targetRevIndex);
                                    ((XBEBlockCons)def).setTarget((XBMBlockRev)((Object)targetRev));
                                }
                                specService.persistSpecDef((XBCSpecDef)def);
                                this.importSpecDefProperties(def, specDefRecord, nameService, descService, striService);
                                break;
                            }
                            case JOIN: {
                                def = (XBEBlockJoin)specService.createSpecDef((XBCSpec)blockSpec, XBParamType.JOIN);
                                def.setXBIndex(specDefRecord.xbIndex);
                                if (targetNode != null) {
                                    targetBlockSpec = specService.findBlockSpecByXB((XBCNode)targetNode, specDefRecord.targetSpecIndex);
                                    targetRev = (XBEBlockRev)revService.findRevByXB((XBCSpec)targetBlockSpec, specDefRecord.targetRevIndex);
                                    ((XBEBlockJoin)def).setTarget((XBCBlockRev)targetRev);
                                }
                                specService.persistSpecDef((XBCSpecDef)def);
                                this.importSpecDefProperties(def, specDefRecord, nameService, descService, striService);
                                break;
                            }
                            case LIST_CONSIST: {
                                def = (XBEBlockListCons)specService.createSpecDef((XBCSpec)blockSpec, XBParamType.LIST_CONSIST);
                                def.setXBIndex(specDefRecord.xbIndex);
                                if (targetNode != null) {
                                    targetBlockSpec = specService.findBlockSpecByXB((XBCNode)targetNode, specDefRecord.targetSpecIndex);
                                    targetRev = (XBEBlockRev)revService.findRevByXB((XBCSpec)targetBlockSpec, specDefRecord.targetRevIndex);
                                    ((XBEBlockListCons)def).setTarget((XBCBlockRev)targetRev);
                                }
                                specService.persistSpecDef((XBCSpecDef)def);
                                this.importSpecDefProperties(def, specDefRecord, nameService, descService, striService);
                                break;
                            }
                            case LIST_JOIN: {
                                def = (XBEBlockListJoin)specService.createSpecDef((XBCSpec)blockSpec, XBParamType.LIST_JOIN);
                                def.setXBIndex(specDefRecord.xbIndex);
                                if (targetNode != null) {
                                    targetBlockSpec = specService.findBlockSpecByXB((XBCNode)targetNode, specDefRecord.targetSpecIndex);
                                    targetRev = (XBEBlockRev)revService.findRevByXB((XBCSpec)targetBlockSpec, specDefRecord.targetRevIndex);
                                    ((XBEBlockListJoin)def).setTarget((XBCBlockRev)targetRev);
                                }
                                specService.persistSpecDef((XBCSpecDef)def);
                                this.importSpecDefProperties(def, specDefRecord, nameService, descService, striService);
                                break;
                            }
                        }
                    }
                    continue block19;
                }
                case GROUP: {
                    XBCGroupSpec targetGroupSpec;
                    XBERev targetRev;
                    XBCBlockSpec targetBlockSpec;
                    XBESpecDef def;
                    XBENode targetNode;
                    XBCGroupSpec groupSpec = specService.findGroupSpecByXB((XBCNode)node, xbIndex);
                    for (SpecDefRecord specDefRecord : specDefRecords) {
                        targetNode = (XBENode)nodeService.findNodeByXBPath(specDefRecord.targetNodePath);
                        switch (XBParamType.values()[specDefRecord.type]) {
                            case CONSIST: {
                                def = (XBEGroupCons)specService.createSpecDef((XBCSpec)groupSpec, XBParamType.CONSIST);
                                def.setXBIndex(specDefRecord.xbIndex);
                                if (targetNode != null) {
                                    targetBlockSpec = specService.findBlockSpecByXB((XBCNode)targetNode, specDefRecord.targetSpecIndex);
                                    targetRev = (XBEBlockRev)revService.findRevByXB((XBCSpec)targetBlockSpec, specDefRecord.targetRevIndex);
                                    ((XBEGroupCons)def).setTarget((XBCBlockRev)targetRev);
                                }
                                specService.persistSpecDef((XBCSpecDef)def);
                                this.importSpecDefProperties(def, specDefRecord, nameService, descService, striService);
                                break;
                            }
                            case JOIN: {
                                def = (XBEGroupJoin)specService.createSpecDef((XBCSpec)groupSpec, XBParamType.JOIN);
                                def.setXBIndex(specDefRecord.xbIndex);
                                if (targetNode != null) {
                                    targetGroupSpec = specService.findGroupSpecByXB((XBCNode)targetNode, specDefRecord.targetSpecIndex);
                                    targetRev = (XBEGroupRev)revService.findRevByXB((XBCSpec)targetGroupSpec, specDefRecord.targetRevIndex);
                                    ((XBEGroupJoin)def).setTarget((XBCGroupRev)targetRev);
                                }
                                specService.persistSpecDef((XBCSpecDef)def);
                                this.importSpecDefProperties(def, specDefRecord, nameService, descService, striService);
                                break;
                            }
                        }
                    }
                    continue block19;
                }
                case FORMAT: {
                    XBCGroupSpec targetGroupSpec;
                    XBERev targetRev;
                    XBESpecDef def;
                    XBENode targetNode;
                    XBCFormatSpec formatSpec = specService.findFormatSpecByXB((XBCNode)node, xbIndex);
                    for (SpecDefRecord specDefRecord : specDefRecords) {
                        targetNode = (XBENode)nodeService.findNodeByXBPath(specDefRecord.targetNodePath);
                        switch (XBParamType.values()[specDefRecord.type]) {
                            case CONSIST: {
                                def = (XBEFormatCons)specService.createSpecDef((XBCSpec)formatSpec, XBParamType.CONSIST);
                                def.setXBIndex(specDefRecord.xbIndex);
                                if (targetNode != null) {
                                    targetGroupSpec = specService.findGroupSpecByXB((XBCNode)targetNode, specDefRecord.targetSpecIndex);
                                    targetRev = (XBEGroupRev)revService.findRevByXB((XBCSpec)targetGroupSpec, specDefRecord.targetRevIndex);
                                    ((XBEFormatCons)def).setTarget((XBCGroupRev)targetRev);
                                }
                                specService.persistSpecDef((XBCSpecDef)def);
                                this.importSpecDefProperties(def, specDefRecord, nameService, descService, striService);
                                break;
                            }
                            case JOIN: {
                                def = (XBEFormatJoin)specService.createSpecDef((XBCSpec)formatSpec, XBParamType.JOIN);
                                def.setXBIndex(specDefRecord.xbIndex);
                                if (targetNode != null) {
                                    XBCFormatSpec targetFormatSpec = specService.findFormatSpecByXB((XBCNode)targetNode, specDefRecord.targetSpecIndex);
                                    targetRev = (XBEFormatRev)revService.findRevByXB((XBCSpec)targetFormatSpec, specDefRecord.targetRevIndex);
                                    ((XBEFormatJoin)def).setTarget((XBCFormatRev)targetRev);
                                }
                                specService.persistSpecDef((XBCSpecDef)def);
                                this.importSpecDefProperties(def, specDefRecord, nameService, descService, striService);
                                break;
                            }
                        }
                    }
                    continue block19;
                }
            }
        }
        serialOutput.pullEnd();
    }

    private void importSpecDefProperties(XBCSpecDef specDef, SpecDefRecord specDefRecord, XBCXNameService nameService, XBCXDescService descService, XBCXStriService striService) {
        for (XBEXName name : specDefRecord.names) {
            name.setItem((XBCItem)specDef);
            nameService.persistItem((XBCBase)name);
        }
        for (XBEXDesc desc : specDefRecord.descs) {
            desc.setItem((XBCItem)specDef);
            descService.persistItem((XBCBase)desc);
        }
        if (specDefRecord.stri != null) {
            specDefRecord.stri.setItem((XBCItem)specDef);
            striService.persistItem((XBCBase)specDefRecord.stri);
        }
    }

    private void importProperties(XBPProviderSerialHandler serialOutput, CatalogItemType itemType) throws XBProcessingException, IOException {
        this.importNames(serialOutput, itemType);
        this.importDescs(serialOutput, itemType);
        this.importStri(serialOutput, itemType);
        this.importHDocs(serialOutput, itemType);
        this.importIcons(serialOutput, itemType);
    }

    private void importNames(XBPProviderSerialHandler serialOutput, CatalogItemType itemType) throws XBProcessingException, IOException {
        XBCXLangService langService = (XBCXLangService)this.catalog.getCatalogService(XBCXLangService.class);
        XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        serialOutput.pullBegin();
        serialOutput.pullType();
        while (!serialOutput.isEndNext()) {
            Optional optionalLanguage;
            serialOutput.pullBegin();
            serialOutput.pullType();
            long xbIndex = serialOutput.pullAttribute().getNaturalLong();
            Long[] nodePath = this.pullPath(serialOutput);
            XBENode parentNode = (XBENode)nodeService.findNodeByXBPath(nodePath);
            XBCItem item = this.findItem(parentNode, xbIndex, itemType);
            XBString langCode = new XBString();
            serialOutput.pullConsist((XBSerializable)langCode);
            XBString text = new XBString();
            serialOutput.pullConsist((XBSerializable)text);
            serialOutput.pullEnd();
            if (itemType == CatalogItemType.NODE && !item.getParentItem().isPresent() || !(optionalLanguage = langService.findByCode(langCode.getValue())).isPresent()) continue;
            XBCXLanguage language = (XBCXLanguage)optionalLanguage.get();
            XBEXName name = (XBEXName)nameService.createItem();
            name.setItem(item);
            name.setText(text.getValue());
            name.setLang(language);
            nameService.persistItem((XBCBase)name);
        }
        serialOutput.pullEnd();
    }

    private void importDescs(XBPProviderSerialHandler serialOutput, CatalogItemType itemType) throws XBProcessingException, IOException {
        XBCXLangService langService = (XBCXLangService)this.catalog.getCatalogService(XBCXLangService.class);
        XBCXDescService descService = (XBCXDescService)this.catalog.getCatalogService(XBCXDescService.class);
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        serialOutput.pullBegin();
        serialOutput.pullType();
        while (!serialOutput.isEndNext()) {
            serialOutput.pullBegin();
            serialOutput.pullType();
            long xbIndex = serialOutput.pullAttribute().getNaturalLong();
            Long[] nodePath = this.pullPath(serialOutput);
            XBENode parentNode = (XBENode)nodeService.findNodeByXBPath(nodePath);
            XBCItem item = this.findItem(parentNode, xbIndex, itemType);
            XBString langCode = new XBString();
            serialOutput.pullConsist((XBSerializable)langCode);
            XBString text = new XBString();
            serialOutput.pullConsist((XBSerializable)text);
            serialOutput.pullEnd();
            Optional optionalLanguage = langService.findByCode(langCode.getValue());
            if (!optionalLanguage.isPresent()) continue;
            XBCXLanguage language = (XBCXLanguage)optionalLanguage.get();
            XBEXDesc desc = (XBEXDesc)descService.createItem();
            desc.setItem(item);
            desc.setText(text.getValue());
            desc.setLang(language);
            descService.persistItem((XBCBase)desc);
        }
        serialOutput.pullEnd();
    }

    private void importStri(XBPProviderSerialHandler serialOutput, CatalogItemType itemType) throws XBProcessingException, IOException {
        XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        serialOutput.pullBegin();
        serialOutput.pullType();
        while (!serialOutput.isEndNext()) {
            serialOutput.pullBegin();
            serialOutput.pullType();
            long xbIndex = serialOutput.pullAttribute().getNaturalLong();
            Long[] nodePath = this.pullPath(serialOutput);
            XBENode parentNode = (XBENode)nodeService.findNodeByXBPath(nodePath);
            XBCItem item = this.findItem(parentNode, xbIndex, itemType);
            XBString text = new XBString();
            serialOutput.pullConsist((XBSerializable)text);
            serialOutput.pullEnd();
            XBEXStri stri = (XBEXStri)striService.createItem();
            stri.setItem(item);
            stri.setText(text.getValue());
            striService.persistItem((XBCBase)stri);
        }
        serialOutput.pullEnd();
    }

    private void importHDocs(XBPProviderSerialHandler serialOutput, CatalogItemType itemType) throws XBProcessingException, IOException {
        XBCXFileService fileService = (XBCXFileService)this.catalog.getCatalogService(XBCXFileService.class);
        XBCXLangService langService = (XBCXLangService)this.catalog.getCatalogService(XBCXLangService.class);
        XBCXHDocService hdocService = (XBCXHDocService)this.catalog.getCatalogService(XBCXHDocService.class);
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        serialOutput.pullBegin();
        serialOutput.pullType();
        while (!serialOutput.isEndNext()) {
            serialOutput.pullBegin();
            serialOutput.pullType();
            long xbIndex = serialOutput.pullAttribute().getNaturalLong();
            Long[] nodePath = this.pullPath(serialOutput);
            XBENode parentNode = (XBENode)nodeService.findNodeByXBPath(nodePath);
            XBCItem item = this.findItem(parentNode, xbIndex, itemType);
            XBString langCode = new XBString();
            serialOutput.pullConsist((XBSerializable)langCode);
            Long[] fileNodePath = this.pullPath(serialOutput);
            XBENode fileNode = (XBENode)nodeService.findNodeByXBPath(fileNodePath);
            XBString fileName = new XBString();
            serialOutput.pullConsist((XBSerializable)fileName);
            serialOutput.pullEnd();
            XBCXLanguage language = (XBCXLanguage)langService.findByCode(langCode.getValue()).get();
            XBCXFile file = fileService.findFile((XBCNode)fileNode, fileName.getValue());
            XBEXHDoc hdoc = (XBEXHDoc)hdocService.createItem();
            hdoc.setItem(item);
            hdoc.setLang(language);
            hdoc.setDocFile(file);
            hdocService.persistItem((XBCBase)hdoc);
        }
        serialOutput.pullEnd();
    }

    private void importIcons(XBPProviderSerialHandler serialOutput, CatalogItemType itemType) throws XBProcessingException, IOException {
        XBCXFileService fileService = (XBCXFileService)this.catalog.getCatalogService(XBCXFileService.class);
        XBCXIconService iconService = (XBCXIconService)this.catalog.getCatalogService(XBCXIconService.class);
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        serialOutput.pullBegin();
        serialOutput.pullType();
        while (!serialOutput.isEndNext()) {
            serialOutput.pullBegin();
            serialOutput.pullType();
            long xbIndex = serialOutput.pullAttribute().getNaturalLong();
            Long[] nodePath = this.pullPath(serialOutput);
            XBENode parentNode = (XBENode)nodeService.findNodeByXBPath(nodePath);
            XBCItem item = this.findItem(parentNode, xbIndex, itemType);
            long iconModeIndex = serialOutput.pullLongAttribute();
            Long[] fileNodePath = this.pullPath(serialOutput);
            XBENode fileNode = (XBENode)nodeService.findNodeByXBPath(fileNodePath);
            XBString fileName = new XBString();
            serialOutput.pullConsist((XBSerializable)fileName);
            serialOutput.pullEnd();
            XBCXFile file = fileService.findFile((XBCNode)fileNode, fileName.getValue());
            XBCXIconMode mode = iconService.getIconMode(Long.valueOf(iconModeIndex));
            XBEXIcon icon = (XBEXIcon)iconService.createItem();
            icon.setParent(item);
            icon.setMode(mode);
            icon.setIconFile(file);
            iconService.persistItem((XBCBase)icon);
        }
        serialOutput.pullEnd();
    }

    private void importPlugins(XBPProviderSerialHandler serialOutput) throws XBProcessingException, IOException {
        XBCXPlugService plugService = (XBCXPlugService)this.catalog.getCatalogService(XBCXPlugService.class);
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCXFileService fileService = (XBCXFileService)this.catalog.getCatalogService(XBCXFileService.class);
        serialOutput.pullBegin();
        serialOutput.pullType();
        while (!serialOutput.isEndNext()) {
            serialOutput.pullBegin();
            serialOutput.pullType();
            Long[] nodePath = this.pullPath(serialOutput);
            XBENode node = (XBENode)nodeService.findNodeByXBPath(nodePath);
            long pluginIndex = serialOutput.pullLongAttribute();
            Long[] fileNodePath = this.pullPath(serialOutput);
            XBENode fileNode = (XBENode)nodeService.findNodeByXBPath(fileNodePath);
            XBString fileName = new XBString();
            serialOutput.pullConsist((XBSerializable)fileName);
            XBEXFile pluginFile = (XBEXFile)fileService.findFile((XBCNode)fileNode, fileName.getValue());
            serialOutput.pullEnd();
            XBEXPlugin plugin = (XBEXPlugin)plugService.createItem();
            plugin.setOwner(node);
            plugin.setPluginFile(pluginFile);
            plugin.setPluginIndex(pluginIndex);
            plugService.persistItem((XBCBase)plugin);
        }
        serialOutput.pullEnd();
    }

    private void importUis(XBPProviderSerialHandler serialOutput) throws XBProcessingException, IOException {
        long methodIndex;
        int uiTypeId;
        long pluginIndex;
        XBENode pluginNode;
        Long[] pluginNodePath;
        XBCXUiService uiService = (XBCXUiService)this.catalog.getCatalogService(XBCXUiService.class);
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCXPlugService plugService = (XBCXPlugService)this.catalog.getCatalogService(XBCXPlugService.class);
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        XBCRevService revService = (XBCRevService)this.catalog.getCatalogService(XBCRevService.class);
        serialOutput.pullBegin();
        serialOutput.pullType();
        serialOutput.pullBegin();
        serialOutput.pullType();
        while (!serialOutput.isEndNext()) {
            serialOutput.pullBegin();
            serialOutput.pullType();
            pluginNodePath = this.pullPath(serialOutput);
            pluginNode = (XBENode)nodeService.findNodeByXBPath(pluginNodePath);
            pluginIndex = serialOutput.pullLongAttribute();
            uiTypeId = serialOutput.pullIntAttribute();
            methodIndex = serialOutput.pullLongAttribute();
            XBString name = new XBString();
            serialOutput.pullConsist((XBSerializable)name);
            serialOutput.pullEnd();
            XBCXPlugin plugin = plugService.findPlugin((XBCNode)pluginNode, Long.valueOf(pluginIndex));
            XBEXPlugUi plugUi = (XBEXPlugUi)uiService.createPlugUi();
            plugUi.setMethodIndex(methodIndex);
            plugUi.setUiType(uiService.findTypeById(uiTypeId));
            plugUi.setName(name.getValue());
            plugUi.setPlugin(plugin);
            uiService.persistPlugUi((XBCXPlugUi)plugUi);
        }
        serialOutput.pullEnd();
        serialOutput.pullBegin();
        serialOutput.pullType();
        while (!serialOutput.isEndNext()) {
            serialOutput.pullBegin();
            serialOutput.pullType();
            pluginNodePath = this.pullPath(serialOutput);
            pluginNode = (XBENode)nodeService.findNodeByXBPath(pluginNodePath);
            pluginIndex = serialOutput.pullLongAttribute();
            uiTypeId = serialOutput.pullIntAttribute();
            methodIndex = serialOutput.pullLongAttribute();
            Long[] specNodePath = this.pullPath(serialOutput);
            XBENode specNode = (XBENode)nodeService.findNodeByXBPath(specNodePath);
            long specXbIndex = serialOutput.pullLongAttribute();
            long revXbIndex = serialOutput.pullLongAttribute();
            long priority = serialOutput.pullLongAttribute();
            XBString name = new XBString();
            serialOutput.pullConsist((XBSerializable)name);
            serialOutput.pullEnd();
            XBCXPlugin plugin = plugService.findPlugin((XBCNode)pluginNode, Long.valueOf(pluginIndex));
            XBCXPlugUi plugUi = uiService.getPlugUi(plugin, XBPlugUiType.findByDbIndex((int)uiTypeId), methodIndex);
            XBCBlockSpec blockSpec = specService.findBlockSpecByXB((XBCNode)specNode, specXbIndex);
            XBCBlockRev blockRev = (XBCBlockRev)revService.findRevByXB((XBCSpec)blockSpec, revXbIndex);
            XBEXBlockUi blockUi = (XBEXBlockUi)uiService.createItem();
            blockUi.setUi(plugUi);
            blockUi.setBlockRev(blockRev);
            blockUi.setPriority(priority);
            blockUi.setName(name.getValue());
            uiService.persistItem((XBCBase)blockUi);
        }
        serialOutput.pullEnd();
        serialOutput.pullEnd();
    }

    @Nonnull
    private Long[] pullPath(XBPProviderSerialHandler serialOutput) throws XBProcessingException, IOException {
        serialOutput.pullBegin();
        serialOutput.pullType();
        int length = serialOutput.pullAttribute().getNaturalInt();
        Long[] result = new Long[length];
        for (int i = 0; i < length; ++i) {
            result[i] = serialOutput.pullAttribute().getNaturalLong();
        }
        serialOutput.pullEnd();
        return result;
    }

    @Nonnull
    private XBCItem findItem(XBENode parentNode, long xbIndex, CatalogItemType itemType) {
        switch (itemType) {
            case NODE: {
                XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
                return nodeService.getSubNode((XBCNode)parentNode, xbIndex);
            }
            case BLOCK: {
                XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
                return specService.findBlockSpecByXB((XBCNode)parentNode, xbIndex);
            }
            case GROUP: {
                XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
                return specService.findGroupSpecByXB((XBCNode)parentNode, xbIndex);
            }
            case FORMAT: {
                XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
                return specService.findFormatSpecByXB((XBCNode)parentNode, xbIndex);
            }
        }
        throw new IllegalStateException("Invalid itemtype " + itemType.name());
    }

    private static class SpecDefRecord {
        List<XBEXName> names = new ArrayList<XBEXName>();
        List<XBEXDesc> descs = new ArrayList<XBEXDesc>();
        XBEXStri stri = null;
        int type;
        long xbIndex;
        Long[] targetNodePath;
        long targetSpecIndex;
        long targetRevIndex;

        private SpecDefRecord() {
        }
    }

    private static class RevRecord {
        long xbIndex;
        long xbLimit;

        private RevRecord() {
        }
    }

    @ParametersAreNonnullByDefault
    private static final class TypeDroppingFilter
    implements XBTEventFilter {
        private XBTEventListener listener;

        public TypeDroppingFilter(XBTEventListener listener) {
            this.listener = listener;
        }

        public void putXBTToken(XBTToken token) throws XBProcessingException, IOException {
            if (token.getTokenType() == XBTTokenType.TYPE) {
                this.listener.putXBTToken((XBTToken)new XBTTypeToken(){

                    public XBBlockType getBlockType() {
                        return new XBFixedBlockType();
                    }
                });
            } else {
                this.listener.putXBTToken(token);
            }
        }

        public void attachXBTEventListener(XBTEventListener eventListener) {
            this.listener = eventListener;
        }
    }
}

