/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.update.service.impl;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.update.UpdateModule;
import org.exbin.framework.update.api.VersionNumbers;
import org.exbin.framework.update.service.CheckForUpdateService;

@ParametersAreNonnullByDefault
public class CheckForUpdateServiceImpl
implements CheckForUpdateService {
    private final UpdateModule guiUpdateModule;
    private Thread checkingThread = null;

    public CheckForUpdateServiceImpl(UpdateModule guiUpdateModule) {
        this.guiUpdateModule = guiUpdateModule;
    }

    @Override
    public VersionNumbers getCurrentVersion() {
        return this.guiUpdateModule.getCurrentVersion();
    }

    @Override
    @Nullable
    public VersionNumbers getUpdateVersion() {
        return this.guiUpdateModule.getUpdateVersion();
    }

    @Override
    @Nullable
    public URL getDownloadUrl() {
        return this.guiUpdateModule.getUpdateDownloadUrl();
    }

    @Override
    public void performCheckForUpdates(CheckForUpdateService.BackgroundCheckListener listener) {
        if (this.checkingThread != null) {
            this.checkingThread.interrupt();
        }
        this.checkingThread = new Thread(() -> {
            CheckForUpdateService.CheckForUpdateResult result = this.checkForUpdate();
            VersionNumbers updateVersion = this.guiUpdateModule.getUpdateVersion();
            listener.checkFinished(result, updateVersion);
        });
        this.checkingThread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public CheckForUpdateService.CheckForUpdateResult checkForUpdate() {
        URL checkUpdateUrl = this.guiUpdateModule.getUpdateUrl();
        if (checkUpdateUrl == null) {
            return CheckForUpdateService.CheckForUpdateResult.UPDATE_URL_NOT_SET;
        }
        try {
            VersionNumbers updateVersion;
            try (InputStream checkUpdateStream = checkUpdateUrl.openStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(checkUpdateStream));){
                String line = reader.readLine();
                if (line == null) {
                    CheckForUpdateService.CheckForUpdateResult checkForUpdateResult = CheckForUpdateService.CheckForUpdateResult.NOT_FOUND;
                    return checkForUpdateResult;
                }
                updateVersion = new VersionNumbers();
                updateVersion.versionFromString(line);
                this.guiUpdateModule.setUpdateVersion(updateVersion);
            }
            if (!updateVersion.isGreaterThan(this.guiUpdateModule.getCurrentVersion())) return CheckForUpdateService.CheckForUpdateResult.NO_UPDATE_AVAILABLE;
            return CheckForUpdateService.CheckForUpdateResult.UPDATE_FOUND;
        }
        catch (FileNotFoundException ex) {
            return CheckForUpdateService.CheckForUpdateResult.NOT_FOUND;
        }
        catch (IOException ex) {
            return CheckForUpdateService.CheckForUpdateResult.CONNECTION_ISSUE;
        }
        catch (Exception ex) {
            return CheckForUpdateService.CheckForUpdateResult.CONNECTION_ISSUE;
        }
    }
}

