/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.data.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import org.exbin.framework.action.ActionModule;
import org.exbin.framework.api.XBApplicationModule;
import org.exbin.framework.component.ComponentModule;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActions;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandler;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandlerEmpty;
import org.exbin.framework.component.api.toolbar.MoveItemActions;
import org.exbin.framework.component.api.toolbar.MoveItemActionsHandler;
import org.exbin.framework.component.api.toolbar.MoveItemActionsHandlerEmpty;
import org.exbin.framework.component.gui.ToolBarSidePanel;
import org.exbin.framework.data.gui.DefinitionPropertiesComponent;
import org.exbin.framework.data.model.CatalogDefsTableModel;
import org.exbin.framework.operation.undo.OperationUndoModule;
import org.exbin.framework.operation.undo.api.UndoActions;
import org.exbin.framework.operation.undo.api.UndoActionsHandler;
import org.exbin.framework.operation.undo.api.UndoActionsHandlerEmpty;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsHandlerEmpty;
import org.exbin.framework.utils.ClipboardActionsUpdater;
import org.exbin.framework.utils.TestApplication;
import org.exbin.framework.utils.UtilsModule;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;

@ParametersAreNonnullByDefault
public class DefinitionEditorPanel
extends JPanel {
    private XBACatalog catalog;
    private XBCItem catalogItem;
    private CatalogDefsTableModel defsModel;
    private DefinitionPropertiesComponent propertiesComponent = new DefinitionPropertiesComponent();
    private ToolBarSidePanel toolBarSidePanel;
    private JSplitPane definitionControlSplitPane;
    private JScrollPane definitionScrollPane;
    private JTable definitionsTable;

    public DefinitionEditorPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.add((Component)this.definitionControlSplitPane, "Center");
        this.toolBarSidePanel = new ToolBarSidePanel();
        this.toolBarSidePanel.add((Component)this.definitionScrollPane);
        this.definitionControlSplitPane.setLeftComponent((Component)this.toolBarSidePanel);
        this.definitionControlSplitPane.setRightComponent(this.propertiesComponent);
        this.definitionsTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int selectedRow = this.definitionsTable.getSelectedRow();
                this.propertiesComponent.setItem(selectedRow >= 0 ? this.defsModel.getRowItem(selectedRow) : null);
                this.propertiesComponent.repaint();
                this.updateItemStatus();
            }
        });
        this.updateItemStatus();
    }

    private void initComponents() {
        this.definitionScrollPane = new JScrollPane();
        this.definitionsTable = new JTable();
        this.definitionControlSplitPane = new JSplitPane();
        this.definitionsTable.setSelectionMode(0);
        this.definitionScrollPane.setViewportView(this.definitionsTable);
        this.definitionControlSplitPane.setDividerLocation(400);
        this.setLayout(new BorderLayout());
    }

    public static void main(String[] args) {
        TestApplication testApplication = UtilsModule.getDefaultAppEditor();
        OperationUndoModule operationUndoModule = new OperationUndoModule();
        testApplication.addModule(OperationUndoModule.MODULE_ID, (XBApplicationModule)operationUndoModule);
        ActionModule guiActionModule = new ActionModule();
        testApplication.addModule(ActionModule.MODULE_ID, (XBApplicationModule)guiActionModule);
        ComponentModule guiComponentModule = new ComponentModule();
        testApplication.addModule(ComponentModule.MODULE_ID, (XBApplicationModule)guiComponentModule);
        DefinitionEditorPanel definitionEditorPanel = new DefinitionEditorPanel();
        UndoActionsHandlerEmpty undoActionsHandler = new UndoActionsHandlerEmpty();
        definitionEditorPanel.setUndoHandler((UndoActionsHandler)undoActionsHandler, operationUndoModule.createUndoActions((UndoActionsHandler)undoActionsHandler));
        ClipboardActionsHandlerEmpty clipboardActionsHandler = new ClipboardActionsHandlerEmpty();
        definitionEditorPanel.setClipboardHandler((ClipboardActionsHandler)clipboardActionsHandler, guiActionModule.createClipboardActions((ClipboardActionsHandler)clipboardActionsHandler));
        WindowUtils.invokeDialog((JComponent)definitionEditorPanel);
        MoveItemActionsHandlerEmpty moveItemActionsHandler = new MoveItemActionsHandlerEmpty();
        MoveItemActions moveItemActions = guiComponentModule.createMoveItemActions((MoveItemActionsHandler)moveItemActionsHandler);
        EditItemActionsHandlerEmpty editItemActionsHandler = new EditItemActionsHandlerEmpty();
        EditItemActions editItemActions = guiComponentModule.createEditItemActions((EditItemActionsHandler)editItemActionsHandler);
        editItemActions.setEditItemActionsHandler((EditItemActionsHandler)editItemActionsHandler);
        definitionEditorPanel.registerToolBarActions(editItemActions, moveItemActions);
    }

    private void updateItemStatus() {
        this.definitionsTable.repaint();
    }

    @Nullable
    public XBCItem getCatalogItem() {
        return this.catalogItem;
    }

    public void setCatalogItem(XBCItem catalogItem) {
        this.catalogItem = catalogItem;
        if (this.defsModel != null) {
            this.defsModel.setCatalogItem(catalogItem);
            this.updateItemStatus();
        }
    }

    @Nullable
    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setDefsTableMode(CatalogDefsTableModel defsTableModel) {
        this.defsModel = defsTableModel;
        this.definitionsTable.setModel(this.defsModel);
        if (this.catalogItem != null) {
            this.defsModel.setCatalogItem(this.catalogItem);
            this.updateItemStatus();
        }
    }

    @Nullable
    public CatalogDefsTableModel getDefsModel() {
        return this.defsModel;
    }

    public void setUndoHandler(UndoActionsHandler undoHandler, UndoActions undoActions) {
    }

    public void setClipboardHandler(ClipboardActionsHandler clipboardHandler, ClipboardActionsUpdater clipboardActions) {
    }

    public void registerToolBarActions(EditItemActions editItemActions, MoveItemActions moveItemActions) {
        this.toolBarSidePanel.addActions((ActionsProvider)editItemActions);
        this.toolBarSidePanel.addSeparator();
        this.toolBarSidePanel.addActions((ActionsProvider)moveItemActions);
    }
}

