/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.spec.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemType;
import org.exbin.framework.xbup.catalog.item.spec.gui.CatalogSelectSpecTreeModel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;

@ParametersAreNonnullByDefault
public class CatalogSelectSpecPanel
extends JPanel {
    private XBCXNameService nameService = null;
    private CatalogSelectSpecTreeModel treeModel;
    private SelectionListener selectionListener = null;
    private XBCItem selectedItem;
    private final CatalogItemType specType;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogSelectSpecPanel.class);
    private JScrollPane scrollPane;
    private JTree specSelectTree;

    public CatalogSelectSpecPanel(CatalogItemType specType) {
        this.specType = specType;
        this.treeModel = new CatalogSelectSpecTreeModel(null, specType);
        this.selectedItem = null;
        this.initComponents();
        this.specSelectTree.getSelectionModel().setSelectionMode(1);
        this.specSelectTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultTreeCellRenderer retValue = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof XBCNode) {
                    XBCNode node = (XBCNode)value;
                    if (CatalogSelectSpecPanel.this.nameService != null) {
                        XBCXName name = CatalogSelectSpecPanel.this.nameService.getDefaultItemName((XBCItem)node);
                        if (name == null) {
                            retValue.setText("unknown name");
                        } else {
                            retValue.setText(name.getText());
                        }
                    } else {
                        retValue.setText("node");
                    }
                } else if (value instanceof XBCSpec) {
                    XBCSpec spec = (XBCSpec)value;
                    if (CatalogSelectSpecPanel.this.nameService != null) {
                        XBCXName name = CatalogSelectSpecPanel.this.nameService.getDefaultItemName((XBCItem)spec);
                        if (name == null) {
                            retValue.setText("unknown name");
                        } else {
                            retValue.setText(name.getText());
                        }
                    } else {
                        retValue.setText("node");
                    }
                }
                return retValue;
            }
        });
        this.specSelectTree.getSelectionModel().addTreeSelectionListener(e -> {
            XBCItem item = (XBCItem)this.specSelectTree.getLastSelectedPathComponent();
            if (item instanceof XBCNode && specType != CatalogItemType.NODE) {
                item = null;
            }
            if (item == null) {
                if (this.selectedItem != null) {
                    this.selectedItem = null;
                    if (this.selectionListener != null) {
                        this.selectionListener.selectedItem(this.selectedItem);
                    }
                }
            } else if (this.selectedItem != item) {
                this.selectedItem = item;
                if (this.selectionListener != null) {
                    this.selectionListener.selectedItem(this.selectedItem);
                }
            }
        });
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setCatalog(XBACatalog catalog) {
        this.treeModel = new CatalogSelectSpecTreeModel(catalog, this.specType);
        this.specSelectTree.setModel(this.treeModel);
        this.nameService = catalog == null ? null : (XBCXNameService)catalog.getCatalogService(XBCXNameService.class);
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.specSelectTree = new JTree();
        this.setLayout(new BorderLayout());
        this.specSelectTree.setModel(this.treeModel);
        this.scrollPane.setViewportView(this.specSelectTree);
        this.add((Component)this.scrollPane, "Center");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogSelectSpecPanel(CatalogItemType.NODE));
    }

    @Nullable
    public XBCItem getSpec() {
        return (XBCItem)this.specSelectTree.getLastSelectedPathComponent();
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }

    public static interface SelectionListener {
        public void selectedItem(XBCItem var1);
    }
}

