/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.property.gui;

import java.awt.Component;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemType;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogPropertyTableCellPanel;
import org.exbin.framework.xbup.catalog.item.spec.gui.CatalogSelectSpecPanel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;

@ParametersAreNonnullByDefault
public class CatalogParentPropertyTableCellPanel
extends CatalogPropertyTableCellPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private XBCNode parent;

    public CatalogParentPropertyTableCellPanel(XBACatalog catalog) {
        this.catalog = catalog;
        this.init();
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    private void init() {
        this.setEditorAction(e -> this.performEditorAction());
    }

    public void performEditorAction() {
        if (this.parent == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You cannot move root node", "Editing not allowed", 0);
            return;
        }
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CatalogSelectSpecPanel panel = new CatalogSelectSpecPanel(CatalogItemType.NODE);
        panel.setCatalog(this.catalog);
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        DefaultControlHandler.DefaultControlEnablementListener enablementListener = controlPanel.createEnablementListener();
        panel.setSelectionListener(item -> enablementListener.actionEnabled(DefaultControlHandler.ControlActionType.OK, item != null));
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)panel, (JPanel)controlPanel);
        frameModule.setDialogTitle(dialog, panel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                this.parent = (XBCNode)panel.getSpec();
                this.setNodeLabel();
            }
            dialog.close();
        });
        dialog.showCentered((Component)((Object)this));
        dialog.dispose();
    }

    public void setCatalogItem(XBCItem catalogItem) {
        this.parent = catalogItem.getParentItem().orElse(null);
        this.setNodeLabel();
    }

    private void setNodeLabel() {
        XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
        String targetCaption = this.parent == null ? null : nameService.getItemNamePath((XBCItem)this.parent);
        targetCaption = targetCaption == null ? "" : targetCaption + " ";
        if (this.parent != null) {
            targetCaption = targetCaption + "(" + Long.toString(this.parent.getId()) + ")";
        }
        this.setPropertyText(targetCaption);
    }

    @Nonnull
    public Optional<XBCNode> getParentNode() {
        return Optional.ofNullable(this.parent);
    }

    @Nonnull
    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }
}

