/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.property.gui;

import java.awt.event.ActionEvent;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.xbup.catalog.item.property.action.EditBlockPaneAction;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogPropertyTableCellPanel;
import org.exbin.xbup.catalog.entity.XBEXBlockUi;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCXBlockUi;
import org.exbin.xbup.core.catalog.base.XBCXPlugUi;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;

@ParametersAreNonnullByDefault
public class CatalogPEditorPropertyTableCellPanel
extends CatalogPropertyTableCellPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private long paneId;
    private XBCBlockRev blockRev;
    private XBCXPlugUi plugUi;
    private EditBlockPaneAction editBlockPaneAction = new EditBlockPaneAction();

    public CatalogPEditorPropertyTableCellPanel(XBACatalog catalog) {
        this.catalog = catalog;
        this.init();
    }

    private void init() {
        this.setEditorAction(e -> this.performEditorAction(e));
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void performEditorAction(ActionEvent event) {
        this.editBlockPaneAction.actionPerformed(event);
        XBEXBlockUi resultBlockPane = this.editBlockPaneAction.getResultBlockPane();
        if (resultBlockPane != null) {
            this.paneId = resultBlockPane.getId();
            this.setPropertyLabel();
        }
    }

    public void setCatalogItem(XBCItem catalogItem) {
        XBCXUiService uiService = (XBCXUiService)this.catalog.getCatalogService(XBCXUiService.class);
        XBCRevService revService = (XBCRevService)this.catalog.getCatalogService(XBCRevService.class);
        long maxRev = revService.findMaxRevXB((XBCSpec)((XBCBlockSpec)catalogItem));
        this.blockRev = (XBCBlockRev)revService.findRevByXB((XBCSpec)((XBCBlockSpec)catalogItem), maxRev);
        XBCXBlockUi blockUi = uiService.findUiByPR(this.blockRev, XBPlugUiType.PANEL_EDITOR, 0L);
        this.plugUi = blockUi == null ? null : blockUi.getUi();
        this.paneId = blockUi == null ? 0L : blockUi.getId();
        this.editBlockPaneAction.setCurrentBlockRev(this.blockRev);
        this.editBlockPaneAction.setCurrentPlugUi(this.plugUi);
        this.setPropertyLabel();
    }

    private void setPropertyLabel() {
        this.setPropertyText(this.paneId > 0L ? String.valueOf(this.paneId) : "");
    }

    public long getPaneId() {
        return this.paneId;
    }

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }
}

