/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import org.exbin.framework.action.api.MenuManagement;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.UiUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.catalog.YamlFileType;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemPanel;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemsSearchPanel;
import org.exbin.framework.xbup.catalog.item.spec.gui.CatalogSpecsTableModel;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.convert.XBCatalogYaml;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCXDesc;
import org.exbin.xbup.core.catalog.base.XBCXStri;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;

public class CatalogSearchPanel
extends JPanel {
    private XBApplication application;
    private XBCItem currentItem;
    private XBACatalog catalog;
    private final CatalogItemsSearchPanel searchPanel;
    private final CatalogSpecsTableModel specsModel;
    private final CatalogItemPanel itemPanel;
    private final XBCatalogYaml catalogYaml;
    private XBCNodeService nodeService;
    private XBCSpecService specService;
    private XBCXNameService nameService;
    private XBCXDescService descService;
    private XBCXStriService striService;
    private final Map<String, ActionListener> actionListenerMap = new HashMap<String, ActionListener>();
    private MenuManagement menuManagement;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogSearchPanel.class);
    private JSplitPane catalogItemSplitPane;
    private JPopupMenu catalogTreePopupMenu;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JMenuItem popupExportItemMenuItem;
    private JMenuItem popupRefreshMenuItem;

    public CatalogSearchPanel() {
        this.searchPanel = new CatalogItemsSearchPanel();
        this.specsModel = new CatalogSpecsTableModel();
        this.catalogYaml = new XBCatalogYaml();
        this.itemPanel = new CatalogItemPanel();
        this.initComponents();
        this.catalogItemSplitPane.setLeftComponent(this.searchPanel);
        this.catalogItemSplitPane.setRightComponent(this.itemPanel);
        this.searchPanel.setSelectionListener(this.itemPanel::setItem);
        this.actionListenerMap.put("cut-to-clipboard", e -> this.performCut());
        this.actionListenerMap.put("copy-to-clipboard", e -> this.performCopy());
        this.actionListenerMap.put("paste-from-clipboard", e -> this.performPaste());
        this.actionListenerMap.put("delete-next", e -> this.performDelete());
        this.actionListenerMap.put("delete", e -> this.performDelete());
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.searchPanel.setApplication(application);
    }

    private void initComponents() {
        this.catalogTreePopupMenu = new JPopupMenu();
        this.popupRefreshMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.popupExportItemMenuItem = new JMenuItem();
        this.catalogItemSplitPane = new JSplitPane();
        this.catalogTreePopupMenu.setName("catalogTreePopupMenu");
        this.popupRefreshMenuItem.setText(this.resourceBundle.getString("refreshMenuItem.text"));
        this.popupRefreshMenuItem.setToolTipText(this.resourceBundle.getString("refreshMenuItem.toolTipText"));
        this.popupRefreshMenuItem.setName("popupRefreshMenuItem");
        this.popupRefreshMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogSearchPanel.this.popupRefreshMenuItemActionPerformed(evt);
            }
        });
        this.catalogTreePopupMenu.add(this.popupRefreshMenuItem);
        this.jSeparator1.setName("jSeparator1");
        this.catalogTreePopupMenu.add(this.jSeparator1);
        this.jSeparator2.setName("jSeparator2");
        this.catalogTreePopupMenu.add(this.jSeparator2);
        this.popupExportItemMenuItem.setText(this.resourceBundle.getString("exportItemMenuItem.text"));
        this.popupExportItemMenuItem.setToolTipText(this.resourceBundle.getString("exportItemMenuItem.toolTipText"));
        this.popupExportItemMenuItem.setName("popupExportItemMenuItem");
        this.popupExportItemMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogSearchPanel.this.popupExportItemMenuItemActionPerformed(evt);
            }
        });
        this.catalogTreePopupMenu.add(this.popupExportItemMenuItem);
        this.setName("Form");
        this.setLayout(new BorderLayout());
        this.catalogItemSplitPane.setDividerLocation(180);
        this.catalogItemSplitPane.setOrientation(0);
        this.catalogItemSplitPane.setName("catalogItemSplitPane");
        this.add((Component)this.catalogItemSplitPane, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popupExportItemMenuItemActionPerformed(ActionEvent evt) {
        if (this.currentItem != null) {
            JFileChooser exportFileChooser = new JFileChooser();
            exportFileChooser.addChoosableFileFilter(new YamlFileType());
            exportFileChooser.setAcceptAllFileFilterUsed(true);
            if (exportFileChooser.showSaveDialog(UiUtils.getFrame((Component)this)) == 0) {
                try (FileWriter fileWriter = new FileWriter(exportFileChooser.getSelectedFile().getAbsolutePath());){
                    this.catalogYaml.exportCatalogItem(this.currentItem, (Writer)fileWriter);
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(CatalogSearchPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(CatalogSearchPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void popupRefreshMenuItemActionPerformed(ActionEvent evt) {
        Component invoker = this.catalogTreePopupMenu.getInvoker();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogSearchPanel());
    }

    public void setItem(XBCItem item) {
        this.currentItem = item;
        this.itemPanel.setItem(item);
    }

    public boolean updateActionStatus(Component component) {
        return false;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.nodeService = catalog == null ? null : (XBCNodeService)catalog.getCatalogService(XBCNodeService.class);
        this.specService = catalog == null ? null : (XBCSpecService)catalog.getCatalogService(XBCSpecService.class);
        this.nameService = catalog == null ? null : (XBCXNameService)catalog.getCatalogService(XBCXNameService.class);
        this.descService = catalog == null ? null : (XBCXDescService)catalog.getCatalogService(XBCXDescService.class);
        this.striService = catalog == null ? null : (XBCXStriService)catalog.getCatalogService(XBCXStriService.class);
        this.specsModel.setCatalog(catalog);
        this.catalogYaml.setCatalog(catalog);
        this.itemPanel.setCatalog(catalog);
        this.searchPanel.setCatalog(catalog);
    }

    public void performCut() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performCopy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performPaste() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performDelete() {
        Object[] options = new Object[]{"Delete", "Cancel"};
        int result = JOptionPane.showOptionDialog(this, "Are you sure you want to delete this item?", "Delete Item", 1, 3, null, options, options[0]);
        if (result == 0) {
            EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
            EntityTransaction transaction = em.getTransaction();
            transaction.begin();
            List names = this.nameService.getItemNames(this.currentItem);
            for (Object name : names) {
                this.nameService.removeItem((XBCBase)name);
            }
            List descs = this.descService.getItemDescs(this.currentItem);
            for (XBCXDesc desc : descs) {
                this.descService.removeItem((XBCBase)desc);
            }
            XBCXStri stri = this.striService.getItemStringId(this.currentItem);
            if (stri != null) {
                this.striService.removeItem((XBCBase)stri);
            }
            if (this.currentItem instanceof XBCNode) {
                this.nodeService.removeItem((XBCBase)((XBCNode)this.currentItem));
            } else {
                this.specService.removeItem((XBCBase)((XBCSpec)this.currentItem));
            }
            em.flush();
            transaction.commit();
            this.repaint();
        }
    }

    public boolean performAction(String eventName, ActionEvent event) {
        return false;
    }

    public void setMenuManagement(MenuManagement menuManagement) {
        this.menuManagement = menuManagement;
        menuManagement.insertMainPopupMenu(this.catalogTreePopupMenu, 4);
    }
}

