/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXHDocService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;

@ParametersAreNonnullByDefault
public class CatalogItemInfoPanel
extends JPanel {
    private XBACatalog catalog;
    private String defaultText;
    private Mode mode = Mode.BASIC;
    private JEditorPane mainEditorPane;
    private JScrollPane mainScrollPane;

    public CatalogItemInfoPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.defaultText = this.mainEditorPane.getText();
    }

    private void initComponents() {
        this.mainScrollPane = new JScrollPane();
        this.mainEditorPane = new JEditorPane();
        this.setLayout(new BorderLayout());
        this.mainEditorPane.setEditable(false);
        this.mainEditorPane.setContentType("text/html");
        this.mainEditorPane.setText("<html>\n  <head>\n\n  </head>\n  <body>\n    <p style=\"margin-top: 0\">\n      No catalog item was selected.\n    </p>\n  </body>\n</html>\n");
        this.mainScrollPane.setViewportView(this.mainEditorPane);
        this.add((Component)this.mainScrollPane, "Center");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogItemInfoPanel());
    }

    public void setItem(@Nullable XBCItem item) {
        if (item == null) {
            this.mainEditorPane.setText(this.defaultText);
            return;
        }
        XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
        XBCXDescService descService = (XBCXDescService)this.catalog.getCatalogService(XBCXDescService.class);
        XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
        XBCXHDocService hdocService = (XBCXHDocService)this.catalog.getCatalogService(XBCXHDocService.class);
        String nameOrId = nameService.getDefaultText(item);
        if (nameOrId == null || nameOrId.isEmpty()) {
            nameOrId = String.valueOf(item.getId());
        }
        String stringId = striService.getItemStringIdText(item);
        String name = nameService.getDefaultText(item);
        String desc = descService.getDefaultText(item);
        String hdoc = hdocService.getDocumentationBodyText(item);
        StringBuilder builder = new StringBuilder();
        builder.append("<html><head></head><body>");
        builder.append("\n");
        if (this.mode != Mode.BASIC) {
            builder.append("<h1>Block: ").append(nameOrId).append("</h1>");
            builder.append("\n");
            builder.append("Id : ").append(String.valueOf(item.getId())).append("<br/>");
            builder.append("\n");
        }
        builder.append("String Id : ").append(stringId).append("<br/>");
        builder.append("\n");
        builder.append("Name : ").append(name).append("<br/>");
        builder.append("\n");
        builder.append("Description : ").append(desc).append("<br/>");
        if (hdoc != null && !hdoc.isEmpty()) {
            builder.append("\n");
            builder.append("\n");
            builder.append("<h2>Documentation</h2>");
            builder.append("\n");
            builder.append(hdoc);
            builder.append("\n");
        }
        builder.append("</body></html>");
        builder.append("\n");
        this.mainEditorPane.setText(builder.toString());
    }

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    @Nonnull
    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public static enum Mode {
        BASIC,
        FULL;

    }
}

