/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.file.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemPanel;
import org.exbin.xbup.catalog.convert.XBCatalogYaml;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCXFile;

@ParametersAreNonnullByDefault
public class SaveFileContentAsAction
extends AbstractAction {
    public static final String ACTION_ID = "saveCatalogItemFileContentAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(SaveFileContentAsAction.class);
    private XBApplication application;
    private XBACatalog catalog;
    private final XBCatalogYaml catalogYaml = new XBCatalogYaml();
    private Component parentComponent;
    private XBCXFile currentFile;

    public void setup(XBApplication application) {
        this.application = application;
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    @Nullable
    public XBCXFile getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(@Nullable XBCXFile currentFile) {
        this.currentFile = currentFile;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.currentFile != null) {
            JFileChooser saveFileChooser = new JFileChooser(this.currentFile.getFilename());
            saveFileChooser.setAcceptAllFileFilterUsed(true);
            if (saveFileChooser.showSaveDialog(this.parentComponent) == 0) {
                try (FileOutputStream fileStream = new FileOutputStream(saveFileChooser.getSelectedFile().getAbsolutePath());){
                    fileStream.write(this.currentFile.getContent());
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(CatalogItemPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(CatalogItemPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalogYaml.setCatalog(catalog);
    }
}

