/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.file;

import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.exbin.framework.action.api.MenuManagement;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.action.DefaultEditItemActions;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandler;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.xbup.catalog.item.file.action.AddFileAction;
import org.exbin.framework.xbup.catalog.item.file.action.DeleteFileAction;
import org.exbin.framework.xbup.catalog.item.file.action.RenameFileAction;
import org.exbin.framework.xbup.catalog.item.file.action.ReplaceFileContentAction;
import org.exbin.framework.xbup.catalog.item.file.action.SaveFileContentAsAction;
import org.exbin.framework.xbup.catalog.item.file.gui.CatalogFilesTableModel;
import org.exbin.framework.xbup.catalog.item.file.gui.CatalogItemEditFilesPanel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXFile;

@ParametersAreNonnullByDefault
public class CatalogFilesEditor {
    private final CatalogItemEditFilesPanel catalogEditorPanel;
    private final DefaultEditItemActions editActions;
    private XBApplication application;
    private XBACatalog catalog;
    private JPopupMenu popupMenu;
    private XBCNode node;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogFilesEditor.class);
    private AddFileAction addFileAction = new AddFileAction();
    private RenameFileAction renameFileAction = new RenameFileAction();
    private DeleteFileAction deleteFileAction = new DeleteFileAction();
    private SaveFileContentAsAction saveFileContentAsAction = new SaveFileContentAsAction();
    private ReplaceFileContentAction replaceFileContentAction = new ReplaceFileContentAction();

    public CatalogFilesEditor() {
        this.catalogEditorPanel = new CatalogItemEditFilesPanel();
        this.editActions = new DefaultEditItemActions(DefaultEditItemActions.Mode.DIALOG);
        this.editActions.setEditItemActionsHandler(new EditItemActionsHandler(){

            public void performAddItem() {
                CatalogFilesEditor.this.addFileAction.setCurrentNode(CatalogFilesEditor.this.node);
                CatalogFilesEditor.this.addFileAction.actionPerformed(null);
                String resultName = CatalogFilesEditor.this.addFileAction.getResultName();
                if (resultName != null) {
                    byte[] resultData = CatalogFilesEditor.this.addFileAction.getResultData();
                    CatalogFilesTableModel filesModel = CatalogFilesEditor.this.catalogEditorPanel.getFilesModel();
                    filesModel.addItem(resultName, resultData);
                }
            }

            public void performEditItem() {
                CatalogFilesEditor.this.renameFileAction.setCurrentFile(CatalogFilesEditor.this.catalogEditorPanel.getSelectedFile());
                CatalogFilesEditor.this.renameFileAction.actionPerformed(null);
            }

            public void performDeleteItem() {
                int selectedIndex = CatalogFilesEditor.this.catalogEditorPanel.getSelectedIndex();
                CatalogFilesEditor.this.deleteFileAction.actionPerformed(null);
                CatalogFilesTableModel filesModel = CatalogFilesEditor.this.catalogEditorPanel.getFilesModel();
                filesModel.removeItem(selectedIndex);
            }

            public boolean canAddItem() {
                return true;
            }

            public boolean canEditItem() {
                XBCXFile file = CatalogFilesEditor.this.catalogEditorPanel.getSelectedFile();
                return file != null;
            }

            public boolean canDeleteItem() {
                return false;
            }

            public void setUpdateListener(@Nonnull EditItemActionsUpdateListener updateListener) {
                CatalogFilesEditor.this.catalogEditorPanel.addSelectionListener(updateListener);
            }
        });
        this.addFileAction.setParentComponent(this.catalogEditorPanel);
        this.renameFileAction.setParentComponent(this.catalogEditorPanel);
        this.saveFileContentAsAction.setParentComponent(this.catalogEditorPanel);
        this.replaceFileContentAction.setParentComponent(this.catalogEditorPanel);
        this.catalogEditorPanel.addFileActions((ActionsProvider)this.editActions);
    }

    @Nonnull
    public CatalogItemEditFilesPanel getCatalogEditorPanel() {
        return this.catalogEditorPanel;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.catalogEditorPanel.setApplication(application);
        this.addFileAction.setup(application);
        this.renameFileAction.setup(application);
        this.saveFileContentAsAction.setup(application);
        this.replaceFileContentAction.setup(application);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.catalogEditorPanel.setCatalog(catalog);
        this.addFileAction.setCatalog(catalog);
        this.renameFileAction.setCatalog(catalog);
        this.saveFileContentAsAction.setCatalog(catalog);
        this.replaceFileContentAction.setCatalog(catalog);
        this.popupMenu = new JPopupMenu();
        JMenuItem addFileMenuItem = ActionUtils.actionToMenuItem((Action)this.editActions.getAddItemAction());
        addFileMenuItem.setText(this.resourceBundle.getString("addFileMenuItem.text") + "...");
        this.popupMenu.add(addFileMenuItem);
        JMenuItem editFileMenuItem = ActionUtils.actionToMenuItem((Action)this.editActions.getEditItemAction());
        editFileMenuItem.setText(this.resourceBundle.getString("editFileMenuItem.text") + "...");
        this.popupMenu.add(editFileMenuItem);
        this.popupMenu.addSeparator();
        JMenuItem saveFileContentAsMenuItem = ActionUtils.actionToMenuItem((Action)this.saveFileContentAsAction);
        saveFileContentAsMenuItem.removeActionListener(this.saveFileContentAsAction);
        saveFileContentAsMenuItem.addActionListener(event -> {
            this.saveFileContentAsAction.setCurrentFile(this.catalogEditorPanel.getSelectedFile());
            this.saveFileContentAsAction.actionPerformed(event);
        });
        saveFileContentAsMenuItem.setText((String)this.saveFileContentAsAction.getValue("Name"));
        this.popupMenu.add(saveFileContentAsMenuItem);
        JMenuItem replaceFileContentMenuItem = ActionUtils.actionToMenuItem((Action)this.replaceFileContentAction);
        replaceFileContentMenuItem.removeActionListener(this.replaceFileContentAction);
        replaceFileContentMenuItem.addActionListener(event -> {
            int selectedIndex = this.catalogEditorPanel.getSelectedIndex();
            this.replaceFileContentAction.setCurrentFile(this.catalogEditorPanel.getSelectedFile());
            this.replaceFileContentAction.actionPerformed(event);
            String resultName = this.replaceFileContentAction.getResultName();
            if (resultName != null) {
                byte[] resultData = this.replaceFileContentAction.getResultData();
                CatalogFilesTableModel filesModel = this.catalogEditorPanel.getFilesModel();
                filesModel.setItemData(selectedIndex, resultData);
            }
        });
        replaceFileContentMenuItem.setText((String)this.replaceFileContentAction.getValue("Name"));
        this.popupMenu.add(replaceFileContentMenuItem);
        this.catalogEditorPanel.setPanelPopup(this.popupMenu);
    }

    public void setNode(XBCNode node) {
        this.node = node;
        this.catalogEditorPanel.setNode(node);
    }

    public void setMenuManagement(MenuManagement menuManagement) {
        menuManagement.insertMainPopupMenu(this.popupMenu, 5);
    }

    public void persist() {
        this.catalogEditorPanel.persist();
    }
}

