/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.UiUtils;
import org.exbin.framework.xbup.catalog.XBFileType;
import org.exbin.xbup.catalog.convert.XBCatalogXb;
import org.exbin.xbup.core.catalog.XBACatalog;

@ParametersAreNonnullByDefault
public class ExportCatalogItemAction
extends AbstractAction {
    public static final String ACTION_ID = "exportCatalogItemAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ExportCatalogItemAction.class);
    private XBApplication application;
    private XBACatalog catalog;

    public void setup(XBApplication application, XBACatalog catalog) {
        this.application = application;
        this.catalog = catalog;
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        JFileChooser exportFileChooser = new JFileChooser();
        XBFileType xbFileType = new XBFileType();
        exportFileChooser.addChoosableFileFilter(xbFileType);
        exportFileChooser.setAcceptAllFileFilterUsed(true);
        if (exportFileChooser.showSaveDialog(UiUtils.getFrame((Component)frameModule.getFrame())) == 0) {
            XBCatalogXb catalogXb = new XBCatalogXb();
            catalogXb.setCatalog(this.catalog);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(exportFileChooser.getSelectedFile());
                catalogXb.exportToXbFile((OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(ExportCatalogItemAction.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(ExportCatalogItemAction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

