/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.action.DefaultEditItemActions;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandler;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandlerEmpty;
import org.exbin.framework.component.gui.ToolBarSidePanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCRoot;
import org.exbin.xbup.core.catalog.base.service.XBCRootService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;

@ParametersAreNonnullByDefault
public class CatalogsManagerPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogsManagerPanel.class);
    private final ToolBarSidePanel toolBar = new ToolBarSidePanel();
    private XBACatalog catalog;
    private List<XBCRoot> catalogRoots;
    private JScrollPane catalogsScrollPane;
    private JTable catalogsTable;

    public CatalogsManagerPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.add((Component)this.toolBar, "West");
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void addActions(ActionsProvider actionsProvider) {
        this.toolBar.addActions(actionsProvider);
    }

    public void setApplication(XBApplication application) {
    }

    public void setCatalog(@Nullable XBACatalog catalog) {
        this.catalog = catalog;
        if (catalog != null) {
            this.reload();
        }
    }

    public void reload() {
        DefaultTableModel tableModel = (DefaultTableModel)this.catalogsTable.getModel();
        for (int i = tableModel.getRowCount() - 1; i >= 0; --i) {
            tableModel.removeRow(i);
        }
        XBCRootService rootService = (XBCRootService)this.catalog.getCatalogService(XBCRootService.class);
        XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
        this.catalogRoots = rootService.getAllItems();
        for (XBCRoot catalogRoot : this.catalogRoots) {
            Object[] row;
            String lastUpdateText;
            Optional lastUpdate = catalogRoot.getLastUpdate();
            String string = lastUpdateText = lastUpdate.isPresent() ? ((Date)lastUpdate.get()).toString() : "";
            if (catalogRoot.getUrl().isPresent()) {
                String nodeName = nameService.getDefaultText((XBCItem)catalogRoot.getNode());
                row = new Object[]{"Catalog " + nodeName, catalogRoot.getUrl().orElse(""), lastUpdateText};
            } else {
                row = new Object[]{"Main", "(build-in)", lastUpdateText};
            }
            tableModel.addRow(row);
        }
    }

    public void addRowSelectionListener(ListSelectionListener listener) {
        this.catalogsTable.getSelectionModel().addListSelectionListener(listener);
    }

    @Nullable
    public XBCRoot getSelectedItem() {
        int selectedRow = this.catalogsTable.getSelectedRow();
        return selectedRow < 0 ? null : this.catalogRoots.get(selectedRow);
    }

    public boolean hasSelection() {
        return this.catalogsTable.getSelectedRow() >= 0;
    }

    private void initComponents() {
        this.catalogsScrollPane = new JScrollPane();
        this.catalogsTable = new JTable();
        this.setLayout(new BorderLayout());
        this.catalogsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "URL", "Date"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.catalogsTable.setSelectionMode(0);
        this.catalogsScrollPane.setViewportView(this.catalogsTable);
        this.add((Component)this.catalogsScrollPane, "Center");
    }

    public static void main(String[] args) {
        CatalogsManagerPanel catalogsBrowserPanel = new CatalogsManagerPanel();
        DefaultEditItemActions defaultEditItemActions = new DefaultEditItemActions();
        defaultEditItemActions.setEditItemActionsHandler((EditItemActionsHandler)new EditItemActionsHandlerEmpty());
        catalogsBrowserPanel.addActions((ActionsProvider)defaultEditItemActions);
        WindowUtils.invokeDialog((JComponent)catalogsBrowserPanel);
    }
}

