/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.action;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.CloseControlPanel;
import org.exbin.framework.xbup.catalog.CatalogsManager;
import org.exbin.framework.xbup.catalog.gui.CatalogsManagerPanel;
import org.exbin.xbup.core.catalog.XBACatalog;

@ParametersAreNonnullByDefault
public class CatalogsManagerAction
extends AbstractAction {
    public static final String ACTION_ID = "catalogsManagerAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogsManagerAction.class);
    private XBApplication application;
    private XBACatalog catalog;

    public void setup(XBApplication application) {
        this.application = application;
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CatalogsManager catalogsBrowser = new CatalogsManager();
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        catalogsBrowser.setApplication(this.application);
        catalogsBrowser.setCatalog(this.catalog);
        CatalogsManagerPanel panel = catalogsBrowser.getCatalogsManagerPanel();
        CloseControlPanel controlPanel = new CloseControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)panel, (JPanel)controlPanel);
        WindowUtils.addHeaderPanel((Window)dialog.getWindow(), CatalogsManagerPanel.class, (ResourceBundle)panel.getResourceBundle());
        controlPanel.setHandler(() -> {
            dialog.close();
            dialog.dispose();
        });
        frameModule.setDialogTitle(dialog, panel.getResourceBundle());
        dialog.showCentered((Component)e.getSource());
    }
}

