/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.action.DefaultEditItemActions;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandler;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.xbup.catalog.action.AddCatalogAction;
import org.exbin.framework.xbup.catalog.action.DeleteCatalogAction;
import org.exbin.framework.xbup.catalog.action.EditCatalogAction;
import org.exbin.framework.xbup.catalog.gui.CatalogsManagerPanel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCRoot;

@ParametersAreNonnullByDefault
public class CatalogsManager {
    private final CatalogsManagerPanel catalogsManagerPanel = new CatalogsManagerPanel();
    private final DefaultEditItemActions actions = new DefaultEditItemActions();
    private XBApplication application;
    private XBACatalog catalog;

    public CatalogsManager() {
        this.actions.setEditItemActionsHandler(new EditItemActionsHandler(){

            public void performAddItem() {
                AddCatalogAction action = new AddCatalogAction();
                action.setup(CatalogsManager.this.application);
                action.setCatalog(CatalogsManager.this.catalog);
                action.setParentComponent(CatalogsManager.this.catalogsManagerPanel);
                action.actionPerformed(null);
                Optional<XBCRoot> resultRoot = action.getResultRoot();
                if (resultRoot.isPresent()) {
                    CatalogsManager.this.catalogsManagerPanel.reload();
                }
            }

            public void performEditItem() {
                EditCatalogAction action = new EditCatalogAction();
                action.setup(CatalogsManager.this.application);
                action.setCatalog(CatalogsManager.this.catalog);
                action.setParentComponent(CatalogsManager.this.catalogsManagerPanel);
                action.setActiveItem(CatalogsManager.this.catalogsManagerPanel.getSelectedItem());
                action.actionPerformed(null);
                CatalogsManager.this.catalogsManagerPanel.reload();
            }

            public void performDeleteItem() {
                DeleteCatalogAction action = new DeleteCatalogAction();
                action.setup(CatalogsManager.this.application);
                action.setCatalog(CatalogsManager.this.catalog);
                action.setParentComponent(CatalogsManager.this.catalogsManagerPanel);
                action.setActiveItem(CatalogsManager.this.catalogsManagerPanel.getSelectedItem());
                action.actionPerformed(null);
            }

            public boolean canAddItem() {
                return true;
            }

            public boolean canDeleteItem() {
                return CatalogsManager.this.catalogsManagerPanel.hasSelection();
            }

            public boolean canEditItem() {
                return CatalogsManager.this.catalogsManagerPanel.hasSelection();
            }

            public void setUpdateListener(@Nonnull EditItemActionsUpdateListener updateListener) {
                CatalogsManager.this.catalogsManagerPanel.addRowSelectionListener(arg0 -> updateListener.stateChanged());
            }
        });
        this.init();
    }

    private void init() {
        this.catalogsManagerPanel.addActions((ActionsProvider)this.actions);
    }

    @Nonnull
    public CatalogsManagerPanel getCatalogsManagerPanel() {
        return this.catalogsManagerPanel;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.catalogsManagerPanel.setApplication(application);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.catalogsManagerPanel.setCatalog(catalog);
    }
}

