/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.ByteArrayEditableData;
import org.exbin.auxiliary.binary_data.FinishableStream;
import org.exbin.auxiliary.binary_data.SeekableStream;

@ParametersAreNonnullByDefault
public class ByteArrayDataOutputStream
extends OutputStream
implements SeekableStream,
FinishableStream {
    @Nonnull
    private final ByteArrayEditableData data;
    private long position = 0L;

    public ByteArrayDataOutputStream(ByteArrayEditableData data) {
        this.data = data;
    }

    @Override
    public void write(int value) throws IOException {
        long dataSize = this.data.getDataSize();
        if (this.position == dataSize) {
            this.data.setDataSize(++dataSize);
        }
        this.data.setByte(this.position++, (byte)value);
    }

    @Override
    public void write(byte[] input, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        long dataSize = this.data.getDataSize();
        if (this.position + (long)len > dataSize) {
            this.data.setDataSize(this.position + (long)len);
        }
        byte[] byteArray = this.data.getData();
        System.arraycopy(input, off, byteArray, (int)this.position, len);
        this.position += (long)len;
    }

    @Override
    public void seek(long position) throws IOException {
        this.position = position;
    }

    @Override
    public long getStreamSize() {
        return this.data.getDataSize();
    }

    @Override
    public long getProcessedSize() {
        return this.position;
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    @Override
    public long finish() throws IOException {
        this.position = this.data.getDataSize();
        return this.position;
    }
}

