/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.inspector;

import java.awt.Color;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaSection;
import org.exbin.framework.bined.BinEdCodeAreaPainter;
import org.exbin.framework.utils.UiUtils;

@ParametersAreNonnullByDefault
public class BasicValuesPositionColorModifier
implements BinEdCodeAreaPainter.PositionColorModifier {
    private long position = -1L;
    private long length;
    private Color color;

    public BasicValuesPositionColorModifier() {
        this.resetColors();
    }

    @Nullable
    public Color getPositionBackgroundColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean unprintables) {
        long dataPosition;
        if (this.position >= 0L && (dataPosition = rowDataPosition + (long)byteOnRow) >= this.position && dataPosition < this.position + this.length) {
            return this.color;
        }
        return null;
    }

    @Nullable
    public Color getPositionTextColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean unprintables) {
        return null;
    }

    public void resetColors() {
        this.color = UiUtils.isDarkUI() ? Color.YELLOW.darker().darker() : Color.YELLOW;
    }

    public void setRange(long position, long length) {
        this.position = position;
        this.length = length;
    }

    public void clearRange() {
        this.position = -1L;
        this.length = 0L;
    }
}

