/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.gui;

import java.net.URI;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.sound.sampled.AudioFormat;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.editor.wave.AudioEditor;
import org.exbin.framework.editor.wave.gui.AudioPanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class PropertiesPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(PropertiesPanel.class);
    private JLabel channelsLabel;
    private JTextField channelsTextField;
    private JPanel documentPanel;
    private JLabel encodingLabel;
    private JTextField encodingTextField;
    private JLabel fileNameLabel;
    private JTextField fileNameTextField;
    private JLabel sampleRateLabel;
    private JTextField sampleRateTextField;
    private JLabel waveLengthLabel;
    private JTextField waveLengthTextField;

    public PropertiesPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.fileNameTextField = new JTextField();
        this.documentPanel = new JPanel();
        this.waveLengthLabel = new JLabel();
        this.waveLengthTextField = new JTextField();
        this.sampleRateLabel = new JLabel();
        this.sampleRateTextField = new JTextField();
        this.channelsLabel = new JLabel();
        this.channelsTextField = new JTextField();
        this.encodingLabel = new JLabel();
        this.encodingTextField = new JTextField();
        this.fileNameLabel = new JLabel();
        this.fileNameTextField.setEditable(false);
        this.documentPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("documentPanel.border.title")));
        this.waveLengthLabel.setText(this.resourceBundle.getString("waveLengthLabel.text"));
        this.waveLengthTextField.setEditable(false);
        this.sampleRateLabel.setText(this.resourceBundle.getString("sampleRateLabel.text"));
        this.sampleRateTextField.setEditable(false);
        this.channelsLabel.setText(this.resourceBundle.getString("channelsLabel.text"));
        this.channelsTextField.setEditable(false);
        this.encodingLabel.setText(this.resourceBundle.getString("encodingLabel.text"));
        this.encodingTextField.setEditable(false);
        GroupLayout documentPanelLayout = new GroupLayout(this.documentPanel);
        this.documentPanel.setLayout(documentPanelLayout);
        documentPanelLayout.setHorizontalGroup(documentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(documentPanelLayout.createSequentialGroup().addContainerGap().addGroup(documentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.waveLengthLabel).addComponent(this.sampleRateLabel).addComponent(this.channelsLabel).addComponent(this.encodingLabel).addComponent(this.sampleRateTextField, -1, 449, Short.MAX_VALUE).addComponent(this.channelsTextField, -1, 449, Short.MAX_VALUE).addComponent(this.encodingTextField, GroupLayout.Alignment.TRAILING, -1, 449, Short.MAX_VALUE).addComponent(this.waveLengthTextField, -1, 449, Short.MAX_VALUE)).addContainerGap()));
        documentPanelLayout.setVerticalGroup(documentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(documentPanelLayout.createSequentialGroup().addComponent(this.waveLengthLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.waveLengthTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sampleRateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sampleRateTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.channelsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.channelsTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.encodingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.encodingTextField, -2, -1, -2).addContainerGap(14, Short.MAX_VALUE)));
        this.fileNameLabel.setText(this.resourceBundle.getString("fileNameLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fileNameLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.fileNameTextField).addComponent(this.documentPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.fileNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileNameTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.documentPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setDocument(AudioEditor audioEditor) {
        Optional<FileHandler> activeFile = audioEditor.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        FileHandler fileHandler = activeFile.get();
        AudioPanel audioPanel = (AudioPanel)fileHandler.getComponent();
        if (!audioPanel.isEmpty()) {
            Optional fileUri = fileHandler.getFileUri();
            this.fileNameTextField.setText(fileUri.isPresent() ? ((URI)fileUri.get()).toString() : "");
            this.waveLengthTextField.setText(audioPanel.getWaveLength());
            AudioFormat waveFormat = audioPanel.getWaveFormat();
            this.sampleRateTextField.setText(String.valueOf((long)waveFormat.getSampleRate()));
            this.channelsTextField.setText(String.valueOf(waveFormat.getChannels()));
            this.encodingTextField.setText(String.valueOf(waveFormat.getEncoding().toString()));
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new PropertiesPanel());
    }
}

