/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuGroup;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.NextToMode;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.action.api.SeparationMode;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.api.XBApplicationModule;
import org.exbin.framework.api.XBModuleRepositoryUtils;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.wave.AudioControlApi;
import org.exbin.framework.editor.wave.AudioEditor;
import org.exbin.framework.editor.wave.AudioFileType;
import org.exbin.framework.editor.wave.action.AudioControlActions;
import org.exbin.framework.editor.wave.action.AudioOperationActions;
import org.exbin.framework.editor.wave.action.DrawingControlActions;
import org.exbin.framework.editor.wave.action.EditToolActions;
import org.exbin.framework.editor.wave.action.PropertiesAction;
import org.exbin.framework.editor.wave.action.WaveColorAction;
import org.exbin.framework.editor.wave.action.ZoomControlActions;
import org.exbin.framework.editor.wave.gui.AudioPanel;
import org.exbin.framework.editor.wave.gui.AudioStatusPanel;
import org.exbin.framework.editor.wave.options.gui.AudioDevicesOptionsPanel;
import org.exbin.framework.editor.wave.options.gui.WaveColorOptionsPanel;
import org.exbin.framework.editor.wave.options.impl.AudioDevicesOptionsImpl;
import org.exbin.framework.editor.wave.options.impl.WaveColorOptionsImpl;
import org.exbin.framework.editor.wave.preferences.AudioDevicesPreferences;
import org.exbin.framework.editor.wave.preferences.WaveColorPreferences;
import org.exbin.framework.editor.wave.service.impl.WaveColorServiceImpl;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.operation.undo.api.OperationUndoModuleApi;
import org.exbin.framework.options.api.DefaultOptionsPage;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModuleApi;
import org.exbin.framework.options.api.OptionsPage;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.plugin.XBModuleHandler;

@ParametersAreNonnullByDefault
public class EditorWaveModule
implements XBApplicationModule {
    public static final String MODULE_ID = XBModuleRepositoryUtils.getModuleIdByApi(EditorWaveModule.class);
    public static final String AUDIO_MENU_ID = MODULE_ID + ".audioMenu";
    public static final String AUDIO_OPERATION_MENU_ID = MODULE_ID + ".audioOperationMenu";
    public static final String AUDIO_POPUP_MENU_ID = MODULE_ID + ".audioPopupMenu";
    public static final String DRAW_MODE_SUBMENU_ID = MODULE_ID + ".drawSubMenu";
    public static final String ZOOM_MODE_SUBMENU_ID = MODULE_ID + ".zoomSubMenu";
    public static final String TOOLS_SELECTION_MENU_GROUP_ID = MODULE_ID + ".toolsSelectionMenuGroup";
    public static final String XBS_FILE_TYPE = "XBWaveEditor.XBSFileFilter";
    public static final String WAVE_STATUS_BAR_ID = "waveStatusBar";
    private XBApplication application;
    private EditorProvider editorProvider;
    private ResourceBundle resourceBundle;
    private AudioStatusPanel audioStatusPanel;
    private boolean playing = false;
    private WaveColorAction waveColorAction;
    private PropertiesAction propertiesAction;
    private AudioControlActions audioControlActions;
    private DrawingControlActions drawingControlActions;
    private EditToolActions editToolActions;
    private ZoomControlActions zoomControlActions;
    private AudioOperationActions audioOperationActions;

    public void init(XBModuleHandler application) {
        this.application = (XBApplication)application;
    }

    public void unregisterModule(String moduleId) {
    }

    private void ensureSetup() {
        if (this.editorProvider == null) {
            this.getEditorProvider();
        }
        if (this.resourceBundle == null) {
            this.getResourceBundle();
        }
    }

    @Nonnull
    public EditorProvider getEditorProvider() {
        if (this.editorProvider == null) {
            AudioEditor audioEditor = new AudioEditor(this.application);
            OperationUndoModuleApi undoModule = (OperationUndoModuleApi)this.application.getModuleRepository().getModuleByInterface(OperationUndoModuleApi.class);
            audioEditor.setUndoHandler(undoModule.getUndoHandler());
            this.editorProvider = audioEditor;
            audioEditor.setStatusChangeListener(this::updateStatus);
            audioEditor.setWaveRepaintListener(this::updatePositionTime);
            audioEditor.setMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (EditorWaveModule.this.editorProvider == null) {
                        return;
                    }
                    EditorWaveModule.this.updatePositionTime();
                }
            });
            audioEditor.setPopupMenu(this.createPopupMenu());
        }
        return this.editorProvider;
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = LanguageUtils.getResourceBundleByClass(EditorWaveModule.class);
        }
        return this.resourceBundle;
    }

    public void registerFileTypes() {
        String[] formats;
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        for (String ext : formats = new String[]{"wav", "aiff", "au"}) {
            if (!ext.toLowerCase().equals(ext)) continue;
            fileModule.addFileType((FileType)new AudioFileType(ext));
        }
        fileModule.addFileType((FileType)new XBSFileType());
    }

    private void updatePositionTime() {
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            return;
        }
        AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
        this.audioStatusPanel.setCurrentTime(audioPanel.getPositionTime());
    }

    private void updateStatus() {
        this.updatePositionTime();
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            return;
        }
        AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
        if (audioPanel.getIsPlaying() != this.playing) {
            this.playing = !this.playing;
            this.audioStatusPanel.setPlayButtonIcon(this.playing ? new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/wave/resources/images/actions/pause16.png")) : new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/wave/resources/images/actions/play16.png")));
        }
    }

    public void registerStatusBar() {
        this.audioStatusPanel = new AudioStatusPanel(new AudioControlApi(){

            @Override
            public void performPlay() {
                Optional activeFile = EditorWaveModule.this.editorProvider.getActiveFile();
                if (!activeFile.isPresent()) {
                    throw new IllegalStateException();
                }
                AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
                audioPanel.performPlay();
            }

            @Override
            public void performStop() {
                Optional activeFile = EditorWaveModule.this.editorProvider.getActiveFile();
                if (!activeFile.isPresent()) {
                    throw new IllegalStateException();
                }
                AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
                audioPanel.performStop();
            }

            @Override
            public void setVolume(int volumeLevel) {
                Optional activeFile = EditorWaveModule.this.editorProvider.getActiveFile();
                if (!activeFile.isPresent()) {
                    throw new IllegalStateException();
                }
                AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
                audioPanel.setVolume(volumeLevel);
            }
        });
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        frameModule.registerStatusBar(MODULE_ID, WAVE_STATUS_BAR_ID, (JPanel)this.audioStatusPanel);
        frameModule.switchStatusBar(WAVE_STATUS_BAR_ID);
    }

    public void registerOptionsPanels() {
        OptionsModuleApi optionsModule = (OptionsModuleApi)this.application.getModuleRepository().getModuleByInterface(OptionsModuleApi.class);
        final WaveColorServiceImpl waveColorService = new WaveColorServiceImpl(this.getEditorProvider());
        optionsModule.addOptionsPage((OptionsPage)new DefaultOptionsPage<WaveColorOptionsImpl>(){

            public OptionsComponent<WaveColorOptionsImpl> createPanel() {
                WaveColorOptionsPanel panel = new WaveColorOptionsPanel();
                panel.setWaveColorService(waveColorService);
                return panel;
            }

            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(WaveColorOptionsPanel.class);
            }

            public WaveColorOptionsImpl createOptions() {
                return new WaveColorOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, WaveColorOptionsImpl options) {
                options.loadFromPreferences(new WaveColorPreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, WaveColorOptionsImpl options) {
                options.saveToPreferences(new WaveColorPreferences(preferences));
            }

            public void applyPreferencesChanges(WaveColorOptionsImpl options) {
                if (options.isUseDefaultColors()) {
                    waveColorService.setCurrentWaveColors(waveColorService.getCurrentWaveColors());
                } else {
                    Color[] colors = new Color[]{this.intToColor(options.getWaveColor()), this.intToColor(options.getWaveFillColor()), this.intToColor(options.getWaveCursorColor()), this.intToColor(options.getWaveCursorWaveColor()), this.intToColor(options.getWaveBackgroundColor()), this.intToColor(options.getWaveSelectionColor())};
                    waveColorService.setCurrentWaveColors(colors);
                }
            }

            @Nullable
            private Color intToColor(@Nullable Integer intValue) {
                return intValue == null ? null : new Color(intValue);
            }
        });
        optionsModule.addOptionsPage((OptionsPage)new DefaultOptionsPage<AudioDevicesOptionsImpl>(){

            public OptionsComponent<AudioDevicesOptionsImpl> createPanel() {
                return new AudioDevicesOptionsPanel();
            }

            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(AudioDevicesOptionsPanel.class);
            }

            public AudioDevicesOptionsImpl createOptions() {
                return new AudioDevicesOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, AudioDevicesOptionsImpl options) {
                options.loadFromPreferences(new AudioDevicesPreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, AudioDevicesOptionsImpl options) {
                options.saveToPreferences(new AudioDevicesPreferences(preferences));
            }

            public void applyPreferencesChanges(AudioDevicesOptionsImpl options) {
            }
        });
    }

    public void registerToolsOptionsMenuActions() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.TOOLS_MENU_ID, MODULE_ID, (Action)this.getWaveColorAction(), new MenuPosition(PositionMode.MIDDLE));
    }

    public void registerToolsMenuActions() {
        EditToolActions actions = this.getEditToolActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuGroup(FrameModuleApi.TOOLS_MENU_ID, new MenuGroup(TOOLS_SELECTION_MENU_GROUP_ID, new MenuPosition(PositionMode.TOP), SeparationMode.AROUND));
        actionModule.registerMenuItem(FrameModuleApi.TOOLS_MENU_ID, MODULE_ID, actions.getSelectionToolAction(), new MenuPosition(TOOLS_SELECTION_MENU_GROUP_ID));
        actionModule.registerMenuItem(FrameModuleApi.TOOLS_MENU_ID, MODULE_ID, actions.getPencilToolAction(), new MenuPosition(TOOLS_SELECTION_MENU_GROUP_ID));
    }

    public AudioStatusPanel getAudioStatusPanel() {
        return this.audioStatusPanel;
    }

    private PropertiesAction getPropertiesAction() {
        if (this.propertiesAction == null) {
            this.ensureSetup();
            this.propertiesAction = new PropertiesAction();
            this.propertiesAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.propertiesAction;
    }

    private AudioControlActions getAudioControlActions() {
        if (this.audioControlActions == null) {
            this.ensureSetup();
            this.audioControlActions = new AudioControlActions();
            this.audioControlActions.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.audioControlActions;
    }

    private AudioOperationActions getAudioOperationActions() {
        if (this.audioOperationActions == null) {
            this.ensureSetup();
            this.audioOperationActions = new AudioOperationActions();
            this.audioOperationActions.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.audioOperationActions;
    }

    private DrawingControlActions getDrawingControlActions() {
        if (this.drawingControlActions == null) {
            this.ensureSetup();
            this.drawingControlActions = new DrawingControlActions();
            this.drawingControlActions.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.drawingControlActions;
    }

    private EditToolActions getEditToolActions() {
        if (this.editToolActions == null) {
            this.ensureSetup();
            this.editToolActions = new EditToolActions();
            this.editToolActions.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.editToolActions;
    }

    private ZoomControlActions getZoomControlActions() {
        if (this.zoomControlActions == null) {
            this.ensureSetup();
            this.zoomControlActions = new ZoomControlActions();
            this.zoomControlActions.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.zoomControlActions;
    }

    private WaveColorAction getWaveColorAction() {
        if (this.waveColorAction == null) {
            this.ensureSetup();
            this.waveColorAction = new WaveColorAction();
            this.waveColorAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.waveColorAction;
    }

    public void registerPropertiesMenu() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, (Action)this.getPropertiesAction(), new MenuPosition(PositionMode.BOTTOM));
    }

    public void registerAudioMenu() {
        this.getAudioControlActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenu(AUDIO_MENU_ID, MODULE_ID);
        actionModule.registerMenuItem(FrameModuleApi.MAIN_MENU_ID, MODULE_ID, AUDIO_MENU_ID, "Audio", new MenuPosition(NextToMode.AFTER, "View"));
        actionModule.registerMenuItem(AUDIO_MENU_ID, MODULE_ID, this.audioControlActions.getPlayAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(AUDIO_MENU_ID, MODULE_ID, this.audioControlActions.getStopAction(), new MenuPosition(PositionMode.TOP));
    }

    public void registerAudioOperationMenu() {
        this.getAudioOperationActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenu(AUDIO_OPERATION_MENU_ID, MODULE_ID);
        actionModule.registerMenuItem(AUDIO_MENU_ID, MODULE_ID, AUDIO_OPERATION_MENU_ID, "Operation", new MenuPosition(PositionMode.BOTTOM));
        actionModule.registerMenuItem(AUDIO_OPERATION_MENU_ID, MODULE_ID, this.audioOperationActions.getRevertAction(), new MenuPosition(PositionMode.TOP));
    }

    public void registerDrawingModeMenu() {
        this.getDrawingControlActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, DRAW_MODE_SUBMENU_ID, "Draw Mode", new MenuPosition(PositionMode.BOTTOM));
    }

    public void registerZoomModeMenu() {
        this.getZoomControlActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, ZOOM_MODE_SUBMENU_ID, "Zoom", new MenuPosition(PositionMode.BOTTOM));
        actionModule.registerMenu(ZOOM_MODE_SUBMENU_ID, MODULE_ID);
        actionModule.registerMenuItem(ZOOM_MODE_SUBMENU_ID, MODULE_ID, this.zoomControlActions.getZoomUpAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(ZOOM_MODE_SUBMENU_ID, MODULE_ID, this.zoomControlActions.getNormalZoomAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(ZOOM_MODE_SUBMENU_ID, MODULE_ID, this.zoomControlActions.getZoomDownAction(), new MenuPosition(PositionMode.TOP));
    }

    public void bindZoomScrollWheel() {
    }

    private JPopupMenu createPopupMenu() {
        this.getAudioControlActions();
        this.getDrawingControlActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenu(AUDIO_POPUP_MENU_ID, MODULE_ID);
        actionModule.registerMenuItem(AUDIO_POPUP_MENU_ID, MODULE_ID, this.audioControlActions.getPlayAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(AUDIO_POPUP_MENU_ID, MODULE_ID, this.audioControlActions.getStopAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerClipboardMenuItems(AUDIO_POPUP_MENU_ID, MODULE_ID, SeparationMode.AROUND);
        actionModule.registerMenu(DRAW_MODE_SUBMENU_ID, MODULE_ID);
        actionModule.registerMenuItem(DRAW_MODE_SUBMENU_ID, MODULE_ID, this.drawingControlActions.getDotsModeAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(DRAW_MODE_SUBMENU_ID, MODULE_ID, this.drawingControlActions.getLineModeAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(DRAW_MODE_SUBMENU_ID, MODULE_ID, this.drawingControlActions.getIntegralModeAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(AUDIO_POPUP_MENU_ID, MODULE_ID, DRAW_MODE_SUBMENU_ID, "Draw Mode", new MenuPosition(PositionMode.BOTTOM));
        JPopupMenu popupMenu = new JPopupMenu();
        actionModule.buildMenu(popupMenu, AUDIO_POPUP_MENU_ID);
        return popupMenu;
    }

    @Nullable
    public static String getExtension(File file) {
        String ext = null;
        String str = file.getName();
        int i = str.lastIndexOf(46);
        if (i > 0 && i < str.length() - 1) {
            ext = str.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public class XBSFileType
    extends FileFilter
    implements FileType {
        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = EditorWaveModule.getExtension(f);
            if (extension != null) {
                if (extension.length() < 3) {
                    return false;
                }
                return "xbs".contains(extension.substring(0, 3));
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "XBUP Sound Files (*.xbs*)";
        }

        public String getFileTypeId() {
            return EditorWaveModule.XBS_FILE_TYPE;
        }
    }
}

