/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave;

import java.io.IOException;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioTest {
    public static final int END_OF_TRACK = 47;

    public static void main(String[] args) throws Exception {
        AudioTest.streamSampledAudio(new URL("file:///home/hajdam/test.aiff"));
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamSampledAudio(URL url) throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        AudioInputStream ain = null;
        Line line = null;
        try {
            int bytesread;
            ain = AudioSystem.getAudioInputStream(url);
            AudioFormat format = ain.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            if (!AudioSystem.isLineSupported(info)) {
                AudioFormat pcm = new AudioFormat(format.getSampleRate(), 16, format.getChannels(), true, false);
                ain = AudioSystem.getAudioInputStream(pcm, ain);
                format = ain.getFormat();
                info = new DataLine.Info(SourceDataLine.class, format);
            }
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format);
            int framesize = format.getFrameSize();
            byte[] buffer = new byte[4096 * framesize];
            int numbytes = 0;
            boolean started = false;
            while ((bytesread = ain.read(buffer, numbytes, buffer.length - numbytes)) != -1) {
                numbytes += bytesread;
                if (!started) {
                    line.start();
                    started = true;
                }
                int bytestowrite = numbytes / framesize * framesize;
                line.write(buffer, 0, bytestowrite);
                int remaining = numbytes - bytestowrite;
                if (remaining > 0) {
                    System.arraycopy(buffer, bytestowrite, buffer, 0, remaining);
                }
                numbytes = remaining;
            }
            line.drain();
        }
        finally {
            if (line != null) {
                line.close();
            }
            if (ain != null) {
                ain.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamMidiSequence(URL url) throws IOException, InvalidMidiDataException, MidiUnavailableException {
        Sequencer sequencer = null;
        Synthesizer synthesizer = null;
        try {
            sequencer = MidiSystem.getSequencer();
            sequencer.open();
            synthesizer = MidiSystem.getSynthesizer();
            synthesizer.open();
            sequencer.getTransmitter().setReceiver(synthesizer.getReceiver());
            sequencer.setSequence(url.openStream());
            final Object lock = new Object();
            sequencer.addMetaEventListener(new MetaEventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void meta(MetaMessage e) {
                    if (e.getType() == 47) {
                        Object object = lock;
                        synchronized (object) {
                            lock.notify();
                        }
                    }
                }
            });
            sequencer.start();
            Object object = lock;
            synchronized (object) {
                while (sequencer.isRunning()) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        finally {
            if (sequencer != null) {
                sequencer.close();
            }
            if (synthesizer != null) {
                synthesizer.close();
            }
        }
    }
}

