/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data.delta;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.delta.DataSegment;
import org.exbin.auxiliary.binary_data.delta.MemoryDataSource;

@ParametersAreNonnullByDefault
public class MemorySegment
extends DataSegment {
    @Nonnull
    private MemoryDataSource source;
    private long startPosition;
    private long length;

    public MemorySegment(MemoryDataSource source, long startPosition, long length) {
        this.source = source;
        this.startPosition = startPosition;
        this.length = length;
    }

    @Nonnull
    public MemoryDataSource getSource() {
        return this.source;
    }

    public void setSource(MemoryDataSource source) {
        this.source = source;
    }

    @Override
    public long getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(long startPosition) {
        this.startPosition = startPosition;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public byte getByte(long position) {
        return this.source.getByte(position);
    }

    @Override
    @Nonnull
    public DataSegment copy() {
        return new MemorySegment(null, this.startPosition, this.length);
    }
}

