/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data.delta;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.FinishableStream;
import org.exbin.auxiliary.binary_data.SeekableStream;
import org.exbin.auxiliary.binary_data.delta.DeltaDocument;
import org.exbin.auxiliary.binary_data.delta.DeltaDocumentWindow;

@ParametersAreNonnullByDefault
public class DeltaDocumentOutputStream
extends OutputStream
implements SeekableStream,
FinishableStream {
    @Nonnull
    private final DeltaDocumentWindow data;
    private long position = 0L;

    public DeltaDocumentOutputStream(DeltaDocument document) {
        this.data = new DeltaDocumentWindow(document);
    }

    @Override
    public void write(int value) throws IOException {
        long dataSize = this.data.getDataSize();
        if (this.position == dataSize) {
            this.data.setDataSize(++dataSize);
        }
        this.data.setByte(this.position++, (byte)value);
    }

    @Override
    public void write(byte[] input, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        this.data.insert(this.position, input, offset, length);
        this.position += (long)length;
    }

    public void seek(long position) throws IOException {
        this.position = position;
    }

    public long getStreamSize() {
        return this.data.getDataSize();
    }

    public long getProcessedSize() {
        return this.position;
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    public long finish() throws IOException {
        this.position = this.data.getDataSize();
        return this.position;
    }
}

