/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data.delta;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.auxiliary.binary_data.delta.DataSegment;
import org.exbin.auxiliary.binary_data.delta.DeltaDocumentChangedListener;
import org.exbin.auxiliary.binary_data.delta.DeltaDocumentInputStream;
import org.exbin.auxiliary.binary_data.delta.DeltaDocumentOutputStream;
import org.exbin.auxiliary.binary_data.delta.DeltaDocumentWindow;
import org.exbin.auxiliary.binary_data.delta.FileDataSource;
import org.exbin.auxiliary.binary_data.delta.FileSegment;
import org.exbin.auxiliary.binary_data.delta.SegmentsRepository;
import org.exbin.auxiliary.binary_data.delta.list.DefaultDoublyLinkedList;

@ParametersAreNonnullByDefault
public class DeltaDocument
implements EditableBinaryData {
    private final SegmentsRepository repository;
    private FileDataSource fileSource;
    private final DefaultDoublyLinkedList<DataSegment> segments = new DefaultDoublyLinkedList();
    private long dataLength = 0L;
    private final DeltaDocumentWindow pointerWindow;
    private final List<DeltaDocumentChangedListener> changeListeners = new ArrayList<DeltaDocumentChangedListener>();
    private static final int BUFFER_SIZE = 4096;

    public DeltaDocument(SegmentsRepository repository, FileDataSource fileSource) throws IOException {
        this.repository = repository;
        this.fileSource = fileSource;
        this.dataLength = fileSource.getFileLength();
        if (this.dataLength > 0L) {
            FileSegment fullFileSegment = repository.createFileSegment(fileSource, 0L, this.dataLength);
            this.segments.add(fullFileSegment);
        }
        this.pointerWindow = new DeltaDocumentWindow(this);
        this.pointerWindow.reset();
    }

    public DeltaDocument(SegmentsRepository repository) {
        this.repository = repository;
        this.dataLength = 0L;
        this.pointerWindow = new DeltaDocumentWindow(this);
        this.pointerWindow.reset();
    }

    @Nonnull
    public DefaultDoublyLinkedList<DataSegment> getSegments() {
        return this.segments;
    }

    @Nullable
    public DataSegment getSegment(long position) {
        return this.pointerWindow.getSegment(position);
    }

    public boolean isEmpty() {
        return this.dataLength == 0L;
    }

    public long getDataSize() {
        return this.dataLength;
    }

    public byte getByte(long position) {
        return this.pointerWindow.getByte(position);
    }

    public void setByte(long position, byte value) {
        this.pointerWindow.setByte(position, value);
    }

    public void insertUninitialized(long startFrom, long length) {
        this.pointerWindow.insertUninitialized(startFrom, length);
    }

    public void insert(long startFrom, long length) {
        this.pointerWindow.insert(startFrom, length);
    }

    public void insert(long startFrom, byte[] insertedData) {
        this.pointerWindow.insert(startFrom, insertedData);
    }

    public void insert(long startFrom, byte[] insertedData, int insertedDataOffset, int insertedDataLength) {
        this.pointerWindow.insert(startFrom, insertedData, insertedDataOffset, insertedDataLength);
    }

    public void insert(long startFrom, BinaryData insertedData) {
        this.pointerWindow.insert(startFrom, insertedData);
    }

    public void insert(long startFrom, BinaryData insertedData, long insertedDataOffset, long insertedDataLength) {
        this.pointerWindow.insert(startFrom, insertedData, insertedDataOffset, insertedDataLength);
    }

    public void insertSegment(long startFrom, DataSegment segment) {
        this.pointerWindow.insertSegment(startFrom, segment);
    }

    public long insert(long startFrom, InputStream inputStream, long maxDataLength) throws IOException {
        long processed = 0L;
        byte[] buffer = new byte[4096];
        if (maxDataLength > 0L) {
            int toRead;
            int read;
            while ((read = inputStream.read(buffer, 0, toRead = maxDataLength > 4096L ? 4096 : (int)maxDataLength)) != -1) {
                this.pointerWindow.insert(startFrom, buffer, 0, read);
                startFrom += (long)read;
                processed += (long)read;
                if ((maxDataLength -= (long)read) > 0L && read > 0) continue;
            }
        }
        return processed;
    }

    public void replace(long targetPosition, BinaryData replacingData) {
        this.remove(targetPosition, replacingData.getDataSize());
        this.insert(targetPosition, replacingData);
    }

    public void replace(long targetPosition, BinaryData replacingData, long startFrom, long length) {
        this.remove(targetPosition, length);
        this.insert(targetPosition, replacingData, startFrom, length);
    }

    public void replace(long targetPosition, byte[] replacingData) {
        this.remove(targetPosition, replacingData.length);
        this.insert(targetPosition, replacingData);
    }

    public void replace(long targetPosition, byte[] replacingData, int replacingDataOffset, int length) {
        this.remove(targetPosition, length);
        this.insert(targetPosition, replacingData, replacingDataOffset, length);
    }

    public void replaceSegment(long targetPosition, DataSegment segment) {
        this.remove(targetPosition, segment.getLength());
        this.insertSegment(targetPosition, segment);
    }

    public void fillData(long startFrom, long length) {
        this.fillData(startFrom, length, (byte)0);
    }

    public void fillData(long startFrom, long length, byte fill) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void remove(long startFrom, long length) {
        this.pointerWindow.remove(startFrom, length);
    }

    public void clear() {
        this.dataLength = 0L;
        this.segments.clear();
        this.pointerWindow.reset();
    }

    public void dispose() {
        this.repository.dropDocument(this);
    }

    public void loadFromStream(InputStream stream) throws IOException {
        int red;
        this.clear();
        DeltaDocumentWindow documentWindow = new DeltaDocumentWindow(this);
        byte[] buffer = new byte[4096];
        long position = 0L;
        do {
            if ((red = stream.read(buffer)) <= 0) continue;
            documentWindow.insert(position, buffer, 0, red);
            position += (long)red;
        } while (red >= 0);
    }

    public void saveToStream(OutputStream stream) throws IOException {
        int toProcess;
        DeltaDocumentWindow documentWindow = new DeltaDocumentWindow(this);
        byte[] buffer = new byte[4096];
        long dataSize = this.getDataSize();
        for (long position = 0L; position < dataSize; position += (long)toProcess) {
            long remains = dataSize - position;
            toProcess = remains < 4096L ? (int)remains : 4096;
            documentWindow.copyToArray(position, buffer, 0, toProcess);
            stream.write(buffer, 0, toProcess);
        }
    }

    @Nonnull
    public BinaryData copy() {
        return this.pointerWindow.copy();
    }

    @Nonnull
    public BinaryData copy(long startFrom, long length) {
        return this.pointerWindow.copy(startFrom, length);
    }

    public void copyToArray(long startFrom, byte[] target, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            target[offset + i] = this.getByte(startFrom + (long)i);
        }
    }

    @Nonnull
    public OutputStream getDataOutputStream() {
        return new DeltaDocumentOutputStream(this);
    }

    @Nonnull
    public InputStream getDataInputStream() {
        return new DeltaDocumentInputStream(this);
    }

    public void setDataSize(long dataSize) {
        if (dataSize < this.dataLength) {
            this.remove(dataSize, this.dataLength - dataSize);
        } else if (dataSize > this.dataLength) {
            this.insert(this.dataLength, dataSize - this.dataLength);
        }
    }

    public void save() throws IOException {
        this.repository.saveDocument(this);
    }

    public void clearCache() {
        this.pointerWindow.reset();
    }

    void setDataLength(long dataSize) {
        this.dataLength = dataSize;
    }

    @Nullable
    public DataSegment getPartCopy(long position, long length) {
        return this.pointerWindow.getPartCopy(position, length);
    }

    @Nullable
    public FileDataSource getFileSource() {
        return this.fileSource;
    }

    public void setFileSource(FileDataSource fileSource) {
        this.fileSource = fileSource;
    }

    @Nonnull
    public SegmentsRepository getRepository() {
        return this.repository;
    }

    public void addChangeListener(DeltaDocumentChangedListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(DeltaDocumentChangedListener listener) {
        this.changeListeners.remove(listener);
    }

    public void notifyChangeListeners(DeltaDocumentWindow window) {
        for (DeltaDocumentChangedListener listener : this.changeListeners) {
            listener.dataChanged(window);
        }
    }

    public void validatePointerPosition() {
        this.pointerWindow.validatePointerPosition();
    }

    public void validateDocumentSize() {
        long segmentsSizeSum = 0L;
        for (DataSegment segment = (DataSegment)this.segments.first(); segment != null; segment = segment.getNext()) {
            segmentsSizeSum += segment.getLength();
        }
        if (segmentsSizeSum != this.getDataSize()) {
            throw new IllegalStateException("Invalid size " + this.getDataSize() + " (expected " + segmentsSizeSum + ")");
        }
    }

    public void validate() {
        this.validatePointerPosition();
        this.validateDocumentSize();
    }
}

