/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_tree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.tree.TreeNode;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBDBlockType;
import org.exbin.xbup.core.block.XBFBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableBlock;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.XBContext;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBTProvider;
import org.exbin.xbup.core.parser.basic.wrapper.FixedDataInputStreamWrapper;
import org.exbin.xbup.core.parser.basic.wrapper.TerminatedDataInputStreamWrapper;
import org.exbin.xbup.core.parser.basic.wrapper.TerminatedDataOutputStreamWrapper;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.convert.XBTokenBuffer;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBTProviderToPullProvider;
import org.exbin.xbup.core.stream.FinishableStream;
import org.exbin.xbup.core.type.XBData;
import org.exbin.xbup.core.ubnumber.UBNatural;
import org.exbin.xbup.core.ubnumber.UBStreamable;
import org.exbin.xbup.core.ubnumber.type.UBENat32;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.core.util.StreamUtils;
import org.exbin.xbup.parser_tree.XBTTreeWriter;
import org.exbin.xbup.parser_tree.XBTreeNode;

public class XBTTreeNode
implements TreeNode,
XBTEditableBlock,
UBStreamable {
    private XBTTreeNode parent;
    private XBBlockTerminationMode terminationMode = XBBlockTerminationMode.SIZE_SPECIFIED;
    private XBBlockDataMode dataMode = XBBlockDataMode.NODE_BLOCK;
    private XBFixedBlockType blockType;
    private final List<XBAttribute> attributes;
    private final List<XBTBlock> children;
    private EditableBinaryData data;
    private XBContext context;
    private XBBlockDecl blockDecl;
    private boolean singleAttributeType = true;

    public XBTTreeNode() {
        this(null);
    }

    public XBTTreeNode(XBTTreeNode parent) {
        this.parent = parent;
        this.children = new ArrayList<XBTBlock>();
        this.blockType = new XBFixedBlockType();
        this.attributes = new ArrayList<XBAttribute>();
        this.data = null;
        this.context = null;
        this.blockDecl = null;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    public int getSubNodesCount() {
        int result = this.children.size();
        if (result > 0) {
            Iterator<XBTBlock> it = this.children.iterator();
            while (it.hasNext()) {
                result += ((XBTTreeNode)it.next()).getSubNodesCount();
            }
        }
        return result;
    }

    public int getBlockIndex() {
        if (this.parent != null) {
            int result = this.parent.getBlockIndex() + 1;
            Iterator<XBTBlock> it = this.parent.children.iterator();
            XBTTreeNode node = (XBTTreeNode)it.next();
            while (node != this) {
                result += node.getSubNodesCount() + 1;
                if (!it.hasNext()) {
                    return -1;
                }
                node = (XBTTreeNode)it.next();
            }
            return result;
        }
        return 0;
    }

    public int getNodeIndexAfter() {
        if (this.dataMode == XBBlockDataMode.NODE_BLOCK) {
            return this.getBlockIndex() + this.getSubNodesCount() + 1;
        }
        return this.getBlockIndex() + 1;
    }

    @Nonnull
    public Optional<XBTTreeNode> findNodeByIndex(long index) {
        if (index == 0L) {
            return Optional.of(this);
        }
        --index;
        if (this.getChildrenCount() > 0) {
            ArrayList<Iterator<XBTBlock>> iterators = new ArrayList<Iterator<XBTBlock>>();
            iterators.add(this.children.iterator());
            int level = 0;
            XBTTreeNode node = (XBTTreeNode)((Iterator)iterators.get(level)).next();
            while (node != null) {
                if (index == 0L) {
                    return Optional.of(node);
                }
                if (node.getChildrenCount() > 0) {
                    iterators.add(node.children.iterator());
                    ++level;
                }
                while (!((Iterator)iterators.get(level)).hasNext()) {
                    if (level == 0) {
                        return Optional.empty();
                    }
                    iterators.remove(level);
                    --level;
                }
                node = (XBTTreeNode)((Iterator)iterators.get(level)).next();
                --index;
            }
        }
        return Optional.empty();
    }

    public int fromStreamUB(InputStream stream) throws IOException, XBProcessingException {
        return this.fromStreamUB(stream, false);
    }

    public int fromStreamUB(InputStream stream, boolean terminable) throws IOException, XBProcessingException {
        Integer dataPartSizeValue;
        this.clear();
        UBNat32 attributePartSize = new UBNat32();
        int size = attributePartSize.fromStreamUB(stream);
        if (attributePartSize.getLong() == 0L) {
            if (terminable) {
                return 1;
            }
            throw new XBParsingException("Unexpected terminator", XBProcessingExceptionType.UNEXPECTED_TERMINATOR);
        }
        UBENat32 dataPartSize = new UBENat32();
        size += dataPartSize.fromStreamUB(stream);
        this.terminationMode = dataPartSize.isInfinity() ? XBBlockTerminationMode.TERMINATED_BY_ZERO : XBBlockTerminationMode.SIZE_SPECIFIED;
        Integer n = dataPartSizeValue = dataPartSize.isInfinity() ? null : Integer.valueOf(dataPartSize.getInt());
        if (attributePartSize.getInt() == dataPartSize.getSizeUB()) {
            this.dataMode = XBBlockDataMode.DATA_BLOCK;
            this.data = new XBData();
            TerminatedDataInputStreamWrapper dataWrapper = dataPartSizeValue == null ? new TerminatedDataInputStreamWrapper(stream) : new FixedDataInputStreamWrapper(stream, dataPartSizeValue.intValue());
            this.data.loadFromStream((InputStream)dataWrapper);
            size = (int)((long)size + (this.data.getDataSize() + (long)(dataPartSizeValue == null ? 2 : 0)));
        } else {
            if (attributePartSize.getInt() < dataPartSize.getSizeUB()) {
                throw new XBParsingException("Attribute overreached", XBProcessingExceptionType.ATTRIBUTE_OVERFLOW);
            }
            this.dataMode = XBBlockDataMode.NODE_BLOCK;
            attributePartSize.setValue(attributePartSize.getInt() - dataPartSize.getSizeUB());
            int itemSize = 0;
            UBNat32 groupId = new UBNat32();
            int groupIdSize = groupId.fromStreamUB(stream);
            size += groupIdSize;
            if ((itemSize += groupIdSize) > attributePartSize.getInt()) {
                throw new XBParsingException("Attribute overreached", XBProcessingExceptionType.ATTRIBUTE_OVERFLOW);
            }
            UBNat32 blockId = new UBNat32();
            if (itemSize < attributePartSize.getInt()) {
                int blockIdSize = blockId.fromStreamUB(stream);
                size += blockIdSize;
                if ((itemSize += blockIdSize) > attributePartSize.getInt()) {
                    throw new XBParsingException("Attribute overreached", XBProcessingExceptionType.ATTRIBUTE_OVERFLOW);
                }
                this.setFixedBlockType(new XBFixedBlockType((UBNatural)groupId, (UBNatural)blockId));
            } else {
                this.setFixedBlockType(new XBFixedBlockType((UBNatural)groupId, (UBNatural)blockId));
                this.singleAttributeType = true;
            }
            if (attributePartSize.getInt() > itemSize) {
                do {
                    UBNat32 attribute = new UBNat32();
                    int attributeSize = attribute.fromStreamUB(stream);
                    this.attributes.add((XBAttribute)attribute);
                    size += attributeSize;
                    if ((itemSize += attributeSize) <= attributePartSize.getInt()) continue;
                    throw new XBParsingException("Attribute overreached", XBProcessingExceptionType.ATTRIBUTE_OVERFLOW);
                } while (itemSize < attributePartSize.getInt());
            }
            if (dataPartSize.isInfinity() || dataPartSize.getInt() > 0) {
                size += this.childrenFromStreamUB(stream, dataPartSizeValue);
            }
        }
        return size;
    }

    public int toStreamUB(OutputStream stream) throws IOException {
        if (this.dataMode == XBBlockDataMode.NODE_BLOCK) {
            UBENat32 dataPartSize;
            if (this.terminationMode == XBBlockTerminationMode.SIZE_SPECIFIED) {
                dataPartSize = new UBENat32(this.childrenSizeUB());
            } else {
                dataPartSize = new UBENat32();
                dataPartSize.setInfinity();
            }
            UBNat32 attributePartSize = new UBNat32(dataPartSize.getSizeUB() + this.attributesSizeUB() + this.typeSizeUB());
            int size = attributePartSize.toStreamUB(stream);
            size += dataPartSize.toStreamUB(stream);
            size += this.blockType.getGroupID().toStreamUB(stream);
            if (!this.singleAttributeType) {
                size += this.blockType.getBlockID().toStreamUB(stream);
            }
            if (this.getAttributesCount() > 0) {
                Iterator<XBAttribute> iter = this.attributes.iterator();
                while (iter.hasNext()) {
                    size += iter.next().toStreamUB(stream);
                }
            }
            size += this.childrenToStreamUB(stream);
            if (this.terminationMode == XBBlockTerminationMode.TERMINATED_BY_ZERO) {
                stream.write(0);
                ++size;
            }
            return size;
        }
        int size = 0;
        if (this.terminationMode == XBBlockTerminationMode.SIZE_SPECIFIED) {
            UBENat32 dataPartSize = new UBENat32(this.getDataSize());
            UBNat32 attributePartSize = new UBNat32(dataPartSize.getSizeUB());
            size += attributePartSize.toStreamUB(stream);
            size += dataPartSize.toStreamUB(stream);
            this.data.saveToStream(stream);
            size = (int)((long)size + this.getDataSize());
        } else {
            UBNat32 attributePartSize = new UBNat32(1);
            size += attributePartSize.toStreamUB(stream);
            UBENat32 dataPartSize = new UBENat32();
            dataPartSize.setInfinity();
            size += dataPartSize.toStreamUB(stream);
            TerminatedDataOutputStreamWrapper streamWrapper = new TerminatedDataOutputStreamWrapper(stream);
            StreamUtils.copyInputStreamToOutputStream((InputStream)this.data.getDataInputStream(), (OutputStream)streamWrapper);
            int dataSize = (int)((FinishableStream)streamWrapper).finish();
            size += dataSize;
        }
        return size;
    }

    public int childrenToStreamUB(OutputStream stream) throws IOException {
        Iterator<XBTBlock> iter = this.children.iterator();
        int size = 0;
        while (iter.hasNext()) {
            size += ((XBTTreeNode)iter.next()).toStreamUB(stream);
        }
        return size;
    }

    public int getSizeUB() {
        if (this.dataMode == XBBlockDataMode.NODE_BLOCK) {
            int size = this.childrenSizeUB();
            UBENat32 dataPartSize = new UBENat32();
            if (this.terminationMode == XBBlockTerminationMode.SIZE_SPECIFIED) {
                dataPartSize.setValue(size);
            } else {
                dataPartSize.setInfinity();
            }
            UBNat32 attrPartSize = new UBNat32(dataPartSize.getSizeUB() + this.attributesSizeUB() + this.typeSizeUB());
            size += attrPartSize.getSizeUB();
            size += attrPartSize.getInt();
            if (this.terminationMode == XBBlockTerminationMode.TERMINATED_BY_ZERO) {
                ++size;
            }
            return size;
        }
        int size = 0;
        if (this.terminationMode == XBBlockTerminationMode.SIZE_SPECIFIED) {
            UBENat32 dataPartSize = new UBENat32(this.getDataSize());
            UBNat32 attrPartSize = new UBNat32(dataPartSize.getSizeUB());
            size += attrPartSize.getSizeUB();
            size += dataPartSize.getSizeUB();
            size = (int)((long)size + this.getDataSize());
        } else {
            try {
                size += 2 + XBTokenBuffer.computeAdjustedSize((InputStream)this.getData());
            }
            catch (IOException ex) {
                Logger.getLogger(XBTreeNode.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return size;
    }

    public int childrenSizeUB() {
        Iterator<XBTBlock> iter = this.children.iterator();
        int size = 0;
        while (iter.hasNext()) {
            size += ((XBTTreeNode)iter.next()).getSizeUB();
        }
        return size;
    }

    public int attributesSizeUB() {
        if (this.getAttributesCount() > 0) {
            int size = 0;
            for (XBAttribute attribute : this.attributes) {
                size += attribute.getSizeUB();
            }
            return size;
        }
        return 0;
    }

    public void clear() {
        this.children.clear();
        if (this.data != null) {
            this.data = null;
        }
        this.attributes.clear();
        this.blockDecl = null;
    }

    @Nonnull
    public InputStream getData() {
        if (this.dataMode != XBBlockDataMode.DATA_BLOCK) {
            throw new IllegalStateException("Cannot read data of node block");
        }
        return this.data.getDataInputStream();
    }

    @Nonnull
    public BinaryData getBlockData() {
        if (this.dataMode != XBBlockDataMode.DATA_BLOCK) {
            throw new IllegalStateException("Cannot read data of node block");
        }
        return (BinaryData)Objects.requireNonNull(this.data);
    }

    public long getDataSize() {
        if (this.data == null) {
            return 0L;
        }
        return this.data.getDataSize();
    }

    public void setData(InputStream source) throws IOException {
        if (source == null) {
            this.data = null;
        } else {
            this.data = new XBData();
            this.data.loadFromStream(source);
        }
    }

    public void setData(BinaryData newData) {
        this.data = new XBData();
        this.data.insert(0L, newData);
    }

    public XBTTreeNode cloneNode() {
        return this.cloneNode(true);
    }

    public XBTTreeNode cloneNode(boolean recursive) {
        XBTTreeNode node = new XBTTreeNode();
        node.setBlockDecl(this.blockDecl);
        node.setFixedBlockType(this.blockType);
        node.setSingleAttributeType(this.singleAttributeType);
        node.setDataMode(this.dataMode);
        if (this.data != null) {
            XBData newData = new XBData();
            newData.setData((BinaryData)this.data);
            node.data = newData;
        }
        for (XBAttribute attribute : this.attributes) {
            node.addAttribute((XBAttribute)new UBNat32(attribute.getNaturalLong()));
        }
        ArrayList<XBTTreeNode> cloneChildren = new ArrayList<XBTTreeNode>();
        for (XBTBlock block : this.children) {
            if (recursive) {
                XBTTreeNode childNode = ((XBTTreeNode)block).cloneNode(true);
                childNode.setParent((XBTBlock)node);
                cloneChildren.add(childNode);
                continue;
            }
            cloneChildren.add((XBTTreeNode)block);
        }
        node.setChildren(cloneChildren.toArray(new XBTBlock[0]));
        return node;
    }

    public XBTTreeNode createNewChild(int childIndex) {
        XBTTreeNode childNode = new XBTTreeNode(this);
        this.setChildAt((XBTBlock)childNode, childIndex);
        return childNode;
    }

    public long getBlockSize() {
        return this.getSizeUB();
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void addAttribute(XBAttribute attribute) {
        if (this.attributes.isEmpty() && this.singleAttributeType) {
            this.singleAttributeType = false;
        }
        this.attributes.add(attribute);
    }

    public void removeAttribute(int index) {
        this.attributes.remove(index);
    }

    private int typeSizeUB() {
        return this.singleAttributeType ? this.blockType.getGroupID().getSizeUB() : this.blockType.getSizeUB();
    }

    @Override
    @Nullable
    public XBTTreeNode getParent() {
        return this.parent;
    }

    @Nonnull
    public Optional<XBTBlock> getParentBlock() {
        return Optional.ofNullable(this.parent);
    }

    public void setParent(XBTBlock parent) {
        this.parent = (XBTTreeNode)parent;
    }

    public XBBlockTerminationMode getTerminationMode() {
        return this.terminationMode;
    }

    public void setTerminationMode(XBBlockTerminationMode terminationMode) {
        if (terminationMode == null) {
            throw new NullPointerException();
        }
        this.terminationMode = terminationMode;
    }

    public XBBlockDataMode getDataMode() {
        return this.dataMode;
    }

    public void setDataMode(XBBlockDataMode dataMode) {
        if (dataMode == null) {
            throw new NullPointerException();
        }
        if (dataMode != this.dataMode) {
            switch (dataMode) {
                case DATA_BLOCK: {
                    this.data = new XBData();
                    this.clearAttributes();
                    break;
                }
                case NODE_BLOCK: {
                    this.data = null;
                    this.clearAttributes();
                }
            }
        }
        this.dataMode = dataMode;
    }

    public XBBlockType getBlockType() {
        return this.blockDecl != null ? new XBDeclBlockType(this.blockDecl) : this.getFixedBlockType();
    }

    public void setBlockType(XBBlockType blockType) {
        if (blockType instanceof XBFBlockType) {
            XBDeclBlockType declBlockType;
            this.blockDecl = null;
            if (this.context != null && (declBlockType = this.context.getDeclBlockType((XBFBlockType)blockType)) != null) {
                this.blockDecl = declBlockType.getBlockDecl();
            }
            this.setFixedBlockType((XBFixedBlockType)blockType);
        } else if (blockType instanceof XBDBlockType) {
            this.blockDecl = ((XBDBlockType)blockType).getBlockDecl();
            XBFixedBlockType fixedBlockType = this.context != null ? this.context.getFixedBlockType((XBDBlockType)blockType) : null;
            this.setFixedBlockType(fixedBlockType != null ? fixedBlockType : new XBFixedBlockType());
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public XBFixedBlockType getFixedBlockType() {
        return this.blockType;
    }

    public void setFixedBlockType(XBFixedBlockType blockType) {
        if (blockType == null) {
            throw new NullPointerException();
        }
        if (!blockType.getBlockID().isZero()) {
            this.singleAttributeType = false;
        }
        this.blockType = blockType;
    }

    public XBAttribute getAttributeAt(int attributeIndex) {
        return attributeIndex < this.attributes.size() ? this.attributes.get(attributeIndex) : null;
    }

    public void setAttributeAt(XBAttribute attribute, int attributeIndex) {
        this.singleAttributeType = false;
        while (this.attributes.size() <= attributeIndex) {
            this.attributes.add((XBAttribute)new UBNat32());
        }
        this.attributes.set(attributeIndex, attribute);
    }

    public int getAttributeValue(int attributeIndex) {
        return attributeIndex < this.attributes.size() ? this.attributes.get(attributeIndex).getNaturalInt() : 0;
    }

    public int getAttributesCount() {
        return this.attributes.size();
    }

    public void setAttributesCount(int count) {
        block3: {
            block2: {
                this.singleAttributeType = false;
                if (this.attributes.size() >= count) break block2;
                for (int i = this.attributes.size(); i < count; ++i) {
                    this.attributes.add((XBAttribute)new UBNat32());
                }
                break block3;
            }
            if (this.attributes.size() <= count) break block3;
            for (int i = this.attributes.size() - 1; i >= count; --i) {
                this.attributes.remove(i);
            }
        }
    }

    public XBAttribute[] getAttributes() {
        return this.attributes.toArray(new XBAttribute[0]);
    }

    public void setAttributes(XBAttribute[] attributes) {
        this.attributes.clear();
        this.attributes.addAll(Arrays.asList(attributes));
        this.singleAttributeType = false;
    }

    @Override
    public XBTTreeNode getChildAt(int childIndex) {
        return childIndex < this.children.size() ? (XBTTreeNode)this.children.get(childIndex) : null;
    }

    public void setChildAt(XBTBlock block, int childIndex) {
        while (this.children.size() <= childIndex) {
            this.children.add((XBTBlock)new XBTTreeNode(this));
        }
        this.children.set(childIndex, block);
    }

    public void addChild(XBTTreeNode child) {
        this.children.add((XBTBlock)child);
    }

    public void removeChild(int index) {
        this.children.remove(index);
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    @Override
    public int getChildCount() {
        return this.getChildrenCount();
    }

    public void setChildrenCount(int count) {
        block3: {
            block2: {
                if (this.children.size() >= count) break block2;
                for (int i = this.children.size(); i < count; ++i) {
                    this.children.add((XBTBlock)new XBTTreeNode(this));
                }
                break block3;
            }
            if (this.children.size() <= count) break block3;
            for (int i = this.children.size() - 1; i >= count; --i) {
                this.children.remove(i);
            }
        }
    }

    public XBTBlock[] getChildren() {
        return this.children.toArray(new XBTBlock[0]);
    }

    public void setChildren(XBTBlock[] children) {
        this.children.clear();
        this.children.addAll(Arrays.asList(children));
    }

    @Override
    public boolean getAllowsChildren() {
        return this.dataMode != XBBlockDataMode.NODE_BLOCK;
    }

    @Override
    public boolean isLeaf() {
        return this.dataMode == XBBlockDataMode.DATA_BLOCK;
    }

    public Enumeration<XBTTreeNode> children() {
        return new Enumeration<XBTTreeNode>(){
            private final Iterator<XBTBlock> i;
            {
                this.i = XBTTreeNode.this.children.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            @Override
            public XBTTreeNode nextElement() {
                return (XBTTreeNode)this.i.next();
            }
        };
    }

    public void setContext(XBContext context) {
        this.context = context;
    }

    public XBContext getContext() {
        return this.context;
    }

    public XBBlockDecl getBlockDecl() {
        return this.blockDecl;
    }

    public void setBlockDecl(XBBlockDecl blockDecl) {
        this.blockDecl = blockDecl;
    }

    public boolean getSingleAttributeType() {
        return this.singleAttributeType;
    }

    public void setSingleAttributeType(boolean singleAttributeType) {
        this.singleAttributeType = singleAttributeType;
    }

    public void processSpec(XBCatalog catalog, XBContext parentContext) {
        this.context = parentContext;
        if (this.dataMode == XBBlockDataMode.NODE_BLOCK) {
            XBDeclBlockType declBlockType;
            this.blockDecl = this.context != null ? ((declBlockType = this.context.getDeclBlockType((XBFBlockType)this.getFixedBlockType())) == null ? null : declBlockType.getBlockDecl()) : null;
            if (this.getFixedBlockType().getAsBasicType() == XBBasicBlockType.DECLARATION && catalog != null) {
                XBContext childContext = catalog.processDeclaration(parentContext, (XBTPullProvider)new XBTProviderToPullProvider((XBTProvider)new XBTTreeWriter(new XBTBlockFixedSource(this))));
                long l = 0L;
                for (XBTTreeNode xBTTreeNode : this.children) {
                    xBTTreeNode.processSpec(catalog, ++l == 2L ? childContext : parentContext);
                }
                return;
            }
        } else {
            this.blockDecl = null;
        }
        for (XBTTreeNode xBTTreeNode : this.children) {
            xBTTreeNode.processSpec(catalog, parentContext);
        }
    }

    public XBTTreeNode followPointer(int index) {
        if (this.getAttributesCount() >= index) {
            int childIndex = ((UBNat32)this.getAttributeAt(index)).getInt();
            if (childIndex > 0 && this.children.size() >= childIndex) {
                return this.getChildAt(childIndex - 1);
            }
            return null;
        }
        return null;
    }

    public int childrenFromStreamUB(InputStream stream, @Nullable Integer maxSize) throws IOException, XBProcessingException {
        int childSize;
        this.children.clear();
        if (maxSize != null && maxSize == 0) {
            return 0;
        }
        int size = 0;
        do {
            XBTTreeNode child = new XBTTreeNode();
            child.setParent((XBTBlock)this);
            childSize = child.fromStreamUB(stream, maxSize == null);
            size += childSize;
            if (childSize <= 1) continue;
            if (maxSize != null && size > maxSize) {
                throw new XBParsingException("Block overreached", XBProcessingExceptionType.BLOCK_OVERFLOW);
            }
            this.children.add((XBTBlock)child);
        } while (maxSize == null && childSize != 1 || maxSize != null && maxSize > 0 && size < maxSize);
        return size;
    }

    @Nonnull
    public static XBTTreeNode createTreeCopy(XBTBlock block) {
        return XBTTreeNode.createTreeCopy(block, null);
    }

    @Nonnull
    public static XBTTreeNode createTreeCopy(XBTBlock block, XBTTreeNode parent) {
        XBTTreeNode node = new XBTTreeNode();
        node.setParent((XBTBlock)parent);
        node.setDataMode(block.getDataMode());
        node.setTerminationMode(block.getTerminationMode());
        if (block.getDataMode() == XBBlockDataMode.NODE_BLOCK) {
            node.setBlockType(block.getBlockType());
            if (block.getAttributesCount() > 0) {
                node.setAttributes(block.getAttributes());
            }
            if (block.getChildrenCount() > 0) {
                for (XBTBlock childBlock : block.getChildren()) {
                    XBTTreeNode childNode = XBTTreeNode.createTreeCopy(childBlock, node);
                    node.addChild(childNode);
                }
            }
        } else {
            XBData data = new XBData();
            data.insert(0L, block.getBlockData());
            node.setData((BinaryData)data);
        }
        return node;
    }

    @ParametersAreNonnullByDefault
    private static class XBTBlockFixedSource
    implements XBTBlock {
        private final XBTTreeNode block;

        public XBTBlockFixedSource(XBTTreeNode block) {
            this.block = block;
        }

        @Nonnull
        public Optional<XBTBlock> getParentBlock() {
            return this.block.getParentBlock();
        }

        @Nonnull
        public XBBlockTerminationMode getTerminationMode() {
            return this.block.getTerminationMode();
        }

        @Nonnull
        public XBBlockDataMode getDataMode() {
            return this.block.getDataMode();
        }

        @Nonnull
        public XBBlockType getBlockType() {
            return this.block.getFixedBlockType();
        }

        public XBAttribute[] getAttributes() {
            return this.block.getAttributes();
        }

        public XBAttribute getAttributeAt(int attributeIndex) {
            return this.block.getAttributeAt(attributeIndex);
        }

        public int getAttributesCount() {
            return this.block.getAttributesCount();
        }

        public XBTBlock[] getChildren() {
            XBTBlock[] result = new XBTBlock[this.block.getChildrenCount()];
            int i = 0;
            for (XBTBlock child : this.block.getChildren()) {
                result[i++] = new XBTBlockFixedSource((XBTTreeNode)child);
            }
            return result;
        }

        public XBTBlock getChildAt(int childIndex) {
            return new XBTBlockFixedSource(this.block.getChildAt(childIndex));
        }

        public int getChildrenCount() {
            return this.block.getChildrenCount();
        }

        @Nonnull
        public InputStream getData() {
            return this.block.getData();
        }

        @Nonnull
        public BinaryData getBlockData() {
            return this.block.getBlockData();
        }

        public long getDataSize() {
            return this.block.getDataSize();
        }

        public int getBlockIndex() {
            return this.block.getBlockIndex();
        }

        public long getBlockSize() {
            return this.block.getBlockSize();
        }
    }
}

