/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_tree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.declaration.XBContext;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.ubnumber.UBStreamable;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class XBTTree
implements UBStreamable {
    @Nullable
    private XBTTreeNode rootNode = null;
    @Nullable
    private XBCatalog catalog;
    @Nullable
    protected XBContext rootContext;

    public XBTTree(XBCatalog catalog) {
        this(catalog, null);
    }

    public XBTTree(@Nullable XBCatalog catalog, @Nullable XBContext rootContext) {
        this.catalog = catalog;
        this.rootContext = rootContext;
    }

    public int fromStreamUB(InputStream stream) throws IOException, XBProcessingException {
        this.clear();
        XBTTreeNode newRoot = new XBTTreeNode();
        this.setRoot(newRoot);
        return newRoot.fromStreamUB(stream);
    }

    public void setCatalog(@Nullable XBCatalog catalog) {
        this.catalog = catalog;
        this.rootContext = catalog != null ? catalog.getRootContext() : null;
    }

    public void processSpec() {
        if (this.rootNode != null) {
            this.rootNode.processSpec(this.catalog, this.rootContext);
        }
    }

    @Nonnull
    public XBTTreeNode newNodeInstance(@Nullable XBTTreeNode parent) {
        return new XBTTreeNode(parent);
    }

    public void clear() {
        this.rootNode = null;
    }

    public int toStreamUB(OutputStream stream) throws IOException {
        if (this.rootNode != null) {
            return this.rootNode.toStreamUB(stream);
        }
        return 0;
    }

    public int getSizeUB() {
        if (this.rootNode != null) {
            return this.rootNode.getSizeUB();
        }
        return 0;
    }

    @Nonnull
    public Optional<XBTBlock> findNodeByIndex(long index) {
        return Optional.ofNullable(this.rootNode.findNodeByIndex(index).orElse(null));
    }

    @Nullable
    public XBTTreeNode getRoot() {
        return this.rootNode;
    }

    @Nonnull
    public Optional<XBTBlock> getRootBlock() {
        return Optional.ofNullable(this.rootNode);
    }

    public void setRoot(@Nullable XBTTreeNode rootNode) {
        this.rootNode = rootNode;
        this.processSpec();
    }

    @Nullable
    public XBContext getRootContext() {
        return this.rootContext;
    }

    public void setRootContext(@Nullable XBContext rootContext) {
        this.rootContext = rootContext;
        this.processSpec();
    }

    @Nullable
    public XBCatalog getCatalog() {
        return this.catalog;
    }
}

