/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.preferences;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.exbin.framework.preferences.FilePreferencesFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@ParametersAreNonnullByDefault
public class FilePreferences
extends AbstractPreferences {
    private static final String MAP_XML_VERSION_ATTRIBUTE = "MAP_XML_VERSION";
    private static final String MAP_XML_VERSION_VALUE = "1.0";
    private final File preferencesFile;
    private final Map<String, String> spiValues = new TreeMap<String, String>();
    private Map<String, FilePreferences> children = new TreeMap<String, FilePreferences>();

    public FilePreferences() {
        this(null, "");
    }

    public FilePreferences(@Nullable AbstractPreferences parent, String name) {
        super(parent, name);
        this.preferencesFile = this.createPreferenceFile();
        this.init();
    }

    public FilePreferences(@Nullable AbstractPreferences parent, String name, File preferencesFile) {
        super(parent, name);
        this.preferencesFile = preferencesFile;
        this.init();
    }

    private void init() {
        try {
            this.sync();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(FilePreferences.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Nonnull
    private File createPreferenceFile() {
        return FilePreferencesFactory.getPreferencesFile(this.absolutePath());
    }

    @Override
    protected void putSpi(String key, String value) {
        this.spiValues.put(key, value);
        try {
            this.flush();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(FilePreferences.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    @Nullable
    protected String getSpi(String key) {
        return this.spiValues.get(key);
    }

    @Override
    protected void removeSpi(String key) {
        this.spiValues.remove(key);
        try {
            this.flush();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(FilePreferences.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        this.removeNode();
        this.flush();
    }

    @Override
    @Nonnull
    protected String[] keysSpi() throws BackingStoreException {
        Set<String> keySet = this.spiValues.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    @Override
    @Nonnull
    protected String[] childrenNamesSpi() throws BackingStoreException {
        Set<String> keySet = this.children.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    @Override
    @Nonnull
    protected AbstractPreferences childSpi(String name) {
        FilePreferences child = this.children.get(name);
        if (child == null || child.isRemoved()) {
            child = new FilePreferences(this, name);
            this.children.put(name, child);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncSpi() throws BackingStoreException {
        if (this.isRemoved()) {
            this.clear();
            return;
        }
        if (!this.preferencesFile.exists()) {
            return;
        }
        File file = this.preferencesFile;
        synchronized (file) {
            try (FileInputStream fileStream = new FileInputStream(this.preferencesFile);){
                this.importFromStream(fileStream, this);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(FilePreferences.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(FilePreferences.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushSpi() throws BackingStoreException {
        File file = this.preferencesFile;
        synchronized (file) {
            if (!this.preferencesFile.exists()) {
                try {
                    this.preferencesFile.getParentFile().mkdirs();
                    this.preferencesFile.createNewFile();
                }
                catch (IOException ex) {
                    Logger.getLogger(FilePreferences.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            try (FileOutputStream fileStream = new FileOutputStream(this.preferencesFile);){
                FilePreferences.exportToStream(fileStream, this);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(FilePreferences.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(FilePreferences.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    static void exportToStream(OutputStream os, FilePreferences p) throws IOException, BackingStoreException {
        Document doc = FilePreferences.createPreferencesDoc("map");
        Element preferences = doc.getDocumentElement();
        preferences.setAttribute(MAP_XML_VERSION_ATTRIBUTE, MAP_XML_VERSION_VALUE);
        FilePreferences.putPreferencesInXml(doc.getDocumentElement(), doc, p);
        FilePreferences.writeXmlDocument(doc, os);
    }

    @Nonnull
    private static Document createPreferencesDoc(String qname) {
        try {
            DOMImplementation di = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
            DocumentType dt = di.createDocumentType(qname, null, "http://java.sun.com/dtd/preferences.dtd");
            return di.createDocument(null, qname, dt);
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putPreferencesInXml(Element map, Document doc, FilePreferences prefs) throws BackingStoreException {
        Object object = prefs.lock;
        synchronized (object) {
            String[] keys;
            if (prefs.isRemoved()) {
                NodeList childNodes = map.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    map.removeChild(childNodes.item(i));
                }
                return;
            }
            for (String key : keys = prefs.keys()) {
                Element entry = (Element)map.appendChild(doc.createElement("entry"));
                entry.setAttribute("key", key);
                entry.setAttribute("value", prefs.get(key, null));
            }
        }
    }

    private static void writeXmlDocument(Document doc, OutputStream out) throws IOException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                tf.setAttribute("indent-number", 2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Transformer t = tf.newTransformer();
            t.setOutputProperty("doctype-system", doc.getDoctype().getSystemId());
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(doc), new StreamResult(new BufferedWriter(new OutputStreamWriter(out, "UTF-8"))));
        }
        catch (TransformerException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFromStream(FileInputStream fileStream, FilePreferences p) {
        Object object = p.lock;
        synchronized (object) {
            try {
                Document doc = FilePreferences.loadPrefsDoc(fileStream);
                FilePreferences.importPrefs(p, doc.getDocumentElement());
            }
            catch (IOException | SAXException ex) {
                Logger.getLogger(FilePreferences.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static void importPrefs(Preferences prefsNode, Element map) {
        NodeList entries = map.getChildNodes();
        int numEntries = entries.getLength();
        for (int i = 0; i < numEntries; ++i) {
            Element entry = (Element)entries.item(i);
            prefsNode.put(entry.getAttribute("key"), entry.getAttribute("value"));
        }
    }

    @Nonnull
    private static Document loadPrefsDoc(InputStream in) throws SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setValidating(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringComments(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new Resolver());
            db.setErrorHandler(new RethrowErrorHandler());
            return db.parse(new InputSource(in));
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    @ParametersAreNonnullByDefault
    private static class RethrowErrorHandler
    implements ErrorHandler {
        private RethrowErrorHandler() {
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            throw ex;
        }
    }

    @ParametersAreNonnullByDefault
    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        @Override
        @Nonnull
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (systemId.equals("http://java.sun.com/dtd/preferences.dtd")) {
                InputSource is = new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for preferences --><!ELEMENT map (entry*) ><!ATTLIST map  MAP_XML_VERSION CDATA \"0.0\"  ><!ELEMENT entry EMPTY ><!ATTLIST entry          key CDATA #REQUIRED          value CDATA #REQUIRED >"));
                is.setSystemId("http://java.sun.com/dtd/preferences.dtd");
                return is;
            }
            throw new SAXException("Invalid system identifier: " + systemId);
        }
    }
}

