/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.exbin.framework.XBDefaultApplicationModuleRepository;
import org.exbin.framework.api.LanguageProvider;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.api.XBApplicationModuleRepository;
import org.exbin.framework.preferences.FilePreferencesFactory;
import org.exbin.framework.preferences.FrameworkPreferences;
import org.exbin.framework.preferences.PreferencesWrapper;
import org.exbin.framework.utils.DesktopUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.plugin.LookAndFeelApplier;

@ParametersAreNonnullByDefault
public class XBBaseApplication
implements XBApplication {
    private ResourceBundle appBundle;
    private String appBundleName;
    private Preferences appPreferences;
    private final XBDefaultApplicationModuleRepository moduleRepository;
    private final List<URI> plugins = new ArrayList<URI>();
    private final List<LanguageProvider> languagePlugins = new ArrayList<LanguageProvider>();
    private final Map<String, LookAndFeelApplier> lafPlugins = new HashMap<String, LookAndFeelApplier>();
    private String targetLaf = null;
    private File appDirectory = new File("");

    public XBBaseApplication() {
        this.moduleRepository = new XBDefaultApplicationModuleRepository(this);
    }

    public void init() {
        Locale defaultLocale = Locale.getDefault();
        ResourceBundle.Control control = new ResourceBundle.Control(){};
        List<Locale> candidateLocales = control.getCandidateLocales("", defaultLocale);
        ArrayList<Locale.LanguageRange> priorityList = new ArrayList<Locale.LanguageRange>();
        for (Locale locale : candidateLocales) {
            priorityList.add(new Locale.LanguageRange(locale.toLanguageTag()));
        }
        ArrayList<Locale> availableLocales = new ArrayList<Locale>();
        for (LanguageProvider languagePlugin : this.languagePlugins) {
            availableLocales.add(languagePlugin.getLocale());
        }
        List<Locale> list = Locale.filter(priorityList, availableLocales);
        if (!list.isEmpty()) {
            Locale bestMatch = list.get(0);
            for (LanguageProvider languagePlugin : this.languagePlugins) {
                if (!languagePlugin.getLocale().equals(bestMatch)) continue;
                ClassLoader languageClassLoader = languagePlugin.getClassLoader().orElse(null);
                if (languageClassLoader == null) break;
                LanguageUtils.setLanguageClassLoader((ClassLoader)languageClassLoader);
                try {
                    this.appBundle = LanguageUtils.getResourceBundleByClass(Class.forName(this.appBundleName.replaceFirst("/resources/", "/").replaceAll("/", ".")));
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(XBBaseApplication.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
        }
        if (this.targetLaf != null) {
            this.applyLookAndFeel(this.targetLaf);
        }
    }

    public void run(Runnable runnable) {
        ClassLoader classLoader = this.moduleRepository.getContextClassLoader();
        Thread runThread = new Thread(runnable);
        runThread.setContextClassLoader(classLoader);
        runThread.run();
    }

    @Nonnull
    public ResourceBundle getAppBundle() {
        return this.appBundle;
    }

    public void setAppBundle(ResourceBundle appBundle, String bundleName) {
        this.appBundleName = bundleName;
        this.appBundle = appBundle;
    }

    @Nonnull
    public Preferences createPreferences(Class clazz) {
        String osName = System.getProperty("os.name").toLowerCase();
        java.util.prefs.Preferences prefsPreferences = osName.startsWith("win") ? new FilePreferencesFactory().userNodeForPackage(clazz) : java.util.prefs.Preferences.userNodeForPackage(clazz);
        PreferencesWrapper wrapper = new PreferencesWrapper(prefsPreferences);
        this.setAppPreferences(wrapper);
        return wrapper;
    }

    @Nonnull
    public Preferences getAppPreferences() {
        return this.appPreferences;
    }

    public void setAppPreferences(Preferences appPreferences) {
        this.appPreferences = appPreferences;
        this.initByPreferences();
    }

    @Nonnull
    public File getAppDirectory() {
        return this.appDirectory;
    }

    public void setAppDirectory(File appDirectory) {
        this.appDirectory = appDirectory;
    }

    public void setAppDirectory(Class classInstance) {
        URL classResourceUrl = classInstance.getResource(classInstance.getSimpleName() + ".class");
        if (!"jar".equals(classResourceUrl.getProtocol())) {
            return;
        }
        try {
            URL appDirectoryUrl = classInstance.getProtectionDomain().getCodeSource().getLocation();
            this.appDirectory = new File(appDirectoryUrl.toURI()).getParentFile();
            return;
        }
        catch (SecurityException appDirectoryUrl) {
        }
        catch (NullPointerException appDirectoryUrl) {
        }
        catch (URISyntaxException appDirectoryUrl) {
            // empty catch block
        }
        String appDirectoryPath = classResourceUrl.toString();
        appDirectoryPath = appDirectoryPath.substring(4, appDirectoryPath.indexOf("!"));
        this.appDirectory = new File(appDirectoryPath).getParentFile();
    }

    private void initByPreferences() {
        Locale locale;
        String fontAntialiasing;
        FrameworkPreferences frameworkParameters = new FrameworkPreferences(this.appPreferences);
        String renderingMode = frameworkParameters.getRenderingMode();
        if ("software".equals(renderingMode)) {
            System.setProperty("sun.java2d.noddraw", "true");
        } else if ("directdraw".equals(renderingMode)) {
            System.setProperty("sun.java2d.d3d", "false");
        } else if ("hw_scale".equals(renderingMode)) {
            System.setProperty("sun.java2d.d3d", "true");
            System.setProperty("sun.java2d.ddforcevram", "true");
            System.setProperty("sun.java2d.translaccel", "true");
            System.setProperty("sun.java2d.ddscale", "true");
        } else if ("opengl".equals(renderingMode)) {
            System.setProperty("sun.java2d.opengl", "true");
        } else if ("xrender".equals(renderingMode)) {
            System.setProperty("sun.java2d.xrender", "true");
        } else if ("metal".equals(renderingMode)) {
            System.setProperty("sun.java2d.metal", "true");
        }
        String guiScaling = frameworkParameters.getGuiScaling();
        if (!guiScaling.isEmpty()) {
            if ("custom".equals(guiScaling)) {
                float guiScalingRate = frameworkParameters.getGuiScalingRate();
                String scalingRateText = (double)guiScalingRate == Math.floor(guiScalingRate) ? String.format("%.0f", Float.valueOf(guiScalingRate)) : String.valueOf(guiScalingRate);
                System.setProperty("sun.java2d.uiScale.enabled", "true");
                System.setProperty("sun.java2d.uiScale", scalingRateText);
            } else {
                System.setProperty("sun.java2d.uiScale.enabled", guiScaling);
            }
        }
        if (!(fontAntialiasing = frameworkParameters.getFontAntialiasing()).isEmpty()) {
            System.setProperty("awt.useSystemAAFontSettings", fontAntialiasing);
        }
        if (DesktopUtils.detectBasicOs() == DesktopUtils.DesktopOs.MAC_OS) {
            String macOsAppearance;
            boolean useScreenMenuBar = frameworkParameters.isUseScreenMenuBar();
            if (useScreenMenuBar) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            }
            if ("light".equals(macOsAppearance = frameworkParameters.getMacOsAppearance())) {
                System.setProperty("apple.awt.application.appearance", "NSAppearanceNameAqua");
            } else if ("dark".equals(macOsAppearance)) {
                System.setProperty("apple.awt.application.appearance", "NSAppearanceNameDarkAqua");
            } else if ("system".equals(macOsAppearance)) {
                System.setProperty("apple.awt.application.appearance", "system");
            }
        }
        if (!(locale = frameworkParameters.getLocale()).equals(Locale.ROOT)) {
            Locale.setDefault(locale);
        }
        this.targetLaf = frameworkParameters.getLookAndFeel();
    }

    public void applyLookAndFeel(String laf) {
        try {
            if (laf.isEmpty()) {
                String osName = System.getProperty("os.name").toLowerCase();
                if (!osName.startsWith("windows") && !osName.startsWith("mac")) {
                    try {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                        laf = UIManager.getSystemLookAndFeelClassName();
                    }
                } else {
                    laf = UIManager.getSystemLookAndFeelClassName();
                }
            }
            if (laf != null && !laf.isEmpty()) {
                LookAndFeelApplier applier = this.lafPlugins.get(laf);
                if (applier != null) {
                    applier.applyLookAndFeel(laf);
                } else {
                    UIManager.setLookAndFeel(laf);
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(XBBaseApplication.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadPlugin(URI uri) {
        if (!this.plugins.add(uri)) {
            throw new RuntimeException("Unable to load plugin: " + uri.toString());
        }
        this.getModuleRepository().addModulesFrom(uri);
    }

    public void loadPlugin(String jarFilePath) {
        try {
            this.loadPlugin(new URI(jarFilePath));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public void loadClassPathPlugins(Class targetClass) {
        try {
            Manifest manifest = new Manifest(targetClass.getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF"));
            Attributes classPaths = manifest.getAttributes("Class-Path");
            Collection<Object> values = classPaths.values();
            values.stream().filter(classPath -> classPath instanceof String).forEachOrdered(classPath -> this.loadPlugin((String)classPath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nonnull
    public Optional<Image> getApplicationIcon() {
        if (!this.appBundle.containsKey("Application.icon")) {
            return Optional.empty();
        }
        return Optional.of(new ImageIcon(this.getClass().getResource(this.appBundle.getString("Application.icon"))).getImage());
    }

    @Nonnull
    public XBApplicationModuleRepository getModuleRepository() {
        return this.moduleRepository;
    }

    public void registerLanguagePlugin(final Locale locale, final ClassLoader classLoader) {
        this.languagePlugins.add(new LanguageProvider(){

            @Nonnull
            public Locale getLocale() {
                return locale;
            }

            @Nonnull
            public Optional<ClassLoader> getClassLoader() {
                return Optional.of(classLoader);
            }

            @Nonnull
            public Optional<ImageIcon> getFlag() {
                return Optional.empty();
            }
        });
    }

    public void registerLanguagePlugin(LanguageProvider languageProvider) {
        this.languagePlugins.add(languageProvider);
    }

    public void registerLafPlugin(String className, LookAndFeelApplier applier) {
        this.lafPlugins.put(className, applier);
    }

    @Nonnull
    public List<LanguageProvider> getLanguagePlugins() {
        return this.languagePlugins;
    }
}

