/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.ubnumber.type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.ubnumber.UBBoolean;
import org.exbin.xbup.core.ubnumber.UBNatural;
import org.exbin.xbup.core.ubnumber.exception.UBOverFlowException;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class UBBool
implements UBBoolean,
XBPSequenceSerializable {
    private boolean value;

    public UBBool() {
        this.value = false;
    }

    public UBBool(boolean value) {
        this.value = value;
    }

    @Override
    public boolean getBoolean() throws UBOverFlowException {
        return this.value;
    }

    @Override
    public void setValue(boolean value) throws UBOverFlowException {
        this.value = value;
    }

    @Override
    public long getSegmentCount() {
        return 1L;
    }

    @Override
    public long getValueSegment(long segmentIndex) {
        if (segmentIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return this.value ? 1L : 0L;
    }

    @Override
    public int fromStreamUB(InputStream stream) throws IOException, XBProcessingException {
        byte[] buffer = new byte[1];
        if (stream.read(buffer) < 0) {
            throw new XBProcessingException("End of data reached", XBProcessingExceptionType.UNEXPECTED_END_OF_STREAM);
        }
        long input = (char)buffer[0] & 0xFF;
        if (input > 1L || input < 0L) {
            throw new XBProcessingException("Unsupported boolean value", XBProcessingExceptionType.UNEXPECTED_END_OF_STREAM);
        }
        this.value = input == 1L;
        return 1;
    }

    @Override
    public int toStreamUB(OutputStream stream) throws IOException {
        stream.write((char)(this.value ? 1 : 0));
        return 1;
    }

    @Override
    public int getSizeUB() {
        return 1;
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType(new XBDeclBlockType(XBUP_BLOCKREV_CATALOGPATH));
        if (serial.getSerializationMode() == XBSerializationMode.PULL) {
            this.setNaturalInt(serial.pullByteAttribute());
        } else {
            serial.putAttribute(this.value ? 1 : 0);
        }
        serial.end();
    }

    @Override
    public void setNaturalZero() {
        this.value = false;
    }

    @Override
    public void setNaturalInt(int intValue) throws UBOverFlowException {
        if (intValue < 0 || intValue > 1) {
            throw new UBOverFlowException("Value must be in range 0..1 for boolean");
        }
    }

    @Override
    public void setNaturalLong(long longValue) throws UBOverFlowException {
        if (longValue < 0L || longValue > 1L) {
            throw new UBOverFlowException("Value must be in range 0..1 for boolean");
        }
    }

    @Override
    public boolean isNaturalZero() {
        return !this.value;
    }

    @Override
    public int getNaturalInt() throws UBOverFlowException {
        return this.value ? 1 : 0;
    }

    @Override
    public long getNaturalLong() throws UBOverFlowException {
        return this.value ? 1L : 0L;
    }

    @Override
    public void convertFromNatural(@Nonnull UBNatural natural) {
        this.setNaturalInt(natural.getInt());
    }

    @Override
    @Nonnull
    public UBNatural convertToNatural() {
        return new UBNat32(this.getNaturalInt());
    }
}

