/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.child.XBChildInputSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildOutputSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildSerializable;
import org.exbin.xbup.core.serial.child.XBTChildInputSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildOutputSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildSerializable;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.util.StreamUtils;

@ParametersAreNonnullByDefault
public class XBText
implements XBPSequenceSerializable {
    private String value;
    static long[] XBUP_BLOCKREV_CATALOGPATH = new long[]{1L, 3L, 1L, 2L, 3L, 0L};

    public XBText() {
        this.value = "";
    }

    public XBText(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType(new XBDeclBlockType(XBUP_BLOCKREV_CATALOGPATH));
        serial.consist(new DataBlockSerializator());
        serial.end();
    }

    @ParametersAreNonnullByDefault
    public class DataBlockSerializator
    implements XBChildSerializable,
    XBTChildSerializable {
        @Override
        public void serializeFromXB(XBChildInputSerialHandler serial) throws XBProcessingException, IOException {
            serial.begin();
            InputStream source = serial.nextData();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                StreamUtils.copyInputStreamToOutputStream(source, stream);
            }
            catch (IOException ex) {
                Logger.getLogger(XBText.class.getName()).log(Level.SEVERE, null, ex);
            }
            XBText.this.setValue(new String(stream.toByteArray(), Charset.forName("UTF-8")));
            serial.end();
        }

        @Override
        public void serializeToXB(XBChildOutputSerialHandler serial) throws XBProcessingException, IOException {
            serial.begin(XBBlockTerminationMode.SIZE_SPECIFIED);
            if (XBText.this.getValue() != null) {
                serial.addData(new ByteArrayInputStream(XBText.this.getValue().getBytes(Charset.forName("UTF-8"))));
            } else {
                serial.addData(new ByteArrayInputStream(new byte[0]));
            }
            serial.end();
        }

        @Override
        public void serializeFromXB(XBTChildInputSerialHandler serial) throws XBProcessingException, IOException {
            serial.pullBegin();
            InputStream source = serial.pullData();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                StreamUtils.copyInputStreamToOutputStream(source, stream);
            }
            catch (IOException ex) {
                Logger.getLogger(XBText.class.getName()).log(Level.SEVERE, null, ex);
            }
            XBText.this.setValue(new String(stream.toByteArray(), Charset.forName("UTF-8")));
            serial.pullEnd();
        }

        @Override
        public void serializeToXB(XBTChildOutputSerialHandler serial) throws XBProcessingException, IOException {
            serial.putBegin(XBBlockTerminationMode.SIZE_SPECIFIED);
            if (XBText.this.getValue() != null) {
                serial.putData(new ByteArrayInputStream(XBText.this.getValue().getBytes(Charset.forName("UTF-8"))));
            } else {
                serial.putData(new ByteArrayInputStream(new byte[0]));
            }
            serial.putEnd();
        }
    }
}

