/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.util.StreamUtils;

@ParametersAreNonnullByDefault
public class XBOffsetBlockData
implements BinaryData {
    private final BinaryData blockData;
    private final long offset;

    public XBOffsetBlockData(BinaryData blockData, long offset) {
        this.blockData = blockData;
        this.offset = offset;
    }

    public boolean isEmpty() {
        return this.blockData.getDataSize() <= this.offset;
    }

    public long getDataSize() {
        return this.isEmpty() ? 0L : this.blockData.getDataSize() - this.offset;
    }

    public byte getByte(long position) {
        return this.blockData.getByte(position - this.offset);
    }

    public BinaryData copy() {
        return this.blockData.copy(this.offset, this.blockData.getDataSize() - this.offset);
    }

    public BinaryData copy(long startFrom, long length) {
        return this.blockData.copy(this.offset + startFrom, this.blockData.getDataSize() - startFrom - this.offset);
    }

    public void copyToArray(long l, byte[] bytes, int i, int i1) {
        this.blockData.copyToArray(l, bytes, i, i1);
    }

    public InputStream getDataInputStream() {
        final InputStream parentStream = this.blockData.getDataInputStream();
        try {
            parentStream.skip(this.offset);
        }
        catch (IOException ex) {
            Logger.getLogger(XBOffsetBlockData.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return parentStream.read();
            }

            @Override
            public void close() throws IOException {
                parentStream.close();
            }

            @Override
            public int available() throws IOException {
                return parentStream.available();
            }

            @Override
            public long skip(long n) throws IOException {
                return parentStream.skip(n);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return parentStream.read(b, off, len);
            }

            @Override
            public int read(byte[] b) throws IOException {
                return parentStream.read(b);
            }
        };
    }

    public void saveToStream(OutputStream outputStream) throws IOException {
        InputStream inputStream = this.getDataInputStream();
        StreamUtils.copyInputStreamToOutputStream(inputStream, outputStream);
    }

    public void dispose() {
        this.blockData.dispose();
    }
}

