/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.serial;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBTPullProviderToProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBToXBTPullUnknownConvertor;
import org.exbin.xbup.core.serial.XBSerialReader;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.XBTReadSerialHandler;
import org.exbin.xbup.core.serial.basic.XBTBasicSerializable;
import org.exbin.xbup.core.serial.basic.XBTProviderSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildProviderSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildSerializable;
import org.exbin.xbup.core.serial.token.XBTPullProviderSerialHandler;
import org.exbin.xbup.core.serial.token.XBTTokenSerializable;

@ParametersAreNonnullByDefault
public class XBTSerialReader
implements XBTReadSerialHandler {
    protected final XBTPullProvider pullProvider;

    public XBTSerialReader(XBTPullProvider pullProvider) {
        this.pullProvider = pullProvider;
    }

    @Override
    public void read(XBSerializable serial) {
        if (serial instanceof XBTBasicSerializable) {
            XBTProviderSerialHandler listenerHandler = new XBTProviderSerialHandler();
            listenerHandler.attachXBTProvider(new XBTPullProviderToProvider(this.pullProvider));
            try {
                ((XBTBasicSerializable)serial).serializeFromXB(listenerHandler);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBSerialReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (serial instanceof XBTTokenSerializable) {
            XBTPullProviderSerialHandler listenerHandler = new XBTPullProviderSerialHandler();
            listenerHandler.attachXBTPullProvider(this.pullProvider);
            try {
                ((XBTTokenSerializable)serial).serializeFromXB(listenerHandler);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBSerialReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (serial instanceof XBTChildSerializable) {
            XBTChildProviderSerialHandler childOutput = new XBTChildProviderSerialHandler(this);
            childOutput.attachXBTPullProvider(this.pullProvider);
            try {
                ((XBTChildSerializable)serial).serializeFromXB(childOutput);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBTSerialReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (XBSerialReader.isValidSerializableObject(serial)) {
            XBToXBTPullUnknownConvertor pullWrapper = new XBToXBTPullUnknownConvertor(this.pullProvider);
            XBSerialReader serialReader = new XBSerialReader(pullWrapper);
            serialReader.read(serial);
        } else {
            throw new UnsupportedOperationException("Serialization method " + serial.getClass().getCanonicalName() + " not supported.");
        }
    }

    public static boolean isValidSerializableObject(XBSerializable serial) {
        return serial instanceof XBTBasicSerializable || serial instanceof XBTTokenSerializable || serial instanceof XBTChildSerializable || XBSerialReader.isValidSerializableObject(serial);
    }
}

