/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.serial;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBPullProviderToProvider;
import org.exbin.xbup.core.serial.XBReadSerialHandler;
import org.exbin.xbup.core.serial.XBSerialWriter;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.basic.XBBasicSerializable;
import org.exbin.xbup.core.serial.basic.XBProviderSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildProviderSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildSerializable;
import org.exbin.xbup.core.serial.token.XBPullProviderSerialHandler;
import org.exbin.xbup.core.serial.token.XBTokenSerializable;

@ParametersAreNonnullByDefault
public class XBSerialReader
implements XBReadSerialHandler {
    private final XBPullProvider pullProvider;

    public XBSerialReader(XBPullProvider pullProvider) {
        this.pullProvider = pullProvider;
    }

    @Override
    public void read(XBSerializable serial) {
        if (serial instanceof XBBasicSerializable) {
            XBProviderSerialHandler providerHandler = new XBProviderSerialHandler();
            providerHandler.attachXBProvider(new XBPullProviderToProvider(this.pullProvider));
            try {
                ((XBBasicSerializable)serial).serializeFromXB(providerHandler);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBSerialWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (serial instanceof XBTokenSerializable) {
            XBPullProviderSerialHandler providerHandler = new XBPullProviderSerialHandler();
            providerHandler.attachXBPullProvider(this.pullProvider);
            try {
                ((XBTokenSerializable)serial).serializeFromXB(providerHandler);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBSerialWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (serial instanceof XBChildSerializable) {
            XBChildProviderSerialHandler childOutput = new XBChildProviderSerialHandler(this);
            childOutput.attachXBPullProvider(this.pullProvider);
            try {
                ((XBChildSerializable)serial).serializeFromXB(childOutput);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBSerialWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            throw new UnsupportedOperationException("Serialization method " + serial.getClass().getCanonicalName() + " not supported.");
        }
    }

    public static boolean isValidSerializableObject(XBSerializable serial) {
        return serial instanceof XBBasicSerializable || serial instanceof XBTokenSerializable || serial instanceof XBChildSerializable;
    }
}

