/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.pull.convert;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBFBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBEndToken;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.parser.token.pull.XBTPullConsumer;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;

@ParametersAreNonnullByDefault
public class XBTToXBPullConvertor
implements XBTPullConsumer,
XBPullProvider {
    @Nullable
    private XBTPullProvider pullProvider;
    @Nullable
    private XBToken buffer;

    @Override
    public void attachXBTPullProvider(XBTPullProvider pullProvider) {
        this.pullProvider = pullProvider;
        this.buffer = null;
    }

    @Override
    @Nonnull
    public XBToken pullXBToken() throws XBProcessingException, IOException {
        if (this.buffer != null) {
            XBToken token = this.buffer;
            this.buffer = null;
            return token;
        }
        XBTToken token = this.pullProvider.pullXBTToken();
        switch (token.getTokenType()) {
            case BEGIN: {
                return XBBeginToken.create(((XBTBeginToken)token).getTerminationMode());
            }
            case TYPE: {
                if (((XBTTypeToken)token).getBlockType() instanceof XBFBlockType) {
                    this.buffer = XBAttributeToken.create(((XBFBlockType)((XBTTypeToken)token).getBlockType()).getBlockID());
                    return XBAttributeToken.create(((XBFBlockType)((XBTTypeToken)token).getBlockType()).getGroupID());
                }
                throw new XBProcessingException("Unexpected block type", XBProcessingExceptionType.BLOCK_TYPE_MISMATCH);
            }
            case ATTRIBUTE: {
                return XBAttributeToken.create(((XBTAttributeToken)token).getAttribute());
            }
            case DATA: {
                return XBDataToken.create(((XBTDataToken)token).getData());
            }
            case END: {
                return XBEndToken.create();
            }
        }
        throw new XBProcessingException("Unexpected token type", XBProcessingExceptionType.UNKNOWN);
    }
}

