/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.pull.convert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;
import org.exbin.xbup.core.parser.token.pull.XBTPullFilter;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.util.StreamUtils;

@ParametersAreNonnullByDefault
public class XBTPullPreLoader
implements XBTPullFilter {
    private XBTToken nextToken;
    private int depth = 0;
    private XBTPullProvider pullProvider;
    private List<XBTToken> prefixBuffer = null;

    public XBTPullPreLoader(XBTPullProvider pullProvider) {
        this.attachProvider(pullProvider);
    }

    @Override
    public void attachXBTPullProvider(XBTPullProvider pullProvider) {
        this.attachProvider(pullProvider);
    }

    private void attachProvider(XBTPullProvider pullProvider) {
        this.pullProvider = pullProvider;
        try {
            this.nextToken = pullProvider.pullXBTToken();
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBTPullPreLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    @Nonnull
    public XBTToken pullXBTToken() throws XBProcessingException, IOException {
        if (this.prefixBuffer != null) {
            if (!this.prefixBuffer.isEmpty()) {
                return this.prefixBuffer.remove(0);
            }
            this.prefixBuffer = null;
        }
        XBTToken returnToken = this.nextToken;
        switch (this.nextToken.getTokenType()) {
            case BEGIN: {
                ++this.depth;
                break;
            }
            case END: {
                --this.depth;
            }
        }
        if (this.depth > 0) {
            this.nextToken = this.pullProvider.pullXBTToken();
            if (this.nextToken.getTokenType() == XBTTokenType.DATA) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                StreamUtils.copyInputStreamToOutputStream(((XBTDataToken)this.nextToken).getData(), stream);
                this.nextToken = XBTDataToken.create(new ByteArrayInputStream(stream.toByteArray()));
            }
        }
        return returnToken;
    }

    @Nullable
    public XBTToken getNextToken() {
        return this.nextToken;
    }

    @Nullable
    public XBTTokenType getNextTokenType() {
        return this.nextToken != null ? this.nextToken.getTokenType() : null;
    }

    public List<XBTToken> getPrefixBuffer() {
        return this.prefixBuffer;
    }

    public void setPrefixBuffer(List<XBTToken> prefixBuffer) {
        this.prefixBuffer = prefixBuffer;
    }

    public void skipAttributes() throws XBProcessingException, IOException {
        while (this.getNextTokenType() == XBTTokenType.ATTRIBUTE) {
            this.pullXBTToken();
        }
    }

    public void skipChildren() throws XBProcessingException, IOException {
        while (this.getNextTokenType() == XBTTokenType.BEGIN) {
            this.skipChild();
        }
    }

    public void skipChild() throws XBProcessingException, IOException {
        int subDepth = 0;
        do {
            XBTToken token = this.pullXBTToken();
            switch (token.getTokenType()) {
                case BEGIN: {
                    ++subDepth;
                    break;
                }
                case END: {
                    --subDepth;
                }
            }
        } while (subDepth > 0);
    }
}

