/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.pull.convert;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.pull.XBTPullFilter;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;

@ParametersAreNonnullByDefault
public class XBTPrintPullFilter
implements XBTPullFilter {
    @Nonnull
    private XBTPullProvider pullProvider;
    @Nonnull
    private String prefix = "";

    public XBTPrintPullFilter(String prefix, XBTPullProvider pullProvider) {
        this(pullProvider);
        this.prefix = prefix;
    }

    public XBTPrintPullFilter(XBTPullProvider pullProvider) {
        this.pullProvider = pullProvider;
    }

    @Override
    @Nonnull
    public XBTToken pullXBTToken() throws XBProcessingException, IOException {
        XBTToken token = this.pullProvider.pullXBTToken();
        switch (token.getTokenType()) {
            case BEGIN: {
                System.out.println(this.prefix + "> Begin (" + ((XBTBeginToken)token).getTerminationMode().toString() + "):");
                break;
            }
            case TYPE: {
                XBBlockType blockType = ((XBTTypeToken)token).getBlockType();
                System.out.println(this.prefix + "  Type: " + (blockType instanceof XBFixedBlockType ? "(" + ((XBFixedBlockType)blockType).getGroupID().getInt() + "," + ((XBFixedBlockType)blockType).getBlockID().getInt() + ")" : blockType.getClass().getCanonicalName()));
                break;
            }
            case ATTRIBUTE: {
                System.out.println(this.prefix + "  Attribute: " + ((XBTAttributeToken)token).getAttribute().getNaturalLong());
                break;
            }
            case DATA: {
                System.out.println(this.prefix + "  Data:" + ((XBTDataToken)token).getData().available());
                break;
            }
            case END: {
                System.out.println(this.prefix + "< End.");
                break;
            }
            default: {
                throw new XBProcessingException("Unexpected token type", XBProcessingExceptionType.UNKNOWN);
            }
        }
        return token;
    }

    @Override
    public void attachXBTPullProvider(XBTPullProvider pullProvider) {
        this.pullProvider = pullProvider;
    }
}

