/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.convert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.basic.wrapper.TerminatedDataOutputStreamWrapper;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.ubnumber.type.UBENat32;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.core.util.StreamUtils;

@ParametersAreNonnullByDefault
public class XBTokenBuffer
implements XBEventListener {
    private static final int BUFFER_SIZE = 1024;
    private final List<XBToken> tokenList = new ArrayList<XBToken>();
    private final List<List<BlockSize>> blockSizes = new LinkedList<List<BlockSize>>();

    public void write(OutputStream stream) throws IOException {
        this.precomputeBufferBlockSizes();
        this.writePrecomputedBlocks(stream);
    }

    private void precomputeBufferBlockSizes() throws IOException {
        int countingLevel = 0;
        ArrayList<BlockSize> bufferLevelSizes = new ArrayList<BlockSize>();
        ArrayList<XBBlockTerminationMode> bufferLevelType = new ArrayList<XBBlockTerminationMode>();
        block6: for (int bufferTokenIndex = 0; bufferTokenIndex < this.tokenList.size(); ++bufferTokenIndex) {
            XBToken bufferToken = this.tokenList.get(bufferTokenIndex);
            switch (bufferToken.getTokenType()) {
                case BEGIN: {
                    bufferLevelSizes.add(new BlockSize());
                    bufferLevelType.add(((XBBeginToken)bufferToken).getTerminationMode());
                    ++countingLevel;
                    continue block6;
                }
                case ATTRIBUTE: {
                    this.addBufferLevelAttributePartSize(bufferLevelSizes, ((XBAttributeToken)bufferToken).getAttribute().getSizeUB());
                    continue block6;
                }
                case DATA: {
                    int dataPartSize;
                    InputStream data = ((XBDataToken)bufferToken).getData();
                    ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
                    XBBlockTerminationMode terminationMode = (XBBlockTerminationMode)((Object)bufferLevelType.get(countingLevel - 1));
                    if (terminationMode == XBBlockTerminationMode.TERMINATED_BY_ZERO) {
                        dataPartSize = XBTokenBuffer.copyStreamAndComputeAdjustedSize(data, dataStream) - 1;
                    } else {
                        StreamUtils.copyInputStreamToOutputStream(data, dataStream);
                        dataPartSize = dataStream.size();
                    }
                    XBDataToken copiedToken = XBDataToken.create(new ByteArrayInputStream(dataStream.toByteArray()));
                    this.tokenList.set(bufferTokenIndex, copiedToken);
                    this.addBufferLevelDataPartSize(bufferLevelSizes, dataPartSize);
                    continue block6;
                }
                case END: {
                    BlockSize blockSize = (BlockSize)bufferLevelSizes.remove(--countingLevel);
                    while (this.blockSizes.size() <= countingLevel) {
                        this.blockSizes.add(new ArrayList());
                    }
                    this.blockSizes.get(countingLevel).add(blockSize);
                    if (countingLevel <= 0) continue block6;
                    UBNat32 attributePartSize = new UBNat32(blockSize.attributePartSize);
                    this.addBufferLevelDataPartSize(bufferLevelSizes, attributePartSize.getSizeUB());
                    XBBlockTerminationMode terminationMode = (XBBlockTerminationMode)((Object)bufferLevelType.remove(countingLevel));
                    if (terminationMode == XBBlockTerminationMode.SIZE_SPECIFIED) {
                        UBENat32 dataPartSize = new UBENat32(blockSize.dataPartSize);
                        this.addBufferLevelDataPartSize(bufferLevelSizes, dataPartSize.getSizeUB());
                        continue block6;
                    }
                    this.addBufferLevelDataPartSize(bufferLevelSizes, 2);
                }
            }
        }
    }

    private void writePrecomputedBlocks(OutputStream stream) throws IOException {
        ArrayList<XBBlockTerminationMode> bufferLevelType = new ArrayList<XBBlockTerminationMode>();
        XBBlockDataMode dataMode = null;
        int level = 0;
        for (XBToken bufferToken : this.tokenList) {
            switch (bufferToken.getTokenType()) {
                case BEGIN: {
                    BlockSize blockSize = this.blockSizes.get(level).remove(0);
                    ++level;
                    dataMode = null;
                    UBENat32 dataPartSize = new UBENat32();
                    bufferLevelType.add(((XBBeginToken)bufferToken).getTerminationMode());
                    if (((XBBeginToken)bufferToken).getTerminationMode() == XBBlockTerminationMode.TERMINATED_BY_ZERO) {
                        dataPartSize.setInfinity();
                    } else {
                        dataPartSize.setValue(blockSize.dataPartSize);
                    }
                    UBNat32 attributePartSize = new UBNat32(blockSize.attributePartSize + dataPartSize.getSizeUB());
                    attributePartSize.toStreamUB(stream);
                    dataPartSize.toStreamUB(stream);
                    break;
                }
                case ATTRIBUTE: {
                    dataMode = XBBlockDataMode.NODE_BLOCK;
                    ((XBAttributeToken)bufferToken).getAttribute().toStreamUB(stream);
                    break;
                }
                case DATA: {
                    OutputStream streamWrapper;
                    dataMode = XBBlockDataMode.DATA_BLOCK;
                    XBBlockTerminationMode terminationMode = (XBBlockTerminationMode)((Object)bufferLevelType.get(bufferLevelType.size() - 1));
                    if (terminationMode == XBBlockTerminationMode.TERMINATED_BY_ZERO) {
                        bufferLevelType.set(bufferLevelType.size() - 1, XBBlockTerminationMode.SIZE_SPECIFIED);
                        streamWrapper = new TerminatedDataOutputStreamWrapper(stream);
                    } else {
                        streamWrapper = stream;
                    }
                    StreamUtils.copyInputStreamToOutputStream(((XBDataToken)bufferToken).getData(), streamWrapper);
                    if (terminationMode != XBBlockTerminationMode.TERMINATED_BY_ZERO) break;
                    ((TerminatedDataOutputStreamWrapper)streamWrapper).finish();
                    break;
                }
                case END: {
                    XBBlockTerminationMode terminationMode = (XBBlockTerminationMode)((Object)bufferLevelType.remove(bufferLevelType.size() - 1));
                    if (dataMode == XBBlockDataMode.NODE_BLOCK && terminationMode == XBBlockTerminationMode.TERMINATED_BY_ZERO) {
                        stream.write(0);
                    }
                    dataMode = XBBlockDataMode.NODE_BLOCK;
                    --level;
                    break;
                }
            }
        }
        this.tokenList.clear();
        this.blockSizes.clear();
    }

    @Override
    public void putXBToken(XBToken token) {
        this.tokenList.add(token);
    }

    private void addBufferLevelAttributePartSize(List<BlockSize> blockSizes, int attributeSize) {
        for (int level = 0; level < blockSizes.size(); ++level) {
            BlockSize bufferLevelSize = blockSizes.get(level);
            if (level < blockSizes.size() - 1) {
                bufferLevelSize.dataPartSize += attributeSize;
                continue;
            }
            bufferLevelSize.attributePartSize += attributeSize;
        }
    }

    private void addBufferLevelDataPartSize(List<BlockSize> blockSizes, int dataSize) {
        for (BlockSize bufferLevelSize : blockSizes) {
            bufferLevelSize.dataPartSize += dataSize;
        }
    }

    public static int computeAdjustedSize(InputStream source) throws IOException {
        return XBTokenBuffer.copyStreamAndComputeAdjustedSize(source, null);
    }

    public static int copyStreamAndComputeAdjustedSize(InputStream source, OutputStream target) throws IOException {
        int dataPartSize = 0;
        ZeroCounter zeroCounter = new ZeroCounter();
        byte[] buffer = new byte[1024];
        int used = 0;
        while (source.available() > 0) {
            int read;
            if ((used += (read = source.read(buffer, used, 1024 - used))) != 1024) continue;
            dataPartSize += XBTokenBuffer.computeAdjustedSize(buffer, 1024, zeroCounter);
            if (target != null) {
                target.write(buffer, 0, 1024);
            }
            used = 0;
        }
        if (used > 0) {
            dataPartSize += XBTokenBuffer.computeAdjustedSize(buffer, used, zeroCounter);
            if (target != null) {
                target.write(buffer, 0, used);
            }
        }
        return dataPartSize + (zeroCounter.zeroCount > 0 ? 3 : 2);
    }

    private static int computeAdjustedSize(byte[] buffer, int size, ZeroCounter zeroCounter) {
        int dataPartSize = 0;
        for (int i = 0; i < size; ++i) {
            byte data = buffer[i];
            if (data == 0) {
                if (zeroCounter.zeroCount < 254) {
                    ++zeroCounter.zeroCount;
                    continue;
                }
                dataPartSize += 2;
                zeroCounter.zeroCount = 0;
                continue;
            }
            if (zeroCounter.zeroCount > 0) {
                dataPartSize += 2;
                zeroCounter.zeroCount = 0;
            }
            ++dataPartSize;
        }
        return dataPartSize;
    }

    private static class BlockSize {
        int attributePartSize = 0;
        int dataPartSize = 0;

        private BlockSize() {
        }
    }

    private static class ZeroCounter {
        int zeroCount;

        private ZeroCounter() {
        }
    }
}

