/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBParserMode;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBConsumer;
import org.exbin.xbup.core.parser.basic.XBHead;
import org.exbin.xbup.core.parser.basic.XBProvider;
import org.exbin.xbup.core.parser.basic.wrapper.FixedDataOutputStreamWrapper;
import org.exbin.xbup.core.parser.basic.wrapper.TerminatedDataOutputStreamWrapper;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBEndToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.XBTokenType;
import org.exbin.xbup.core.parser.token.convert.XBListenerToToken;
import org.exbin.xbup.core.parser.token.convert.XBTokenBuffer;
import org.exbin.xbup.core.stream.FinishableStream;
import org.exbin.xbup.core.ubnumber.type.UBENat32;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.core.util.StreamUtils;

public class XBSConsumerWriter
implements Closeable,
XBConsumer {
    private XBParserMode parserMode = XBParserMode.FULL;
    private OutputStream stream;
    private XBProvider provider;
    private XBListenerToToken tokenListener = new XBListenerToToken();

    public XBSConsumerWriter() {
    }

    public XBSConsumerWriter(OutputStream outputStream) throws IOException {
        this();
        this.openStream(outputStream);
    }

    public XBSConsumerWriter(OutputStream outputStream, XBParserMode parserMode) throws IOException {
        this();
        this.parserMode = parserMode;
        this.openStream(outputStream);
    }

    private void openStream(OutputStream outputStream) throws IOException {
        this.stream = outputStream;
    }

    public void open(OutputStream outputStream) throws IOException {
        this.openStream(outputStream);
    }

    public void write() throws XBProcessingException, IOException {
        ArrayList<Integer> sizeLimits = new ArrayList<Integer>();
        XBTokenBuffer tokenBuffer = new XBTokenBuffer();
        ArrayList<XBAttribute> attributeList = new ArrayList<XBAttribute>();
        XBBlockDataMode dataMode = null;
        int bufferedFromLevel = -1;
        int depthLevel = 0;
        if (this.parserMode != XBParserMode.SINGLE_BLOCK && this.parserMode != XBParserMode.SKIP_HEAD) {
            XBHead.writeXBUPHead(this.stream);
        }
        XBToken token = this.pullToken();
        block8: do {
            switch (token.getTokenType()) {
                case BEGIN: {
                    ++depthLevel;
                    dataMode = null;
                    XBBlockTerminationMode terminationMode = ((XBBeginToken)token).getTerminationMode();
                    if (bufferedFromLevel >= 0) {
                        tokenBuffer.putXBToken(token);
                        sizeLimits.add(null);
                    } else if (terminationMode == XBBlockTerminationMode.SIZE_SPECIFIED) {
                        bufferedFromLevel = depthLevel;
                        tokenBuffer.putXBToken(token);
                        sizeLimits.add(null);
                    } else {
                        sizeLimits.add(null);
                    }
                    token = this.pullToken();
                    switch (token.getTokenType()) {
                        case DATA: {
                            dataMode = XBBlockDataMode.DATA_BLOCK;
                            if (bufferedFromLevel >= 0) {
                                tokenBuffer.putXBToken(token);
                            } else {
                                InputStream data = ((XBDataToken)token).getData();
                                if (terminationMode == XBBlockTerminationMode.SIZE_SPECIFIED) {
                                    FixedDataOutputStreamWrapper streamWrapper = new FixedDataOutputStreamWrapper(this.stream, 0);
                                    StreamUtils.copyInputStreamToOutputStream(data, streamWrapper);
                                    int dataSize = (int)((FinishableStream)streamWrapper).finish();
                                    XBSConsumerWriter.shrinkStatus(sizeLimits, dataSize);
                                } else {
                                    UBNat32 attributePartSize = new UBNat32(1);
                                    attributePartSize.toStreamUB(this.stream);
                                    UBENat32 dataPartSize = new UBENat32();
                                    dataPartSize.setInfinity();
                                    dataPartSize.toStreamUB(this.stream);
                                    XBSConsumerWriter.shrinkStatus(sizeLimits, 2);
                                    TerminatedDataOutputStreamWrapper streamWrapper = new TerminatedDataOutputStreamWrapper(this.stream);
                                    StreamUtils.copyInputStreamToOutputStream(data, streamWrapper);
                                    int dataSize = (int)((FinishableStream)streamWrapper).finish();
                                    XBSConsumerWriter.shrinkStatus(sizeLimits, dataSize);
                                }
                            }
                            token = this.pullToken();
                            if (depthLevel == 1 && token.getTokenType() == XBTokenType.DATA) {
                                if (this.parserMode != XBParserMode.SINGLE_BLOCK && this.parserMode != XBParserMode.SKIP_TAIL) {
                                    if (bufferedFromLevel >= 0) {
                                        tokenBuffer.putXBToken(XBEndToken.create());
                                        if (bufferedFromLevel == depthLevel) {
                                            tokenBuffer.write(this.stream);
                                            bufferedFromLevel = -1;
                                        }
                                    }
                                    --depthLevel;
                                    StreamUtils.copyInputStreamToOutputStream(((XBDataToken)token).getData(), this.stream);
                                    token = this.pullToken();
                                    if (token.getTokenType() != XBTokenType.END) {
                                        throw new XBParsingException("End token was expected after tail data", XBProcessingExceptionType.UNEXPECTED_ORDER);
                                    }
                                } else {
                                    throw new XBParsingException("Tail data present when not expected", XBProcessingExceptionType.UNEXPECTED_ORDER);
                                }
                            }
                            if (token.getTokenType() == XBTokenType.END) continue block8;
                            throw new XBParsingException("Data block must be followed by block end", XBProcessingExceptionType.UNEXPECTED_ORDER);
                        }
                        case ATTRIBUTE: {
                            attributeList.clear();
                            int attributePartSizeValue = 0;
                            do {
                                XBAttribute attribute = ((XBAttributeToken)token).getAttribute();
                                dataMode = XBBlockDataMode.NODE_BLOCK;
                                if (bufferedFromLevel >= 0) {
                                    tokenBuffer.putXBToken(token);
                                    continue;
                                }
                                int attributePartSize = attribute.getSizeUB();
                                XBSConsumerWriter.shrinkStatus(sizeLimits, attributePartSize);
                                attributePartSizeValue += attributePartSize;
                                attributeList.add(attribute);
                            } while ((token = this.pullToken()).getTokenType() == XBTokenType.ATTRIBUTE);
                            if (bufferedFromLevel < 0) {
                                UBNat32 attributePartSize = new UBNat32(++attributePartSizeValue);
                                XBSConsumerWriter.shrinkStatus(sizeLimits, attributePartSize.getSizeUB() + 1 + 1);
                                attributePartSize.toStreamUB(this.stream);
                                UBENat32 dataPartSize = new UBENat32();
                                dataPartSize.setInfinity();
                                dataPartSize.toStreamUB(this.stream);
                                for (XBAttribute attribute : attributeList) {
                                    attribute.toStreamUB(this.stream);
                                }
                                attributeList.clear();
                            }
                            if (depthLevel != 1 || token.getTokenType() != XBTokenType.DATA) continue block8;
                            if (this.parserMode != XBParserMode.SINGLE_BLOCK && this.parserMode != XBParserMode.SKIP_TAIL) {
                                if (bufferedFromLevel >= 0) {
                                    tokenBuffer.putXBToken(XBEndToken.create());
                                    if (bufferedFromLevel == depthLevel) {
                                        tokenBuffer.write(this.stream);
                                        bufferedFromLevel = -1;
                                    }
                                } else {
                                    if (dataMode == XBBlockDataMode.NODE_BLOCK && sizeLimits.get(depthLevel - 1) == null) {
                                        this.stream.write(0);
                                    }
                                    XBSConsumerWriter.decreaseStatus(sizeLimits);
                                }
                                --depthLevel;
                                StreamUtils.copyInputStreamToOutputStream(((XBDataToken)token).getData(), this.stream);
                                token = this.pullToken();
                                if (token.getTokenType() == XBTokenType.END) continue block8;
                                throw new XBParsingException("End token was expected after tail data", XBProcessingExceptionType.UNEXPECTED_ORDER);
                            }
                            throw new XBParsingException("Tail data present when not expected", XBProcessingExceptionType.UNEXPECTED_ORDER);
                        }
                        default: {
                            throw new XBParsingException("Missing at least one attribute", XBProcessingExceptionType.UNEXPECTED_ORDER);
                        }
                    }
                }
                case END: {
                    if (bufferedFromLevel >= 0) {
                        tokenBuffer.putXBToken(token);
                        if (bufferedFromLevel == depthLevel) {
                            tokenBuffer.write(this.stream);
                            bufferedFromLevel = -1;
                        }
                    } else {
                        if (dataMode == XBBlockDataMode.NODE_BLOCK && sizeLimits.get(depthLevel - 1) == null) {
                            this.stream.write(0);
                        }
                        XBSConsumerWriter.decreaseStatus(sizeLimits);
                    }
                    dataMode = XBBlockDataMode.NODE_BLOCK;
                    if (--depthLevel > 0) {
                        token = this.pullToken();
                    }
                    if (depthLevel != 1 || token.getTokenType() != XBTokenType.DATA) continue block8;
                    if (this.parserMode != XBParserMode.SINGLE_BLOCK && this.parserMode != XBParserMode.SKIP_TAIL) {
                        if (bufferedFromLevel >= 0) {
                            tokenBuffer.putXBToken(XBEndToken.create());
                            if (bufferedFromLevel == depthLevel) {
                                tokenBuffer.write(this.stream);
                                bufferedFromLevel = -1;
                            }
                        } else {
                            if (dataMode == XBBlockDataMode.NODE_BLOCK && sizeLimits.get(depthLevel - 1) == null) {
                                this.stream.write(0);
                            }
                            XBSConsumerWriter.decreaseStatus(sizeLimits);
                        }
                        dataMode = XBBlockDataMode.NODE_BLOCK;
                        --depthLevel;
                        StreamUtils.copyInputStreamToOutputStream(((XBDataToken)token).getData(), this.stream);
                        token = this.pullToken();
                        if (token.getTokenType() == XBTokenType.END) continue block8;
                        throw new XBParsingException("End token was expected after tail data", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    throw new XBParsingException("Tail data present when not expected", XBProcessingExceptionType.UNEXPECTED_ORDER);
                }
                default: {
                    throw new XBParsingException("Unexpected token order", XBProcessingExceptionType.UNEXPECTED_ORDER);
                }
            }
        } while (depthLevel > 0);
    }

    private XBToken pullToken() throws XBProcessingException, IOException {
        this.tokenListener.setToken(null);
        this.provider.produceXB(this.tokenListener);
        if (this.tokenListener.getToken() == null) {
            throw new XBParsingException("Unexpected end of stream", XBProcessingExceptionType.UNEXPECTED_END_OF_STREAM);
        }
        return this.tokenListener.getToken();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    private static void shrinkStatus(List<Integer> sizeLimits, int value) throws XBParsingException {
        for (int depth = 0; depth < sizeLimits.size(); ++depth) {
            Integer limit = sizeLimits.get(depth);
            if (limit == null) continue;
            if (limit < value) {
                throw new XBParsingException("Block overflow", XBProcessingExceptionType.BLOCK_OVERFLOW);
            }
            sizeLimits.set(depth, limit - value);
        }
    }

    private static void decreaseStatus(List<Integer> sizeLimits) {
        Integer levelValue = sizeLimits.remove(sizeLimits.size() - 1);
        if (levelValue != null && levelValue != 0) {
            throw new XBParsingException("Block overflow", XBProcessingExceptionType.BLOCK_OVERFLOW);
        }
    }

    @Override
    public void attachXBProvider(XBProvider provider) {
        this.provider = provider;
    }
}

