/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block.declaration.catalog;

import java.io.IOException;
import javax.annotation.Nullable;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.local.XBLBlockDecl;
import org.exbin.xbup.core.block.definition.XBBlockDef;
import org.exbin.xbup.core.block.definition.catalog.XBCBlockDef;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

public class XBCBlockDecl
implements XBBlockDecl,
XBPSequenceSerializable {
    private XBCBlockRev blockSpecRev;
    private final XBCatalog catalog;

    public XBCBlockDecl(XBCBlockRev blockSpecRev, XBCatalog catalog) {
        this.blockSpecRev = blockSpecRev;
        this.catalog = catalog;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof XBCBlockDecl) {
            XBCBlockDecl other = (XBCBlockDecl)obj;
            if (this.blockSpecRev == null || !this.blockSpecRev.equals(other.blockSpecRev)) {
                return false;
            }
            return this.blockSpecRev.getId() == other.blockSpecRev.getId();
        }
        if (obj instanceof XBLBlockDecl) {
            Long[] catalogPath = this.catalog.getSpecPath(this.getBlockSpecRev().getParent());
            long[] objCatalogPath = ((XBLBlockDecl)obj).getCatalogPath();
            if (objCatalogPath.length != catalogPath.length) {
                return false;
            }
            for (int pathIndex = 0; pathIndex < catalogPath.length; ++pathIndex) {
                if (catalogPath[pathIndex] == objCatalogPath[pathIndex]) continue;
                return false;
            }
            return this.blockSpecRev.getXBIndex() == ((XBLBlockDecl)obj).getRevision();
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.blockSpecRev != null ? this.blockSpecRev.hashCode() : 0);
        return hash;
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serializationHandler) throws XBProcessingException, IOException {
        serializationHandler.begin();
        serializationHandler.matchType(new XBFixedBlockType(XBBasicBlockType.BLOCK_DECLARATION));
        if (serializationHandler.getSerializationMode() == XBSerializationMode.PULL) {
            Long[] catalogPath = new Long[serializationHandler.pullIntAttribute()];
            for (int pathPosition = 0; pathPosition < catalogPath.length; ++pathPosition) {
                catalogPath[pathPosition] = serializationHandler.pullLongAttribute();
            }
            long revision = serializationHandler.pullLongAttribute();
            XBCBlockDecl blockDecl = (XBCBlockDecl)this.catalog.findBlockTypeByPath(catalogPath, (int)revision);
            this.blockSpecRev = blockDecl == null ? null : blockDecl.getBlockSpecRev();
        } else if (this.blockSpecRev != null) {
            Long[] path = this.catalog.getSpecPath(this.blockSpecRev.getParent());
            serializationHandler.putAttribute(path.length - 1);
            for (Long pathIndex : path) {
                serializationHandler.putAttribute(pathIndex);
            }
            serializationHandler.putAttribute(new UBNat32(this.blockSpecRev.getXBIndex()));
        }
        serializationHandler.end();
    }

    public XBCBlockRev getBlockSpecRev() {
        return this.blockSpecRev;
    }

    public void setBlockSpecRev(XBCBlockRev blockSpecRev) {
        this.blockSpecRev = blockSpecRev;
    }

    @Override
    public XBBlockDef getBlockDef() {
        return new XBCBlockDef(this.catalog, this.blockSpecRev.getParent());
    }

    @Override
    public long getRevision() {
        return this.blockSpecRev.getXBIndex();
    }
}

