/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block;

import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTDocument;

public class XBTDefaultDocument
implements XBTDocument {
    @Nonnull
    private final XBTBlock rootBlock;
    @Nullable
    private final BinaryData tailData;

    public XBTDefaultDocument(@Nonnull XBTBlock rootBlock) {
        this(rootBlock, null);
    }

    public XBTDefaultDocument(@Nonnull XBTBlock rootBlock, @Nullable BinaryData tailData) {
        this.rootBlock = rootBlock;
        this.tailData = tailData;
    }

    @Override
    @Nonnull
    public Optional<XBTBlock> getRootBlock() {
        return Optional.of(this.rootBlock);
    }

    @Override
    @Nonnull
    public Optional<InputStream> getTailData() {
        return this.tailData == null ? Optional.empty() : Optional.of(this.tailData.getDataInputStream());
    }

    @Override
    public long getTailDataSize() {
        return this.tailData == null ? 0L : this.tailData.getDataSize();
    }

    @Override
    public long getDocumentSize() {
        return -1L;
    }
}

