/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBEditableBlock;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.type.XBData;

@ParametersAreNonnullByDefault
public class XBDefaultEditableBlock
implements XBEditableBlock {
    @Nullable
    private XBBlock parent;
    @Nonnull
    private XBBlockDataMode dataMode;
    @Nonnull
    private XBBlockTerminationMode terminationMode;
    @Nullable
    private List<XBAttribute> attributes;
    @Nullable
    private List<XBBlock> children;
    @Nullable
    private BinaryData data;

    public XBDefaultEditableBlock() {
        this(null, XBBlockTerminationMode.SIZE_SPECIFIED, null);
    }

    public XBDefaultEditableBlock(@Nullable XBBlock parent, XBBlockTerminationMode terminationMode, @Nullable BinaryData data) {
        this.dataMode = XBBlockDataMode.DATA_BLOCK;
        this.parent = parent;
        this.terminationMode = terminationMode;
        this.data = data;
    }

    public XBDefaultEditableBlock(XBBlockTerminationMode terminationMode, @Nullable BinaryData data) {
        this(null, terminationMode, data);
    }

    public XBDefaultEditableBlock(@Nullable XBBlock parent, @Nullable XBBlockTerminationMode terminationMode, @Nullable XBAttribute[] attributes, @Nullable XBBlock[] children) {
        this.dataMode = XBBlockDataMode.NODE_BLOCK;
        this.parent = parent;
        XBBlockTerminationMode xBBlockTerminationMode = this.terminationMode = terminationMode == null ? XBBlockTerminationMode.SIZE_SPECIFIED : terminationMode;
        if (attributes != null) {
            ArrayList<XBAttribute> blockAttributes = new ArrayList<XBAttribute>();
            blockAttributes.addAll(Arrays.asList(attributes));
            this.attributes = blockAttributes;
        }
        if (children != null) {
            ArrayList<XBBlock> blockChildren = new ArrayList<XBBlock>();
            blockChildren.addAll(Arrays.asList(children));
            this.children = blockChildren;
        }
        if (children != null) {
            this.attachChildren(children);
        }
    }

    public XBDefaultEditableBlock(@Nonnull XBBlockTerminationMode terminationMode, @Nullable XBAttribute[] attributes, @Nullable XBBlock[] children) {
        this(null, terminationMode, attributes, children);
    }

    private void attachChildren(@Nonnull XBBlock[] children) {
        for (XBBlock child : children) {
            if (child instanceof XBDefaultEditableBlock) {
                ((XBDefaultEditableBlock)child).setParent(this);
                continue;
            }
            if (!(child instanceof XBEditableBlock)) continue;
            ((XBEditableBlock)child).setParent(this);
        }
    }

    @Override
    @Nonnull
    public Optional<XBBlock> getParentBlock() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public void setParent(@Nullable XBBlock parent) {
        this.parent = parent;
    }

    @Override
    @Nonnull
    public XBBlockDataMode getDataMode() {
        return this.dataMode;
    }

    @Override
    @Nonnull
    public XBBlockTerminationMode getTerminationMode() {
        return this.terminationMode;
    }

    @Override
    @Nullable
    public XBAttribute[] getAttributes() {
        return this.attributes.toArray(new XBAttribute[0]);
    }

    @Override
    @Nullable
    public XBAttribute getAttributeAt(int attributeIndex) {
        return attributeIndex < this.attributes.size() ? this.attributes.get(attributeIndex) : null;
    }

    @Override
    public int getAttributesCount() {
        return this.attributes.size();
    }

    @Override
    @Nullable
    public XBBlock[] getChildren() {
        return this.children == null ? null : this.children.toArray(new XBBlock[0]);
    }

    @Override
    @Nullable
    public XBBlock getChildAt(int childIndex) {
        return childIndex < this.children.size() ? this.children.get(childIndex) : null;
    }

    @Override
    public int getChildrenCount() {
        return this.children != null ? this.children.size() : 0;
    }

    @Override
    @Nonnull
    public InputStream getData() {
        return this.data.getDataInputStream();
    }

    @Override
    @Nonnull
    public BinaryData getBlockData() {
        return Objects.requireNonNull(this.data);
    }

    public long getDataSize() {
        return this.data == null ? 0L : this.data.getDataSize();
    }

    public static int getBlockIndex(@Nullable XBBlock block) {
        if (block == null) {
            return -1;
        }
        Optional<XBBlock> blockParent = block.getParentBlock();
        if (blockParent.isPresent()) {
            XBBlock child;
            int result = XBDefaultEditableBlock.getBlockIndex(blockParent.get()) + 1;
            int childIndex = 0;
            do {
                if (block.equals(child = blockParent.get().getChildAt(childIndex))) {
                    return result + childIndex;
                }
                ++childIndex;
            } while (child != null);
            return result;
        }
        return 0;
    }

    public static int getChildIndexOf(@Nullable XBBlock parent, @Nullable XBBlock block) {
        if (block == null || parent == null) {
            return -1;
        }
        int childIndex = 0;
        Optional<XBBlock> blockParent = block.getParentBlock();
        if (blockParent.isPresent()) {
            XBBlock child;
            do {
                if (block.equals(child = blockParent.get().getChildAt(childIndex))) {
                    return childIndex;
                }
                ++childIndex;
            } while (child != null);
        }
        return -1;
    }

    @Override
    public void setTerminationMode(XBBlockTerminationMode terminationMode) {
        this.terminationMode = terminationMode;
    }

    @Override
    public void setDataMode(XBBlockDataMode dataMode) {
        this.dataMode = dataMode;
    }

    @Override
    public void setAttributes(@Nullable XBAttribute[] attributes) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<XBAttribute>();
        } else {
            this.attributes.clear();
        }
        if (attributes != null) {
            this.attributes.addAll(Arrays.asList(attributes));
        }
    }

    @Override
    public void setAttributeAt(XBAttribute attribute, int attributeIndex) {
        if (attributeIndex >= this.attributes.size()) {
            this.setAttributesCount(attributeIndex + 1);
        }
        this.attributes.set(attributeIndex, attribute);
    }

    @Override
    public void setAttributesCount(int count) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeAttribute(int attributeIndex) {
        if (attributeIndex < this.attributes.size()) {
            this.attributes.remove(attributeIndex);
        }
    }

    @Override
    public void setChildren(XBBlock[] blocks) {
        List<XBBlock> resultChildren = this.children;
        if (resultChildren == null) {
            resultChildren = new ArrayList<XBBlock>();
        } else {
            resultChildren.clear();
        }
        resultChildren.addAll(Arrays.asList(blocks));
        this.children = resultChildren;
    }

    @Override
    public void setChildAt(XBBlock block, int childIndex) {
        if (childIndex >= this.children.size()) {
            this.setChildrenCount(childIndex + 1);
        }
        this.children.set(childIndex, block);
    }

    @Override
    public void setChildrenCount(int count) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public XBBlock createNewChild(int childIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeChild(int childIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setData(InputStream data) throws IOException {
        this.data = new XBData();
        ((XBData)this.data).loadFromStream(data);
    }

    @Override
    public void setData(BinaryData data) {
        this.data = data;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

