/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data.delta.list;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.OutOfBoundsException;
import org.exbin.auxiliary.binary_data.delta.list.DoublyLinkedItem;
import org.exbin.auxiliary.binary_data.delta.list.DoublyLinkedList;

@ParametersAreNonnullByDefault
public class DefaultDoublyLinkedList<T extends DoublyLinkedItem<T>>
implements DoublyLinkedList<T> {
    private T first;
    private T last;
    private int size = 0;

    @Override
    @Nullable
    public T first() {
        return this.first;
    }

    @Override
    @Nullable
    public T last() {
        return this.last;
    }

    @Override
    @Nullable
    public T nextTo(T item) {
        return (T)((DoublyLinkedItem)item.getNext());
    }

    @Override
    @Nullable
    public T prevTo(T item) {
        return (T)((DoublyLinkedItem)item.getPrev());
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    @Nullable
    public T get(int index) {
        T item = this.first;
        while (index > 0) {
            item = this.nextTo(item);
            --index;
        }
        return item;
    }

    @Override
    @Nonnull
    public T set(int index, T item) {
        T origItem = this.first;
        while (index > 0) {
            origItem = this.nextTo(origItem);
            --index;
        }
        if (origItem == null) {
            throw new OutOfBoundsException("No item for index " + index);
        }
        DoublyLinkedItem itemPrev = (DoublyLinkedItem)origItem.getPrev();
        DoublyLinkedItem itemNext = (DoublyLinkedItem)origItem.getNext();
        origItem.setNext(null);
        origItem.setPrev(null);
        item.setPrev((DoublyLinkedItem)itemPrev);
        item.setNext((DoublyLinkedItem)itemNext);
        if (this.last == origItem) {
            this.last = item;
        }
        return origItem;
    }

    @Override
    public boolean contains(Object item) {
        T checkedItem = this.first;
        while (checkedItem != null) {
            if (checkedItem.equals(item)) {
                return true;
            }
            checkedItem = this.nextTo(checkedItem);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> items) {
        for (Object item : items) {
            if (this.contains((DoublyLinkedItem)item)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private T current;
            {
                this.current = DefaultDoublyLinkedList.this.first;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public T next() {
                Object result = this.current;
                this.current = (DoublyLinkedItem)result.getNext();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        if (this.last == null) {
            return new Object[0];
        }
        int count = this.indexOf(this.last);
        Object[] result = new Object[count];
        int index = 0;
        T item = this.first;
        while (item != null) {
            result[index] = item;
            item = this.nextTo(item);
            ++index;
        }
        return result;
    }

    @Override
    @Nonnull
    public <X> X[] toArray(X[] template) {
        int count = this.last == null ? 0 : this.indexOf(this.last);
        X[] result = template.length >= count ? template : Arrays.copyOf(template, count);
        int index = 0;
        T item = this.first;
        while (item != null) {
            result[index] = item;
            item = this.nextTo(item);
            ++index;
        }
        return result;
    }

    @Override
    public boolean add(T item) {
        if (this.last != null) {
            this.last.setNext(item);
            item.setPrev(this.last);
            item.setNext(null);
            this.last = item;
        } else {
            this.first = item;
            this.last = item;
            item.setNext(null);
            item.setPrev(null);
        }
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, T item) {
        if (index == 0 && this.size == 0) {
            this.add((T)item);
            return;
        }
        if (index > this.size) {
            throw new OutOfBoundsException("Index " + index + " is greater than " + this.size);
        }
        if (index == this.size) {
            this.last.setNext(item);
            item.setPrev(this.last);
            item.setNext(null);
            this.last = item;
        } else if (index == 0) {
            this.first.setPrev(item);
            item.setNext(this.first);
            this.first = item;
        } else {
            DoublyLinkedItem indexItem = (DoublyLinkedItem)Objects.requireNonNull(this.get(index));
            DoublyLinkedItem prevItem = (DoublyLinkedItem)Objects.requireNonNull(indexItem.getPrev());
            item.setPrev((DoublyLinkedItem)prevItem);
            item.setNext((DoublyLinkedItem)indexItem);
            prevItem.setNext(item);
            indexItem.setPrev(item);
        }
        ++this.size;
    }

    public void addAfter(T listItem, T item) {
        DoublyLinkedItem listItemNext = (DoublyLinkedItem)listItem.getNext();
        if (listItemNext == null) {
            listItem.setNext(item);
            item.setPrev(listItem);
            item.setNext(null);
            this.last = item;
        } else {
            listItem.setNext(item);
            listItemNext.setPrev(item);
            item.setPrev(listItem);
            item.setNext((DoublyLinkedItem)listItemNext);
        }
        ++this.size;
    }

    public void addBefore(T targetItem, T item) {
        DoublyLinkedItem prev = (DoublyLinkedItem)targetItem.getPrev();
        if (prev == null) {
            targetItem.setPrev(item);
            item.setNext(targetItem);
            item.setPrev(null);
            this.first = item;
        } else {
            targetItem.setPrev(item);
            prev.setNext(item);
            item.setNext(targetItem);
            item.setPrev((DoublyLinkedItem)prev);
        }
        ++this.size;
    }

    @Override
    public boolean addAll(Collection<? extends T> elementsToAdd) {
        boolean result = false;
        for (DoublyLinkedItem element : elementsToAdd) {
            result |= this.add((T)element);
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        for (DoublyLinkedItem t : c) {
            this.add(index, (T)t);
            ++index;
        }
        return true;
    }

    @Override
    public int indexOf(Object searchedItem) {
        Object item = this.first;
        int index = 0;
        while (item != null) {
            if (item.equals(searchedItem)) {
                return index;
            }
            item = (DoublyLinkedItem)item.getNext();
            ++index;
        }
        return -1;
    }

    @Override
    @Nullable
    public T remove(int index) {
        Object item = this.get(index);
        if (item != null) {
            this.removeItem(item);
            return (T)item;
        }
        return null;
    }

    @Override
    public boolean remove(Object o) {
        DoublyLinkedItem item = (DoublyLinkedItem)o;
        if (item != null) {
            this.removeItem(item);
            return true;
        }
        return false;
    }

    private void removeItem(T item) {
        if (item == this.first) {
            DoublyLinkedItem itemNext = (DoublyLinkedItem)item.getNext();
            if (itemNext != null) {
                itemNext.setPrev(null);
            } else {
                this.last = null;
            }
            this.first = itemNext;
        } else {
            DoublyLinkedItem prev = (DoublyLinkedItem)Objects.requireNonNull(item.getPrev());
            DoublyLinkedItem next = (DoublyLinkedItem)item.getNext();
            prev.setNext(next);
            if (next != null) {
                next.setPrev(prev);
            } else {
                this.last = prev;
            }
        }
        --this.size;
        item.setPrev(null);
        item.setNext(null);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean result = false;
        for (Object item : collection) {
            DoublyLinkedItem itemList = (DoublyLinkedItem)item;
            result |= this.remove(itemList);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> retainList) {
        boolean changed = false;
        if (this.first == null) {
            return false;
        }
        Object item = this.first;
        do {
            if (!retainList.contains(item)) {
                changed = true;
                DoublyLinkedItem nextItem = (DoublyLinkedItem)item.getNext();
                this.removeItem(item);
                item = nextItem;
                continue;
            }
            item = (DoublyLinkedItem)item.getNext();
        } while (item != null);
        return changed;
    }

    @Override
    public void clear() {
        this.first = null;
        this.last = null;
        this.size = 0;
    }

    @Override
    public int lastIndexOf(Object searchedItem) {
        if (this.size > 0) {
            Object item = this.last;
            int index = this.size - 1;
            while (item != null) {
                if (item.equals(searchedItem)) {
                    return index;
                }
                item = (DoublyLinkedItem)item.getPrev();
                --index;
            }
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

