/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data.delta;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.delta.DeltaDataPageWindow;

@ParametersAreNonnullByDefault
public class FileDataSource {
    @Nonnull
    private final File file;
    @Nonnull
    private final RandomAccessFile accessFile;
    @Nonnull
    private final DeltaDataPageWindow window;
    private boolean closed = false;
    private final List<CacheClearListener> listeners = new ArrayList<CacheClearListener>();

    public FileDataSource(File sourceFile, EditMode editMode) throws FileNotFoundException, IOException {
        this.file = sourceFile;
        this.accessFile = new RandomAccessFile(sourceFile, editMode.getFileAccessMode());
        this.window = new DeltaDataPageWindow(this);
    }

    public FileDataSource(File sourceFile) throws FileNotFoundException, IOException {
        this(sourceFile, EditMode.READ_WRITE);
    }

    public long getFileLength() throws IOException {
        this.checkClosed();
        return this.accessFile.length();
    }

    public void setFileLength(long length) throws IOException {
        this.checkClosed();
        this.accessFile.setLength(length);
    }

    @Nonnull
    public File getFile() {
        return this.file;
    }

    @Nonnull
    RandomAccessFile getAccessFile() {
        this.checkClosed();
        return this.accessFile;
    }

    public byte getByte(long position) {
        this.checkClosed();
        return this.window.getByte(position);
    }

    public void clearCache() {
        this.listeners.forEach(listener -> listener.clearCache());
    }

    public void close() {
        this.checkClosed();
        try {
            this.accessFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(FileDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.closed = true;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("File was already closed");
        }
    }

    public void addCacheClearListener(CacheClearListener listener) {
        this.listeners.add(listener);
    }

    public void removeCacheClearListener(CacheClearListener listener) {
        this.listeners.remove(listener);
    }

    @ParametersAreNonnullByDefault
    public static enum EditMode {
        READ_WRITE("rw"),
        READ_ONLY("r");

        @Nonnull
        private final String fileAccessMode;

        private EditMode(String fileAccessMode) {
            this.fileAccessMode = fileAccessMode;
        }

        @Nonnull
        public String getFileAccessMode() {
            return this.fileAccessMode;
        }
    }

    public static interface CacheClearListener {
        public void clearCache();
    }
}

