/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service;

import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.exbin.framework.XBBaseApplication;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.preferences.PreferencesWrapper;
import org.exbin.xbup.core.parser.basic.XBHead;
import org.exbin.xbup.service.XBCatalogNetServiceServer;
import org.exbin.xbup.service.XBServiceInstance;

@ParametersAreNonnullByDefault
public class XBService {
    private XBService() {
    }

    public static void main(String[] args) {
        try {
            ResourceBundle recourceBundle = ResourceBundle.getBundle("org/exbin/xbup/service/XBService");
            Options opt = new Options();
            Logger logger = Logger.getLogger("");
            logger.setLevel(Level.ALL);
            opt.addOption("h", "help", false, recourceBundle.getString("cl_option_help"));
            opt.addOption("port", true, recourceBundle.getString("cl_option_port"));
            opt.addOption("ip", true, recourceBundle.getString("cl_option_ip"));
            opt.addOption("v", false, recourceBundle.getString("cl_option_verbose"));
            opt.addOption("nopref", false, recourceBundle.getString("cl_option_nopref"));
            opt.addOption("stop", false, recourceBundle.getString("cl_option_stop"));
            opt.addOption("log", true, recourceBundle.getString("cl_option_log"));
            opt.addOption("db", true, recourceBundle.getString("cl_option_db"));
            opt.addOption("rootcat", false, recourceBundle.getString("cl_option_rootcat"));
            opt.addOption("dev", false, recourceBundle.getString("cl_option_dev"));
            opt.addOption("update", false, recourceBundle.getString("cl_option_update"));
            BasicParser parser = new BasicParser();
            CommandLine cl = parser.parse(opt, args);
            if (cl.hasOption('h')) {
                logger.addHandler((Handler)new XBHead.XBLogHandler(false));
                logger.addHandler((Handler)new XBCatalogNetServiceServer.XBServiceLogHandler(true));
                Logger.getLogger(XBService.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, recourceBundle.getString("service_head"));
                Logger.getLogger(XBService.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, "");
                HelpFormatter f = new HelpFormatter();
                f.printHelp(recourceBundle.getString("cl_syntax"), opt);
            } else {
                boolean rootCatalogMode;
                XBBaseApplication app = new XBBaseApplication();
                app.setAppDirectory(XBService.class);
                Preferences preferences = app.createPreferences(XBService.class);
                boolean verboseMode = cl.hasOption("v") || Boolean.getBoolean(preferences.get("verbose", Boolean.toString(false)));
                boolean devMode = cl.hasOption("dev");
                boolean forceUpdate = cl.hasOption("update");
                if (devMode) {
                    Logger.getLogger(XBService.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, "Set development mode.");
                }
                if (rootCatalogMode = cl.hasOption("rootcat")) {
                    Logger.getLogger(XBService.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, "Set root catalog mode.");
                }
                String tcpipPort = cl.getOptionValue("port", preferences.get("tcpip_port", devMode ? String.valueOf(22595) : String.valueOf(22594)));
                String tcpipInterface = cl.getOptionValue("ip", preferences.get("tcpip_interface", "localhost"));
                logger.addHandler((Handler)new XBHead.XBLogHandler(verboseMode));
                logger.addHandler((Handler)new XBCatalogNetServiceServer.XBServiceLogHandler(true));
                XBServiceInstance server = new XBServiceInstance();
                server.setResourceBundle(recourceBundle);
                server.setDerbyPath(((PreferencesWrapper)preferences).getInnerPreferences().absolutePath());
                server.setTcpipInterface(tcpipInterface);
                server.setTcpipPort(tcpipPort);
                server.setDevMode(devMode);
                server.setVerboseMode(verboseMode);
                server.setForceUpdate(forceUpdate);
                server.setRootCatalogMode(rootCatalogMode);
                server.run();
            }
        }
        catch (ParseException ex) {
            Logger.getLogger(XBService.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

