/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JScrollPane;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.capability.ScrollingCapable;
import org.exbin.bined.swing.CodeAreaCommandHandler;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class DefaultCodeAreaMouseListener
extends MouseAdapter
implements MouseMotionListener,
MouseWheelListener {
    public static final int MOUSE_SCROLL_LINES = 3;
    private final CodeAreaCore codeArea;
    private final JScrollPane view;
    private final Cursor defaultCursor = Cursor.getDefaultCursor();
    private final Cursor textCursor = Cursor.getPredefinedCursor(2);
    private Cursor currentCursor;
    private boolean mouseDown = false;

    public DefaultCodeAreaMouseListener(CodeAreaCore codeArea, JScrollPane view) {
        this.codeArea = codeArea;
        this.view = view;
        this.currentCursor = codeArea.getCursor();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.codeArea.requestFocus();
        if (this.codeArea.isEnabled() && me.getButton() == 1) {
            this.moveCaret(me);
            this.mouseDown = true;
        }
    }

    private void moveCaret(MouseEvent me) {
        CodeAreaCommandHandler.SelectingMode selecting = (me.getModifiersEx() & 0x40) > 0 ? CodeAreaCommandHandler.SelectingMode.SELECTING : CodeAreaCommandHandler.SelectingMode.NONE;
        this.codeArea.getCommandHandler().moveCaret(this.computeRelativeX(me), this.computeRelativeY(me), selecting);
        ((ScrollingCapable)this.codeArea).revealCursor();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.mouseDown = false;
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.currentCursor = this.defaultCursor;
        this.codeArea.setCursor(this.defaultCursor);
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.updateMouseCursor(me);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.updateMouseCursor(me);
    }

    private void updateMouseCursor(MouseEvent me) {
        Cursor newCursor;
        int cursorShape = ((CaretCapable)this.codeArea).getMouseCursorShape(this.computeRelativeX(me), this.computeRelativeY(me));
        Cursor cursor = newCursor = cursorShape == 0 ? this.defaultCursor : this.textCursor;
        if (newCursor != this.currentCursor) {
            this.currentCursor = newCursor;
            this.codeArea.setCursor(newCursor);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.updateMouseCursor(me);
        if (this.codeArea.isEnabled() && this.mouseDown) {
            this.codeArea.getCommandHandler().moveCaret(this.computeRelativeX(me), this.computeRelativeY(me), CodeAreaCommandHandler.SelectingMode.SELECTING);
            ((ScrollingCapable)this.codeArea).revealCursor();
        }
    }

    private int computeRelativeX(MouseEvent me) {
        boolean isDataView = me.getSource() != this.codeArea;
        return isDataView ? me.getX() + this.view.getX() : me.getX();
    }

    private int computeRelativeY(MouseEvent me) {
        boolean isDataView = me.getSource() != this.codeArea;
        return isDataView ? me.getY() + this.view.getY() : me.getY();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent me) {
        if (!this.codeArea.isEnabled() || me.getWheelRotation() == 0) {
            return;
        }
        CodeAreaCommandHandler.ScrollbarOrientation orientation = me.isShiftDown() ? CodeAreaCommandHandler.ScrollbarOrientation.HORIZONTAL : CodeAreaCommandHandler.ScrollbarOrientation.VERTICAL;
        int scrollAmount = me.getWheelRotation() > 0 ? 3 : -3;
        this.codeArea.getCommandHandler().wheelScroll(scrollAmount, orientation);
    }
}

