/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import java.awt.HeadlessException;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.ByteArrayData;
import org.exbin.auxiliary.binary_data.ByteArrayEditableData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.auxiliary.binary_data.paged.PagedData;
import org.exbin.bined.CaretOverlapMode;
import org.exbin.bined.ClipboardHandlingMode;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.EditMode;
import org.exbin.bined.EditOperation;
import org.exbin.bined.SelectionRange;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.basic.CodeAreaScrollPosition;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.basic.EnterKeyHandlingMode;
import org.exbin.bined.basic.MovementDirection;
import org.exbin.bined.basic.ScrollingDirection;
import org.exbin.bined.basic.TabKeyHandlingMode;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.capability.CharsetCapable;
import org.exbin.bined.capability.ClipboardCapable;
import org.exbin.bined.capability.CodeCharactersCaseCapable;
import org.exbin.bined.capability.CodeTypeCapable;
import org.exbin.bined.capability.EditModeCapable;
import org.exbin.bined.capability.ScrollingCapable;
import org.exbin.bined.capability.SelectionCapable;
import org.exbin.bined.capability.ViewModeCapable;
import org.exbin.bined.swing.CodeAreaCommandHandler;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.CodeAreaSwingUtils;
import org.exbin.bined.swing.basic.DefaultCodeAreaCaret;

@ParametersAreNonnullByDefault
public class DefaultCodeAreaCommandHandler
implements CodeAreaCommandHandler {
    public static final String BINED_CLIPBOARD_MIME = "application/x-bined";
    public static final String BINED_CLIPBOARD_MIME_FULL = "application/x-bined; class=" + BinaryData.class.getCanonicalName();
    public static final int LAST_CONTROL_CODE = 31;
    private static final char DELETE_CHAR = '\u007f';
    private final int metaMask = CodeAreaSwingUtils.getMetaMaskDown();
    @Nonnull
    private final CodeAreaCore codeArea;
    @Nonnull
    private EnterKeyHandlingMode enterKeyHandlingMode = EnterKeyHandlingMode.PLATFORM_SPECIFIC;
    @Nonnull
    private TabKeyHandlingMode tabKeyHandlingMode = TabKeyHandlingMode.PLATFORM_SPECIFIC;
    private final boolean codeTypeSupported;
    private final boolean viewModeSupported;
    private Clipboard clipboard;
    private boolean canPaste = false;
    private CodeAreaSwingUtils.ClipboardData currentClipboardData = null;
    private DataFlavor binedDataFlavor;
    private DataFlavor binaryDataFlavor;

    public DefaultCodeAreaCommandHandler(CodeAreaCore codeArea) {
        this.codeArea = codeArea;
        this.codeTypeSupported = codeArea instanceof CodeTypeCapable;
        this.viewModeSupported = codeArea instanceof ViewModeCapable;
        this.clipboard = CodeAreaSwingUtils.getClipboard();
        try {
            this.clipboard.addFlavorListener(e -> this.updateCanPaste());
            this.binedDataFlavor = new DataFlavor(BinaryData.class, BINED_CLIPBOARD_MIME_FULL);
            try {
                this.binaryDataFlavor = new DataFlavor("application/octet-stream");
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.updateCanPaste();
        }
        catch (IllegalStateException ex) {
            this.canPaste = false;
        }
        catch (HeadlessException ex) {
            Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Nonnull
    public static CodeAreaCommandHandler.CodeAreaCommandHandlerFactory createDefaultCodeAreaCommandHandlerFactory() {
        return DefaultCodeAreaCommandHandler::new;
    }

    @Override
    public void undoSequenceBreak() {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.codeArea.isEnabled()) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 37: {
                this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.LEFT);
                this.undoSequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 39: {
                this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.RIGHT);
                this.undoSequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 38: {
                this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.UP);
                this.undoSequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 40: {
                this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.DOWN);
                this.undoSequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 36: {
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0) {
                    this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.DOC_START);
                } else {
                    this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.ROW_START);
                }
                this.undoSequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 35: {
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0) {
                    this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.DOC_END);
                } else {
                    this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.ROW_END);
                }
                this.undoSequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 33: {
                this.scroll(ScrollingDirection.PAGE_UP);
                this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.PAGE_UP);
                this.undoSequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 34: {
                this.scroll(ScrollingDirection.PAGE_DOWN);
                this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.PAGE_DOWN);
                this.undoSequenceBreak();
                keyEvent.consume();
                break;
            }
            case 155: {
                EditMode editMode = ((EditModeCapable)this.codeArea).getEditMode();
                if (editMode != EditMode.EXPANDING && editMode != EditMode.CAPPED) break;
                EditOperation editOperation = ((EditModeCapable)this.codeArea).getEditOperation();
                switch (editOperation) {
                    case INSERT: {
                        ((EditModeCapable)this.codeArea).setEditOperation(EditOperation.OVERWRITE);
                        keyEvent.consume();
                        break;
                    }
                    case OVERWRITE: {
                        ((EditModeCapable)this.codeArea).setEditOperation(EditOperation.INSERT);
                        keyEvent.consume();
                    }
                }
                break;
            }
            case 9: {
                this.tabPressed(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent));
                if (this.tabKeyHandlingMode == TabKeyHandlingMode.IGNORE) break;
                keyEvent.consume();
                break;
            }
            case 10: {
                this.enterPressed();
                if (this.enterKeyHandlingMode == EnterKeyHandlingMode.IGNORE) break;
                keyEvent.consume();
                break;
            }
            case 127: {
                EditMode editMode = ((EditModeCapable)this.codeArea).getEditMode();
                if (editMode != EditMode.EXPANDING) break;
                this.deletePressed();
                keyEvent.consume();
                break;
            }
            case 8: {
                EditMode editMode = ((EditModeCapable)this.codeArea).getEditMode();
                if (editMode != EditMode.EXPANDING) break;
                this.backSpacePressed();
                keyEvent.consume();
                break;
            }
            default: {
                if (((ClipboardCapable)this.codeArea).getClipboardHandlingMode() != ClipboardHandlingMode.PROCESS) break;
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0 && keyEvent.getKeyCode() == 67) {
                    this.copy();
                    keyEvent.consume();
                    break;
                }
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0 && keyEvent.getKeyCode() == 88) {
                    this.cut();
                    keyEvent.consume();
                    break;
                }
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0 && keyEvent.getKeyCode() == 86) {
                    this.paste();
                    keyEvent.consume();
                    break;
                }
                if ((keyEvent.getModifiersEx() & this.metaMask) <= 0 || keyEvent.getKeyCode() != 65) break;
                this.codeArea.selectAll();
                keyEvent.consume();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char keyValue = keyEvent.getKeyChar();
        if (keyValue == '\uffff') {
            return;
        }
        if (!this.checkEditAllowed()) {
            return;
        }
        CodeAreaSection section = ((CaretCapable)this.codeArea).getActiveSection();
        if (section == BasicCodeAreaSection.CODE_MATRIX) {
            int modifiersEx = keyEvent.getModifiersEx();
            if (modifiersEx == 0 || modifiersEx == 64) {
                this.pressedCharAsCode(keyValue);
            }
        } else {
            char keyChar = keyValue;
            if (keyChar > '\u001f' && keyValue != '\u007f') {
                this.pressedCharInPreview(keyChar);
            }
        }
    }

    private void pressedCharAsCode(char keyChar) {
        CodeType codeType;
        CodeAreaCaretPosition caretPosition = ((CaretCapable)this.codeArea).getCaretPosition();
        long dataPosition = caretPosition.getDataPosition();
        int codeOffset = caretPosition.getCodeOffset();
        boolean validKey = CodeAreaUtils.isValidCodeKeyValue((char)keyChar, (int)codeOffset, (CodeType)(codeType = this.getCodeType()));
        if (validKey) {
            EditMode editMode = ((EditModeCapable)this.codeArea).getEditMode();
            if (this.codeArea.hasSelection() && editMode != EditMode.INPLACE) {
                this.deleteSelection();
                this.undoSequenceBreak();
            }
            int value = keyChar >= '0' && keyChar <= '9' ? keyChar - 48 : Character.toLowerCase(keyChar) - 97 + 10;
            BinaryData data = (BinaryData)CodeAreaUtils.requireNonNullContentData((Object)this.codeArea.getContentData());
            EditOperation editOperation = ((EditModeCapable)this.codeArea).getActiveOperation();
            if (editMode == EditMode.EXPANDING && editOperation == EditOperation.INSERT) {
                if (codeOffset > 0) {
                    byte byteRest = data.getByte(dataPosition);
                    switch (codeType) {
                        case BINARY: {
                            byteRest = (byte)(byteRest & 255 >> codeOffset);
                            break;
                        }
                        case DECIMAL: {
                            byteRest = (byte)(byteRest % (codeOffset == 1 ? 100 : 10));
                            break;
                        }
                        case OCTAL: {
                            byteRest = (byte)(byteRest % (codeOffset == 1 ? 64 : 8));
                            break;
                        }
                        case HEXADECIMAL: {
                            byteRest = (byte)(byteRest & 0xF);
                            break;
                        }
                        default: {
                            throw CodeAreaUtils.getInvalidTypeException((Enum)codeType);
                        }
                    }
                    if (byteRest > 0) {
                        ((EditableBinaryData)data).insert(dataPosition + 1L, 1L);
                        ((EditableBinaryData)data).setByte(dataPosition, (byte)(data.getByte(dataPosition) - byteRest));
                        ((EditableBinaryData)data).setByte(dataPosition + 1L, byteRest);
                    }
                } else {
                    ((EditableBinaryData)data).insert(dataPosition, 1L);
                }
                this.setCodeValue(value);
            } else {
                if (editMode == EditMode.EXPANDING && editOperation == EditOperation.OVERWRITE && dataPosition == this.codeArea.getDataSize()) {
                    ((EditableBinaryData)data).insert(dataPosition, 1L);
                }
                if (editMode != EditMode.INPLACE || dataPosition < this.codeArea.getDataSize()) {
                    this.setCodeValue(value);
                }
            }
            this.codeArea.notifyDataChanged();
            this.move(CodeAreaCommandHandler.SelectingMode.NONE, MovementDirection.RIGHT);
            this.revealCursor();
        }
    }

    private void pressedCharInPreview(char keyChar) {
        if (this.isValidChar(keyChar)) {
            int length;
            EditMode editMode = ((EditModeCapable)this.codeArea).getEditMode();
            CodeAreaCaretPosition caretPosition = ((CaretCapable)this.codeArea).getCaretPosition();
            long dataPosition = caretPosition.getDataPosition();
            byte[] bytes = this.charToBytes(keyChar);
            if (editMode == EditMode.INPLACE && dataPosition + (long)(length = bytes.length) > this.codeArea.getDataSize()) {
                return;
            }
            if (this.codeArea.hasSelection() && editMode != EditMode.INPLACE) {
                this.undoSequenceBreak();
                this.deleteSelection();
            }
            BinaryData data = (BinaryData)CodeAreaUtils.requireNonNullContentData((Object)this.codeArea.getContentData());
            EditOperation editOperation = ((EditModeCapable)this.codeArea).getActiveOperation();
            if ((editMode == EditMode.EXPANDING && editOperation == EditOperation.OVERWRITE || editMode == EditMode.INPLACE) && dataPosition < this.codeArea.getDataSize()) {
                int length2 = bytes.length;
                if (dataPosition + (long)length2 > this.codeArea.getDataSize()) {
                    length2 = (int)(this.codeArea.getDataSize() - dataPosition);
                }
                ((EditableBinaryData)data).remove(dataPosition, (long)length2);
            }
            ((EditableBinaryData)data).insert(dataPosition, bytes);
            this.codeArea.notifyDataChanged();
            ((CaretCapable)this.codeArea).getCaret().setCaretPosition(dataPosition + (long)bytes.length - 1L);
            this.move(CodeAreaCommandHandler.SelectingMode.NONE, MovementDirection.RIGHT);
            this.revealCursor();
        }
    }

    private void setCodeValue(int value) {
        CodeAreaCaretPosition caretPosition = ((CaretCapable)this.codeArea).getCaretPosition();
        long dataPosition = caretPosition.getDataPosition();
        int codeOffset = caretPosition.getCodeOffset();
        BinaryData data = (BinaryData)CodeAreaUtils.requireNonNullContentData((Object)this.codeArea.getContentData());
        CodeType codeType = this.getCodeType();
        byte byteValue = data.getByte(dataPosition);
        byte outputValue = CodeAreaUtils.setCodeValue((byte)byteValue, (int)value, (int)codeOffset, (CodeType)codeType);
        ((EditableBinaryData)data).setByte(dataPosition, outputValue);
    }

    @Override
    public void enterPressed() {
        String sequence;
        if (!this.checkEditAllowed()) {
            return;
        }
        if (((CaretCapable)this.codeArea).getActiveSection() == BasicCodeAreaSection.TEXT_PREVIEW && !(sequence = this.enterKeyHandlingMode.getSequence()).isEmpty()) {
            this.pressedCharInPreview(sequence.charAt(0));
            if (sequence.length() == 2) {
                this.pressedCharInPreview(sequence.charAt(1));
            }
        }
    }

    @Override
    public void tabPressed() {
        this.tabPressed(CodeAreaCommandHandler.SelectingMode.NONE);
    }

    public void tabPressed(CodeAreaCommandHandler.SelectingMode selectingMode) {
        if (!this.checkEditAllowed()) {
            return;
        }
        if (this.tabKeyHandlingMode == TabKeyHandlingMode.PLATFORM_SPECIFIC || this.tabKeyHandlingMode == TabKeyHandlingMode.CYCLE_TO_NEXT_SECTION || this.tabKeyHandlingMode == TabKeyHandlingMode.CYCLE_TO_PREVIOUS_SECTION) {
            if (this.viewModeSupported && ((ViewModeCapable)this.codeArea).getViewMode() == CodeAreaViewMode.DUAL) {
                this.move(selectingMode, MovementDirection.SWITCH_SECTION);
                this.undoSequenceBreak();
                this.revealCursor();
            }
        } else if (((CaretCapable)this.codeArea).getActiveSection() == BasicCodeAreaSection.TEXT_PREVIEW) {
            String sequence = this.tabKeyHandlingMode == TabKeyHandlingMode.INSERT_TAB ? "\t" : "  ";
            this.pressedCharInPreview(sequence.charAt(0));
            if (sequence.length() == 2) {
                this.pressedCharInPreview(sequence.charAt(1));
            }
        }
    }

    @Override
    public void backSpacePressed() {
        if (!this.checkEditAllowed()) {
            return;
        }
        BinaryData data = (BinaryData)CodeAreaUtils.requireNonNullContentData((Object)this.codeArea.getContentData());
        if (this.codeArea.hasSelection()) {
            this.deleteSelection();
            this.codeArea.notifyDataChanged();
        } else {
            DefaultCodeAreaCaret caret = (DefaultCodeAreaCaret)((CaretCapable)this.codeArea).getCaret();
            long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
            if (dataPosition > 0L && dataPosition <= this.codeArea.getDataSize()) {
                caret.setCodeOffset(0);
                this.move(CodeAreaCommandHandler.SelectingMode.NONE, MovementDirection.LEFT);
                caret.setCodeOffset(0);
                ((EditableBinaryData)data).remove(dataPosition - 1L, 1L);
                this.codeArea.notifyDataChanged();
                ((CaretCapable)this.codeArea).setCaretPosition(caret.getCaretPosition());
                this.revealCursor();
                this.clearSelection();
            }
        }
    }

    @Override
    public void deletePressed() {
        if (!this.checkEditAllowed()) {
            return;
        }
        if (this.codeArea.hasSelection()) {
            this.deleteSelection();
            this.codeArea.notifyDataChanged();
            this.revealCursor();
        } else {
            BinaryData data = (BinaryData)CodeAreaUtils.requireNonNullContentData((Object)this.codeArea.getContentData());
            DefaultCodeAreaCaret caret = (DefaultCodeAreaCaret)((CaretCapable)this.codeArea).getCaret();
            long dataPosition = caret.getDataPosition();
            if (dataPosition < this.codeArea.getDataSize()) {
                ((EditableBinaryData)data).remove(dataPosition, 1L);
                this.codeArea.notifyDataChanged();
                if (caret.getCodeOffset() > 0) {
                    caret.setCodeOffset(0);
                }
                ((CaretCapable)this.codeArea).setCaretPosition(caret.getCaretPosition());
                this.clearSelection();
                this.revealCursor();
            }
        }
    }

    private void deleteSelection() {
        BinaryData data = this.codeArea.getContentData();
        if (!(data instanceof EditableBinaryData)) {
            throw new IllegalStateException("Data is not editable");
        }
        SelectionRange selection = ((SelectionCapable)this.codeArea).getSelection();
        if (selection.isEmpty()) {
            return;
        }
        EditMode editMode = ((EditModeCapable)this.codeArea).getEditMode();
        long first = selection.getFirst();
        long last = selection.getLast();
        long length = last - first + 1L;
        if (editMode == EditMode.INPLACE) {
            ((EditableBinaryData)data).fillData(first, length);
        } else {
            ((EditableBinaryData)data).remove(first, length);
        }
        ((CaretCapable)this.codeArea).setCaretPosition(first);
        this.clearSelection();
        this.revealCursor();
    }

    @Override
    public void delete() {
        if (!this.checkEditAllowed()) {
            return;
        }
        this.deleteSelection();
        this.codeArea.notifyDataChanged();
    }

    @Override
    public void copy() {
        SelectionRange selection = ((SelectionCapable)this.codeArea).getSelection();
        if (!selection.isEmpty()) {
            BinaryData data = this.codeArea.getContentData();
            long first = selection.getFirst();
            long last = selection.getLast();
            BinaryData copy = data.copy(first, last - first + 1L);
            Charset charset = this.codeArea instanceof CharsetCapable ? ((CharsetCapable)this.codeArea).getCharset() : null;
            CodeAreaSwingUtils.BinaryDataClipboardData binaryData = new CodeAreaSwingUtils.BinaryDataClipboardData(copy, this.binedDataFlavor, this.binaryDataFlavor, charset);
            this.setClipboardContent(binaryData);
        }
    }

    @Override
    public void copyAsCode() {
        SelectionRange selection = ((SelectionCapable)this.codeArea).getSelection();
        if (!selection.isEmpty()) {
            BinaryData data = this.codeArea.getContentData();
            long first = selection.getFirst();
            long last = selection.getLast();
            BinaryData copy = data.copy(first, last - first + 1L);
            CodeType codeType = ((CodeTypeCapable)this.codeArea).getCodeType();
            CodeCharactersCase charactersCase = ((CodeCharactersCaseCapable)this.codeArea).getCodeCharactersCase();
            CodeAreaSwingUtils.CodeDataClipboardData binaryData = new CodeAreaSwingUtils.CodeDataClipboardData(copy, this.binaryDataFlavor, codeType, charactersCase);
            this.setClipboardContent(binaryData);
        }
    }

    private void setClipboardContent(CodeAreaSwingUtils.ClipboardData content) {
        this.clearClipboardData();
        try {
            this.currentClipboardData = content;
            this.clipboard.setContents(content, content);
        }
        catch (IllegalStateException ex) {
            this.clearClipboardData();
        }
    }

    private void clearClipboardData() {
        if (this.currentClipboardData != null) {
            this.currentClipboardData.dispose();
            this.currentClipboardData = null;
        }
    }

    @Override
    public void cut() {
        if (!this.checkEditAllowed()) {
            return;
        }
        EditMode editMode = ((EditModeCapable)this.codeArea).getEditMode();
        SelectionRange selection = ((SelectionCapable)this.codeArea).getSelection();
        if (!selection.isEmpty()) {
            this.copy();
            if (editMode == EditMode.EXPANDING) {
                this.deleteSelection();
                this.codeArea.notifyDataChanged();
            }
        }
    }

    @Override
    public void paste() {
        block14: {
            if (!this.checkEditAllowed()) {
                return;
            }
            try {
                if (this.clipboard.isDataFlavorAvailable(this.binedDataFlavor)) {
                    try {
                        Object clipboardData = this.clipboard.getData(this.binedDataFlavor);
                        if (clipboardData instanceof BinaryData) {
                            this.pasteBinaryData((BinaryData)clipboardData);
                        }
                        break block14;
                    }
                    catch (UnsupportedFlavorException | IOException ex) {
                        Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break block14;
                }
                if (this.clipboard.isDataFlavorAvailable(this.binaryDataFlavor)) {
                    try {
                        Object clipboardData = this.clipboard.getData(this.binaryDataFlavor);
                        if (clipboardData instanceof InputStream) {
                            PagedData pastedData = new PagedData();
                            pastedData.insert(0L, (InputStream)clipboardData, -1L);
                            this.pasteBinaryData((BinaryData)pastedData);
                        }
                        break block14;
                    }
                    catch (UnsupportedFlavorException | IOException ex) {
                        Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break block14;
                }
                if (!this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) break block14;
                try {
                    Object clipboardData = this.clipboard.getData(DataFlavor.stringFlavor);
                    if (clipboardData instanceof String) {
                        DefaultCodeAreaCaret caret = (DefaultCodeAreaCaret)((CaretCapable)this.codeArea).getCaret();
                        long dataPosition = caret.getDataPosition();
                        byte[] bytes = ((String)clipboardData).getBytes(Charset.forName("UTF-8"));
                        ByteArrayData pastedData = new ByteArrayData(bytes);
                        this.pasteBinaryData((BinaryData)pastedData);
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private void pasteBinaryData(BinaryData pastedData) {
        long dataSize;
        BinaryData data = (BinaryData)CodeAreaUtils.requireNonNullContentData((Object)this.codeArea.getContentData());
        EditMode editMode = ((EditModeCapable)this.codeArea).getEditMode();
        EditOperation editOperation = ((EditModeCapable)this.codeArea).getActiveOperation();
        if (this.codeArea.hasSelection()) {
            this.deleteSelection();
            this.codeArea.notifyDataChanged();
        }
        DefaultCodeAreaCaret caret = (DefaultCodeAreaCaret)((CaretCapable)this.codeArea).getCaret();
        long dataPosition = caret.getDataPosition();
        long toRemove = dataSize = pastedData.getDataSize();
        if (editMode == EditMode.INPLACE) {
            if (dataPosition + toRemove > this.codeArea.getDataSize()) {
                toRemove = this.codeArea.getDataSize() - dataPosition;
            }
            ((EditableBinaryData)data).replace(dataPosition, pastedData, 0L, toRemove);
        } else {
            if (editMode == EditMode.EXPANDING && editOperation == EditOperation.OVERWRITE) {
                if (dataPosition + toRemove > this.codeArea.getDataSize()) {
                    toRemove = this.codeArea.getDataSize() - dataPosition;
                }
                ((EditableBinaryData)data).remove(dataPosition, toRemove);
            }
            ((EditableBinaryData)data).insert(dataPosition, pastedData);
            caret.setCaretPosition(caret.getDataPosition() + dataSize);
            this.updateSelection(CodeAreaCommandHandler.SelectingMode.NONE, caret.getCaretPosition());
        }
        caret.setCodeOffset(0);
        ((CaretCapable)this.codeArea).setCaretPosition(caret.getCaretPosition());
        this.undoSequenceBreak();
        this.codeArea.notifyDataChanged();
        this.revealCursor();
        this.clearSelection();
    }

    @Override
    public void pasteFromCode() {
        block15: {
            if (!this.checkEditAllowed()) {
                return;
            }
            BinaryData data = (BinaryData)CodeAreaUtils.requireNonNullContentData((Object)this.codeArea.getContentData());
            EditMode editMode = ((EditModeCapable)this.codeArea).getEditMode();
            EditOperation editOperation = ((EditModeCapable)this.codeArea).getActiveOperation();
            try {
                if (!this.clipboard.isDataFlavorAvailable(this.binaryDataFlavor) && !this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    return;
                }
            }
            catch (IllegalStateException ex) {
                return;
            }
            try {
                if (this.clipboard.isDataFlavorAvailable(this.binaryDataFlavor)) {
                    this.paste();
                    break block15;
                }
                if (!this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) break block15;
                if (this.codeArea.hasSelection()) {
                    this.deleteSelection();
                    this.codeArea.notifyDataChanged();
                }
                try {
                    Object insertedData = this.clipboard.getData(DataFlavor.stringFlavor);
                    if (insertedData instanceof String) {
                        long length;
                        DefaultCodeAreaCaret caret = (DefaultCodeAreaCaret)((CaretCapable)this.codeArea).getCaret();
                        long dataPosition = caret.getDataPosition();
                        CodeType codeType = this.getCodeType();
                        ByteArrayEditableData pastedData = new ByteArrayEditableData();
                        CodeAreaUtils.insertHexStringIntoData((String)((String)insertedData), (EditableBinaryData)pastedData, (CodeType)codeType);
                        long toRemove = length = pastedData.getDataSize();
                        if (editMode == EditMode.EXPANDING && editOperation == EditOperation.OVERWRITE || editMode == EditMode.INPLACE) {
                            if (dataPosition + toRemove > this.codeArea.getDataSize()) {
                                toRemove = this.codeArea.getDataSize() - dataPosition;
                            }
                            ((EditableBinaryData)data).remove(dataPosition, toRemove);
                        }
                        if (editMode == EditMode.INPLACE && length > toRemove) {
                            ((EditableBinaryData)data).insert(caret.getDataPosition(), (BinaryData)pastedData, 0L, toRemove);
                            caret.setCaretPosition(caret.getDataPosition() + toRemove);
                            this.updateSelection(CodeAreaCommandHandler.SelectingMode.NONE, caret.getCaretPosition());
                        } else {
                            ((EditableBinaryData)data).insert(caret.getDataPosition(), (BinaryData)pastedData);
                            caret.setCaretPosition(caret.getDataPosition() + length);
                            this.updateSelection(CodeAreaCommandHandler.SelectingMode.NONE, caret.getCaretPosition());
                        }
                        caret.setCodeOffset(0);
                        ((CaretCapable)this.codeArea).setCaretPosition(caret.getCaretPosition());
                        this.undoSequenceBreak();
                        this.codeArea.notifyDataChanged();
                        this.revealCursor();
                        this.clearSelection();
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean canPaste() {
        return this.canPaste;
    }

    @Nonnull
    public EnterKeyHandlingMode getEnterKeyHandlingMode() {
        return this.enterKeyHandlingMode;
    }

    public void setEnterKeyHandlingMode(EnterKeyHandlingMode enterKeyHandlingMode) {
        this.enterKeyHandlingMode = enterKeyHandlingMode;
    }

    @Nonnull
    public TabKeyHandlingMode getTabKeyHandlingMode() {
        return this.tabKeyHandlingMode;
    }

    public void setTabKeyHandlingMode(TabKeyHandlingMode tabKeyHandlingMode) {
        this.tabKeyHandlingMode = tabKeyHandlingMode;
    }

    @Override
    public void selectAll() {
        long dataSize = this.codeArea.getDataSize();
        if (dataSize > 0L) {
            ((SelectionCapable)this.codeArea).setSelection(0L, dataSize);
        }
    }

    @Override
    public void clearSelection() {
        long dataPosition = ((CaretCapable)this.codeArea).getCaretPosition().getDataPosition();
        ((SelectionCapable)this.codeArea).setSelection(dataPosition, dataPosition);
    }

    public void updateSelection(CodeAreaCommandHandler.SelectingMode selectingMode, CodeAreaCaretPosition caretPosition) {
        long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
        SelectionRange selection = ((SelectionCapable)this.codeArea).getSelection();
        if (selectingMode == CodeAreaCommandHandler.SelectingMode.SELECTING) {
            ((SelectionCapable)this.codeArea).setSelection(selection.getStart(), dataPosition);
        } else {
            ((SelectionCapable)this.codeArea).setSelection(dataPosition, dataPosition);
        }
    }

    private void updateCanPaste() {
        this.canPaste = CodeAreaSwingUtils.canPaste(this.clipboard, this.binaryDataFlavor);
    }

    @Override
    public void moveCaret(int positionX, int positionY, CodeAreaCommandHandler.SelectingMode selecting) {
        CodeAreaCaretPosition caretPosition = ((CaretCapable)this.codeArea).mousePositionToClosestCaretPosition(positionX, positionY, CaretOverlapMode.PARTIAL_OVERLAP);
        ((CaretCapable)this.codeArea).setCaretPosition(caretPosition);
        this.updateSelection(selecting, caretPosition);
        this.undoSequenceBreak();
        this.codeArea.repaint();
    }

    public void move(CodeAreaCommandHandler.SelectingMode selectingMode, MovementDirection direction) {
        CodeAreaCaretPosition movePosition;
        CodeAreaCaretPosition caretPosition = ((CaretCapable)this.codeArea).getCaretPosition();
        if (!caretPosition.equals(movePosition = ((CaretCapable)this.codeArea).computeMovePosition(caretPosition, direction))) {
            ((CaretCapable)this.codeArea).setCaretPosition(movePosition);
            this.updateSelection(selectingMode, movePosition);
        }
    }

    public void scroll(ScrollingDirection direction) {
        CodeAreaScrollPosition scrollPosition;
        CodeAreaScrollPosition sourcePosition = ((ScrollingCapable)this.codeArea).getScrollPosition();
        if (!sourcePosition.equals((Object)(scrollPosition = ((ScrollingCapable)this.codeArea).computeScrolling(sourcePosition, direction)))) {
            ((ScrollingCapable)this.codeArea).setScrollPosition(scrollPosition);
            this.codeArea.resetPainter();
        }
    }

    @Override
    public void wheelScroll(int scrollSize, CodeAreaCommandHandler.ScrollbarOrientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                if (scrollSize > 0) {
                    this.scroll(ScrollingDirection.LEFT);
                    break;
                }
                if (scrollSize >= 0) break;
                this.scroll(ScrollingDirection.RIGHT);
                break;
            }
            case VERTICAL: {
                if (scrollSize > 0) {
                    this.scroll(ScrollingDirection.DOWN);
                    break;
                }
                if (scrollSize >= 0) break;
                this.scroll(ScrollingDirection.UP);
            }
        }
    }

    public boolean isValidChar(char value) {
        return ((CharsetCapable)this.codeArea).getCharset().canEncode();
    }

    @Nonnull
    public byte[] charToBytes(char value) {
        ByteBuffer buffer = ((CharsetCapable)this.codeArea).getCharset().encode(Character.toString(value));
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes, 0, bytes.length);
        return bytes;
    }

    @Nonnull
    private CodeType getCodeType() {
        if (this.codeTypeSupported) {
            return ((CodeTypeCapable)this.codeArea).getCodeType();
        }
        return CodeType.HEXADECIMAL;
    }

    private void revealCursor() {
        ((ScrollingCapable)this.codeArea).revealCursor();
        this.codeArea.repaint();
    }

    @Override
    public boolean checkEditAllowed() {
        return this.codeArea.isEditable();
    }

    @Nonnull
    private static CodeAreaCommandHandler.SelectingMode isSelectingMode(KeyEvent keyEvent) {
        return (keyEvent.getModifiersEx() & 0x40) > 0 ? CodeAreaCommandHandler.SelectingMode.SELECTING : CodeAreaCommandHandler.SelectingMode.NONE;
    }
}

