/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import java.awt.Font;
import java.awt.Graphics;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.exbin.bined.CaretMovedListener;
import org.exbin.bined.CaretOverlapMode;
import org.exbin.bined.ClipboardHandlingMode;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeAreaSelection;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.DefaultCodeAreaCaretPosition;
import org.exbin.bined.EditMode;
import org.exbin.bined.EditModeChangedListener;
import org.exbin.bined.EditOperation;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.ScrollBarVisibility;
import org.exbin.bined.ScrollingListener;
import org.exbin.bined.SelectionChangedListener;
import org.exbin.bined.SelectionRange;
import org.exbin.bined.basic.BasicBackgroundPaintMode;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.basic.CodeAreaScrollPosition;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.basic.HorizontalScrollUnit;
import org.exbin.bined.basic.MovementDirection;
import org.exbin.bined.basic.ScrollingDirection;
import org.exbin.bined.basic.VerticalScrollUnit;
import org.exbin.bined.swing.CodeAreaCommandHandler;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.CodeAreaPainter;
import org.exbin.bined.swing.CodeAreaSwingControl;
import org.exbin.bined.swing.basic.AntialiasingMode;
import org.exbin.bined.swing.basic.DefaultCodeArea;
import org.exbin.bined.swing.basic.DefaultCodeAreaCaret;
import org.exbin.bined.swing.basic.DefaultCodeAreaCommandHandler;
import org.exbin.bined.swing.basic.DefaultCodeAreaPainter;
import org.exbin.bined.swing.basic.color.BasicCodeAreaColorsProfile;
import org.exbin.bined.swing.basic.color.BasicColorsCapableCodeAreaPainter;

@ParametersAreNonnullByDefault
public class CodeArea
extends CodeAreaCore
implements DefaultCodeArea,
CodeAreaSwingControl {
    @Nonnull
    private CodeAreaPainter painter;
    @Nonnull
    private final DefaultCodeAreaCaret caret;
    @Nonnull
    private final CodeAreaSelection selection = new CodeAreaSelection();
    @Nonnull
    private final CodeAreaScrollPosition scrollPosition = new CodeAreaScrollPosition();
    @Nonnull
    private Charset charset = Charset.forName("UTF-8");
    private ClipboardHandlingMode clipboardHandlingMode = ClipboardHandlingMode.PROCESS;
    @Nonnull
    private EditMode editMode = EditMode.EXPANDING;
    @Nonnull
    private EditOperation editOperation = EditOperation.OVERWRITE;
    @Nonnull
    private CodeAreaViewMode viewMode = CodeAreaViewMode.DUAL;
    @Nullable
    private Font codeFont;
    @Nonnull
    private BasicBackgroundPaintMode borderPaintMode = BasicBackgroundPaintMode.STRIPED;
    @Nonnull
    private AntialiasingMode antialiasingMode = AntialiasingMode.AUTO;
    @Nonnull
    private CodeType codeType = CodeType.HEXADECIMAL;
    @Nonnull
    private CodeCharactersCase codeCharactersCase = CodeCharactersCase.UPPER;
    private boolean showMirrorCursor = true;
    @Nonnull
    private RowWrappingMode rowWrapping = RowWrappingMode.NO_WRAPPING;
    private int minRowPositionLength = 0;
    private int maxRowPositionLength = 0;
    private int wrappingBytesGroupSize = 0;
    private int maxBytesPerRow = 16;
    @Nonnull
    private ScrollBarVisibility verticalScrollBarVisibility = ScrollBarVisibility.IF_NEEDED;
    @Nonnull
    private VerticalScrollUnit verticalScrollUnit = VerticalScrollUnit.ROW;
    @Nonnull
    private ScrollBarVisibility horizontalScrollBarVisibility = ScrollBarVisibility.IF_NEEDED;
    @Nonnull
    private HorizontalScrollUnit horizontalScrollUnit = HorizontalScrollUnit.PIXEL;
    private final List<CaretMovedListener> caretMovedListeners = new ArrayList<CaretMovedListener>();
    private final List<ScrollingListener> scrollingListeners = new ArrayList<ScrollingListener>();
    private final List<SelectionChangedListener> selectionChangedListeners = new ArrayList<SelectionChangedListener>();
    private final List<EditModeChangedListener> editModeChangedListeners = new ArrayList<EditModeChangedListener>();

    public CodeArea() {
        this(DefaultCodeAreaCommandHandler.createDefaultCodeAreaCommandHandlerFactory());
    }

    public CodeArea(CodeAreaCommandHandler.CodeAreaCommandHandlerFactory commandHandlerFactory) {
        super(commandHandlerFactory);
        this.caret = new DefaultCodeAreaCaret(this::notifyCaretChanged);
        this.painter = new DefaultCodeAreaPainter(this);
        this.painter.attach();
        this.init();
    }

    private void init() {
        UIManager.addPropertyChangeListener(evt -> this.resetColors());
        this.caret.setSection((CodeAreaSection)BasicCodeAreaSection.CODE_MATRIX);
    }

    @Nonnull
    public CodeAreaPainter getPainter() {
        return this.painter;
    }

    public void setPainter(CodeAreaPainter painter) {
        CodeAreaUtils.requireNonNull((Object)painter);
        this.painter.detach();
        this.painter = painter;
        painter.attach();
        this.reset();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.painter.paintComponent(g);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getBorder() == null) {
            super.setBorder(UIManager.getLookAndFeel().getDefaults().getBorder("TextAreaUI.border"));
        }
        this.painter.rebuildColors();
        this.painter.resetFont();
        this.painter.resetColors();
    }

    @Override
    public void setBorder(@Nullable Border border) {
        super.setBorder(border);
        this.updateLayout();
    }

    @Nonnull
    public DefaultCodeAreaCaret getCaret() {
        return this.caret;
    }

    public boolean isShowMirrorCursor() {
        return this.showMirrorCursor;
    }

    public void setShowMirrorCursor(boolean showMirrorCursor) {
        this.showMirrorCursor = showMirrorCursor;
        this.updateLayout();
    }

    public int getMinRowPositionLength() {
        return this.minRowPositionLength;
    }

    public void setMinRowPositionLength(int minRowPositionLength) {
        this.minRowPositionLength = minRowPositionLength;
        this.updateLayout();
    }

    public int getMaxRowPositionLength() {
        return this.maxRowPositionLength;
    }

    public void setMaxRowPositionLength(int maxRowPositionLength) {
        this.maxRowPositionLength = maxRowPositionLength;
        this.updateLayout();
    }

    public boolean isInitialized() {
        return this.painter.isInitialized();
    }

    public long getDataPosition() {
        return this.caret.getDataPosition();
    }

    public int getCodeOffset() {
        return this.caret.getCodeOffset();
    }

    @Nonnull
    public CodeAreaSection getActiveSection() {
        return this.caret.getSection();
    }

    @Nonnull
    public CodeAreaCaretPosition getCaretPosition() {
        return this.caret.getCaretPosition();
    }

    public void setCaretPosition(CodeAreaCaretPosition caretPosition) {
        this.caret.setCaretPosition(caretPosition);
        this.notifyCaretMoved();
    }

    public void setCaretPosition(long dataPosition) {
        this.caret.setCaretPosition(dataPosition);
        this.notifyCaretMoved();
    }

    public void setCaretPosition(long dataPosition, int codeOffset) {
        this.caret.setCaretPosition(dataPosition, codeOffset);
        this.notifyCaretMoved();
    }

    public int getMouseCursorShape(int positionX, int positionY) {
        return this.painter.getMouseCursorShape(positionX, positionY);
    }

    @Nonnull
    public CodeCharactersCase getCodeCharactersCase() {
        return this.codeCharactersCase;
    }

    public void setCodeCharactersCase(CodeCharactersCase codeCharactersCase) {
        this.codeCharactersCase = codeCharactersCase;
        this.updateLayout();
    }

    @Override
    public void resetColors() {
        this.painter.resetColors();
        this.repaint();
    }

    @Nonnull
    public CodeAreaViewMode getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(CodeAreaViewMode viewMode) {
        if (viewMode != this.viewMode) {
            this.viewMode = viewMode;
            switch (viewMode) {
                case CODE_MATRIX: {
                    this.caret.setSection((CodeAreaSection)BasicCodeAreaSection.CODE_MATRIX);
                    this.reset();
                    this.notifyCaretMoved();
                    break;
                }
                case TEXT_PREVIEW: {
                    this.caret.setSection((CodeAreaSection)BasicCodeAreaSection.TEXT_PREVIEW);
                    this.reset();
                    this.notifyCaretMoved();
                    break;
                }
                default: {
                    this.reset();
                }
            }
            this.updateLayout();
        }
    }

    @Nonnull
    public CodeType getCodeType() {
        return this.codeType;
    }

    public void setCodeType(CodeType codeType) {
        this.codeType = codeType;
        this.validateCaret();
        this.updateLayout();
    }

    public void validateCaret() {
        boolean moved = false;
        if (this.caret.getDataPosition() > this.getDataSize()) {
            this.caret.setDataPosition(this.getDataSize());
            moved = true;
        }
        if (this.caret.getSection() == BasicCodeAreaSection.CODE_MATRIX && this.caret.getCodeOffset() >= this.codeType.getMaxDigitsForByte()) {
            this.caret.setCodeOffset(this.codeType.getMaxDigitsForByte() - 1);
            moved = true;
        }
        if (moved) {
            this.notifyCaretMoved();
        }
    }

    public void revealCursor() {
        this.revealPosition(this.caret.getCaretPosition());
    }

    public void revealPosition(CodeAreaCaretPosition caretPosition) {
        if (!this.isInitialized()) {
            return;
        }
        Optional<CodeAreaScrollPosition> revealScrollPosition = this.painter.computeRevealScrollPosition(caretPosition);
        revealScrollPosition.ifPresent(this::setScrollPosition);
    }

    public void revealPosition(long dataPosition, int dataOffset, CodeAreaSection section) {
        this.revealPosition((CodeAreaCaretPosition)new DefaultCodeAreaCaretPosition(dataPosition, dataOffset, section));
    }

    public void centerOnCursor() {
        this.centerOnPosition(this.caret.getCaretPosition());
    }

    public void centerOnPosition(CodeAreaCaretPosition caretPosition) {
        if (!this.isInitialized()) {
            return;
        }
        Optional<CodeAreaScrollPosition> centerOnScrollPosition = this.painter.computeCenterOnScrollPosition(caretPosition);
        centerOnScrollPosition.ifPresent(this::setScrollPosition);
    }

    public void centerOnPosition(long dataPosition, int dataOffset, CodeAreaSection section) {
        this.centerOnPosition((CodeAreaCaretPosition)new DefaultCodeAreaCaretPosition(dataPosition, dataOffset, section));
    }

    @Nonnull
    public CodeAreaCaretPosition mousePositionToClosestCaretPosition(int positionX, int positionY, CaretOverlapMode overflowMode) {
        return this.painter.mousePositionToClosestCaretPosition(positionX, positionY, overflowMode);
    }

    @Nonnull
    public CodeAreaCaretPosition computeMovePosition(CodeAreaCaretPosition position, MovementDirection direction) {
        return this.painter.computeMovePosition(position, direction);
    }

    @Nonnull
    public CodeAreaScrollPosition computeScrolling(CodeAreaScrollPosition startPosition, ScrollingDirection scrollingShift) {
        return this.painter.computeScrolling(startPosition, scrollingShift);
    }

    public void updateScrollBars() {
        this.painter.updateScrollBars();
        this.repaint();
    }

    @Nonnull
    public CodeAreaScrollPosition getScrollPosition() {
        return this.scrollPosition;
    }

    public void setScrollPosition(CodeAreaScrollPosition scrollPosition) {
        if (!scrollPosition.equals((Object)this.scrollPosition)) {
            this.scrollPosition.setScrollPosition(scrollPosition);
            this.painter.scrollPositionModified();
            this.updateScrollBars();
            this.notifyScrolled();
        }
    }

    @Override
    public void updateScrollPosition(CodeAreaScrollPosition scrollPosition) {
        if (!scrollPosition.equals((Object)this.scrollPosition)) {
            this.scrollPosition.setScrollPosition(scrollPosition);
            this.repaint();
            this.notifyScrolled();
        }
    }

    @Nonnull
    public ScrollBarVisibility getVerticalScrollBarVisibility() {
        return this.verticalScrollBarVisibility;
    }

    public void setVerticalScrollBarVisibility(ScrollBarVisibility verticalScrollBarVisibility) {
        this.verticalScrollBarVisibility = verticalScrollBarVisibility;
        this.resetPainter();
        this.updateScrollBars();
    }

    @Nonnull
    public VerticalScrollUnit getVerticalScrollUnit() {
        return this.verticalScrollUnit;
    }

    public void setVerticalScrollUnit(VerticalScrollUnit verticalScrollUnit) {
        this.verticalScrollUnit = verticalScrollUnit;
        long rowPosition = this.scrollPosition.getRowPosition();
        if (verticalScrollUnit == VerticalScrollUnit.ROW) {
            this.scrollPosition.setRowOffset(0);
        }
        this.resetPainter();
        this.scrollPosition.setRowPosition(rowPosition);
        this.updateScrollBars();
        this.notifyScrolled();
    }

    @Nonnull
    public ScrollBarVisibility getHorizontalScrollBarVisibility() {
        return this.horizontalScrollBarVisibility;
    }

    public void setHorizontalScrollBarVisibility(ScrollBarVisibility horizontalScrollBarVisibility) {
        this.horizontalScrollBarVisibility = horizontalScrollBarVisibility;
        this.resetPainter();
        this.updateScrollBars();
    }

    @Nonnull
    public HorizontalScrollUnit getHorizontalScrollUnit() {
        return this.horizontalScrollUnit;
    }

    public void setHorizontalScrollUnit(HorizontalScrollUnit horizontalScrollUnit) {
        this.horizontalScrollUnit = horizontalScrollUnit;
        int charPosition = this.scrollPosition.getCharPosition();
        if (horizontalScrollUnit == HorizontalScrollUnit.CHARACTER) {
            this.scrollPosition.setCharOffset(0);
        }
        this.resetPainter();
        this.scrollPosition.setCharPosition(charPosition);
        this.updateScrollBars();
        this.notifyScrolled();
    }

    @Override
    public void reset() {
        this.painter.reset();
    }

    @Override
    public void updateLayout() {
        if (this.painter != null) {
            this.painter.resetLayout();
        }
        this.repaint();
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    @Override
    public void resetPainter() {
        this.painter.reset();
    }

    protected void notifyCaretChanged() {
        if (this.painter != null) {
            this.painter.resetCaret();
        }
        this.repaint();
    }

    @Override
    public void notifyDataChanged() {
        super.notifyDataChanged();
        this.updateLayout();
    }

    @Override
    @Nonnull
    public AntialiasingMode getAntialiasingMode() {
        return this.antialiasingMode;
    }

    @Override
    public void setAntialiasingMode(AntialiasingMode antialiasingMode) {
        this.antialiasingMode = antialiasingMode;
        this.reset();
        this.repaint();
    }

    @Nonnull
    public SelectionRange getSelection() {
        return this.selection.getRange();
    }

    public void setSelection(SelectionRange selectionRange) {
        this.selection.setRange((SelectionRange)CodeAreaUtils.requireNonNull((Object)selectionRange));
        this.notifySelectionChanged();
        this.repaint();
    }

    public void setSelection(long start, long end) {
        this.selection.setSelection(start, end);
        this.notifySelectionChanged();
        this.repaint();
    }

    @Override
    public void clearSelection() {
        this.selection.clearSelection();
        this.notifySelectionChanged();
        this.repaint();
    }

    @Override
    public boolean hasSelection() {
        return !this.selection.isEmpty();
    }

    @Nonnull
    public CodeAreaSelection getSelectionHandler() {
        return this.selection;
    }

    @Nonnull
    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        CodeAreaUtils.requireNonNull((Object)charset);
        this.charset = charset;
        this.reset();
        this.repaint();
    }

    @Override
    public boolean isEditable() {
        return this.editMode != EditMode.READ_ONLY;
    }

    @Nonnull
    public EditMode getEditMode() {
        return this.editMode;
    }

    public void setEditMode(EditMode editMode) {
        boolean changed = editMode != this.editMode;
        this.editMode = editMode;
        if (changed) {
            this.editModeChangedListeners.forEach(listener -> listener.editModeChanged(editMode, this.getActiveOperation()));
            this.caret.resetBlink();
            this.notifyCaretChanged();
            this.repaint();
        }
    }

    @Nonnull
    public EditOperation getActiveOperation() {
        switch (this.editMode) {
            case READ_ONLY: {
                return EditOperation.INSERT;
            }
            case INPLACE: {
                return EditOperation.OVERWRITE;
            }
            case CAPPED: 
            case EXPANDING: {
                return this.editOperation;
            }
        }
        throw CodeAreaUtils.getInvalidTypeException((Enum)this.editMode);
    }

    @Nonnull
    public EditOperation getEditOperation() {
        return this.editOperation;
    }

    public void setEditOperation(EditOperation editOperation) {
        boolean changed;
        EditOperation previousOperation = this.getActiveOperation();
        this.editOperation = editOperation;
        EditOperation currentOperation = this.getActiveOperation();
        boolean bl = changed = previousOperation != currentOperation;
        if (changed) {
            this.editModeChangedListeners.forEach(listener -> listener.editModeChanged(this.editMode, currentOperation));
            this.caret.resetBlink();
            this.notifyCaretChanged();
            this.repaint();
        }
    }

    @Nonnull
    public ClipboardHandlingMode getClipboardHandlingMode() {
        return this.clipboardHandlingMode;
    }

    public void setClipboardHandlingMode(ClipboardHandlingMode clipboardHandlingMode) {
        this.clipboardHandlingMode = clipboardHandlingMode;
    }

    @Override
    @Nonnull
    public Font getCodeFont() {
        return this.codeFont == null ? super.getFont() : this.codeFont;
    }

    @Override
    public void setCodeFont(Font codeFont) {
        this.codeFont = codeFont;
        this.painter.resetFont();
        this.repaint();
    }

    @Nonnull
    public BasicBackgroundPaintMode getBackgroundPaintMode() {
        return this.borderPaintMode;
    }

    public void setBackgroundPaintMode(BasicBackgroundPaintMode borderPaintMode) {
        this.borderPaintMode = borderPaintMode;
        this.updateLayout();
    }

    @Nonnull
    public RowWrappingMode getRowWrapping() {
        return this.rowWrapping;
    }

    public void setRowWrapping(RowWrappingMode rowWrapping) {
        this.rowWrapping = rowWrapping;
        this.updateLayout();
    }

    public int getWrappingBytesGroupSize() {
        return this.wrappingBytesGroupSize;
    }

    public void setWrappingBytesGroupSize(int groupSize) {
        this.wrappingBytesGroupSize = groupSize;
        this.updateLayout();
    }

    public int getMaxBytesPerRow() {
        return this.maxBytesPerRow;
    }

    public void setMaxBytesPerRow(int maxBytesPerRow) {
        this.maxBytesPerRow = maxBytesPerRow;
        this.updateLayout();
    }

    @Override
    @Nonnull
    public Optional<BasicCodeAreaColorsProfile> getBasicColors() {
        if (this.painter instanceof BasicColorsCapableCodeAreaPainter) {
            return Optional.of(((BasicColorsCapableCodeAreaPainter)((Object)this.painter)).getBasicColors());
        }
        return Optional.empty();
    }

    @Override
    public void setBasicColors(BasicCodeAreaColorsProfile colorsProfile) {
        if (this.painter instanceof BasicColorsCapableCodeAreaPainter) {
            ((BasicColorsCapableCodeAreaPainter)((Object)this.painter)).setBasicColors(colorsProfile);
        }
    }

    protected void notifySelectionChanged() {
        this.selectionChangedListeners.forEach(SelectionChangedListener::selectionChanged);
    }

    protected void notifyCaretMoved() {
        this.caretMovedListeners.forEach(caretMovedListener -> caretMovedListener.caretMoved(this.caret.getCaretPosition()));
    }

    protected void notifyScrolled() {
        this.painter.resetLayout();
        this.scrollingListeners.forEach(ScrollingListener::scrolled);
    }

    public void addSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        this.selectionChangedListeners.add(selectionChangedListener);
    }

    public void removeSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        this.selectionChangedListeners.remove(selectionChangedListener);
    }

    public void addCaretMovedListener(CaretMovedListener caretMovedListener) {
        this.caretMovedListeners.add(caretMovedListener);
    }

    public void removeCaretMovedListener(CaretMovedListener caretMovedListener) {
        this.caretMovedListeners.remove(caretMovedListener);
    }

    public void addScrollingListener(ScrollingListener scrollingListener) {
        this.scrollingListeners.add(scrollingListener);
    }

    public void removeScrollingListener(ScrollingListener scrollingListener) {
        this.scrollingListeners.remove(scrollingListener);
    }

    public void addEditModeChangedListener(EditModeChangedListener editModeChangedListener) {
        this.editModeChangedListeners.add(editModeChangedListener);
    }

    public void removeEditModeChangedListener(EditModeChangedListener editModeChangedListener) {
        this.editModeChangedListeners.remove(editModeChangedListener);
    }
}

